/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide.adapter;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.dsl.debug.StackFrame;
import org.eclipse.gemoc.dsl.debug.Thread;
import org.eclipse.gemoc.dsl.debug.ThreadUtils;
import org.eclipse.gemoc.dsl.debug.Variable;
import org.eclipse.gemoc.dsl.debug.ide.Activator;
import org.eclipse.gemoc.dsl.debug.ide.DSLEclipseDebugIntegration;
import org.eclipse.gemoc.dsl.debug.ide.adapter.AbstractDSLDebugElementAdapter;
import org.eclipse.gemoc.dsl.debug.ide.adapter.ILocator;

public class DSLStackFrameAdapter
extends AbstractDSLDebugElementAdapter
implements IStackFrame {
    private IThread thread;

    public DSLStackFrameAdapter(DSLEclipseDebugIntegration factory) {
        super(factory);
    }

    public boolean isAdapterForType(Object type) {
        return super.isAdapterForType(type) || type == IStackFrame.class;
    }

    public StackFrame getHost() {
        assert (this.target instanceof StackFrame);
        return (StackFrame)this.target;
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IThread getThread() {
        if (this.thread == null) {
            Thread hostThread = ThreadUtils.getThread((StackFrame)this.getHost());
            if (hostThread == null) {
                throw new IllegalStateException("can't addapt Thread to IThread.");
            }
            Thread thread = hostThread;
            synchronized (thread) {
                this.thread = (IThread)this.factory.adapt((Notifier)hostThread, IThread.class);
            }
            if (this.thread == null) {
                throw new IllegalStateException("can't addapt Thread to IThread.");
            }
        }
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVariable[] getVariables() throws DebugException {
        ArrayList<IVariable> res = new ArrayList<IVariable>();
        Iterator iterator = this.getHost().getVariables().iterator();
        while (iterator.hasNext()) {
            Variable variable;
            Variable variable2 = variable = (Variable)iterator.next();
            synchronized (variable2) {
                IVariable var = (IVariable)this.factory.adapt((Notifier)variable, IVariable.class);
                if (var == null) {
                    throw new IllegalStateException("can't addapt Variable to IVariable.");
                }
                res.add(var);
            }
        }
        return res.toArray(new IVariable[res.size()]);
    }

    public boolean hasVariables() throws DebugException {
        return this.getHost().getVariables().size() > 0;
    }

    public int getLineNumber() throws DebugException {
        EObject context = this.getCurrentInstruction();
        int result = -1;
        for (ILocator locator : Activator.getDefault().retrieveLocators()) {
            ILocator.Location location = locator.getLocation(context);
            switch (location.type) {
                case XTEXT_LOCATION: {
                    result = (Integer)location.data;
                    break;
                }
            }
            if (result != -1) break;
        }
        return result;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        return this.getHost().getName();
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return this.getHost().getRegisterGroups().size() > 0;
    }

    public EObject getCurrentInstruction() {
        return this.getHost().getCurrentInstruction();
    }

    public EObject getContext() {
        return this.getHost().getContext();
    }
}

