/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide.sirius.ui.launch;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gemoc.dsl.debug.ide.adapter.IDSLCurrentInstructionListener;
import org.eclipse.gemoc.dsl.debug.ide.sirius.ui.services.AbstractDSLDebuggerServices;
import org.eclipse.gemoc.dsl.debug.ide.ui.launch.AbstractDSLLaunchConfigurationDelegateUI;
import org.eclipse.gemoc.dsl.debug.ide.ui.launch.DSLLaunchConfigurationTab;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractDSLLaunchConfigurationDelegateSiriusUI
extends AbstractDSLLaunchConfigurationDelegateUI {
    public static final String SIRIUS_RESOURCE_URI = "airdResource";

    protected ILaunchConfiguration[] createLaunchConfiguration(IResource file, EObject firstInstruction, String mode) throws CoreException {
        ILaunchConfiguration[] res;
        if ("aird".equals(file.getFileExtension())) {
            IResource semanticFile;
            if (firstInstruction != null) {
                semanticFile = this.getLaunchableResource((ISelection)new StructuredSelection((Object)firstInstruction));
                res = super.createLaunchConfiguration(semanticFile, firstInstruction, mode);
            } else {
                Session session = SessionManager.INSTANCE.getSession(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IProgressMonitor)new NullProgressMonitor());
                session.getSemanticResources();
                EObject selectedInstruction = DSLLaunchConfigurationTab.openFirstInstructionSelection((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ResourceSet)session.getTransactionalEditingDomain().getResourceSet());
                if (selectedInstruction != null) {
                    semanticFile = this.getLaunchableResource((ISelection)new StructuredSelection((Object)selectedInstruction));
                    res = super.createLaunchConfiguration(semanticFile, selectedInstruction, mode);
                } else {
                    semanticFile = null;
                    res = super.createLaunchConfiguration(file, firstInstruction, mode);
                }
            }
            ILaunchConfiguration[] iLaunchConfigurationArray = res;
            int n = res.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (config instanceof ILaunchConfigurationWorkingCopy) {
                    ((ILaunchConfigurationWorkingCopy)config).setAttribute(SIRIUS_RESOURCE_URI, file.getFullPath().toString());
                    if (semanticFile != null) {
                        IResource[] resources = config.getMappedResources();
                        resources = Arrays.copyOf(resources, resources.length + 1);
                        resources[resources.length - 1] = file;
                        ((ILaunchConfigurationWorkingCopy)config).setMappedResources(resources);
                    }
                    ((ILaunchConfigurationWorkingCopy)config).doSave();
                }
                ++n2;
            }
        } else {
            res = super.createLaunchConfiguration(file, firstInstruction, mode);
        }
        return res;
    }

    protected List<IDSLCurrentInstructionListener> getCurrentInstructionListeners() {
        List res = super.getCurrentInstructionListeners();
        res.add(AbstractDSLDebuggerServices.LISTENER);
        return res;
    }
}

