/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.templates;

import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.BaseProjectWizardFields;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.templates.AbstractChoiceOption;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.templates.AbstractTemplateSection;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.templates.BlankField;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.templates.BooleanOption;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.templates.ComboChoiceOption;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.templates.RadioChoiceOption;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.templates.StringOption;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.templates.TemplateOption;

public abstract class BaseOptionTemplateSection
extends AbstractTemplateSection {
    private Hashtable<String, TemplateOption> options = new Hashtable();

    protected TemplateOption addOption(String name, String label, boolean value, int pageIndex) {
        BooleanOption option = new BooleanOption(this, name, label);
        this.registerOption(option, value ? Boolean.TRUE : Boolean.FALSE, pageIndex);
        return option;
    }

    protected TemplateOption addOption(String name, String label, String value, int pageIndex) {
        StringOption option = new StringOption(this, name, label);
        this.registerOption(option, value, pageIndex);
        return option;
    }

    protected TemplateOption addOption(String name, String label, String toolTip, String value, int pageIndex) {
        StringOption option = new StringOption(this, name, label, toolTip);
        this.registerOption(option, value, pageIndex);
        return option;
    }

    protected TemplateOption addOption(String name, String label, String[][] choices, String value, int pageIndex) {
        AbstractChoiceOption option = choices.length == 2 ? new RadioChoiceOption(this, name, label, choices) : new ComboChoiceOption(this, name, label, choices);
        this.registerOption(option, value, pageIndex);
        return option;
    }

    protected ComboChoiceOption addComboChoiceOption(String name, String label, String[][] choices, String value, int pageIndex) {
        ComboChoiceOption option = new ComboChoiceOption(this, name, label, choices);
        this.registerOption(option, value, pageIndex);
        return option;
    }

    protected TemplateOption addBlankField(int pageIndex) {
        BlankField field = new BlankField(this);
        this.registerOption(field, "", pageIndex);
        return field;
    }

    protected TemplateOption addBlankField(int height, int pageIndex) {
        BlankField field = new BlankField(this, height);
        this.registerOption(field, "", pageIndex);
        return field;
    }

    protected void initializeOption(String name, Object value) {
        TemplateOption option = this.getOption(name);
        if (option != null && option.getValue() == null) {
            option.setValue(value);
        }
    }

    public String getStringOption(String name) {
        TemplateOption option = this.options.get(name);
        if (option != null) {
            if (option instanceof StringOption) {
                return ((StringOption)option).getText();
            }
            if (option instanceof AbstractChoiceOption) {
                Object value = option.getValue();
                if (value instanceof String) {
                    return (String)value;
                }
                if (value != null) {
                    return value.toString();
                }
            }
        }
        return null;
    }

    public boolean getBooleanOption(String key) {
        TemplateOption option = this.options.get(key);
        if (option != null && option instanceof BooleanOption) {
            return ((BooleanOption)option).isSelected();
        }
        return false;
    }

    public void setOptionEnabled(String name, boolean enabled) {
        TemplateOption option = this.options.get(name);
        if (option != null) {
            option.setEnabled(enabled);
        }
    }

    @Override
    public Object getValue(String name) {
        TemplateOption option = this.options.get(name);
        if (option != null) {
            return option.getValue();
        }
        return super.getValue(name);
    }

    public boolean isDependentOnParentWizard() {
        return false;
    }

    protected void initializeFields(BaseProjectWizardFields data) {
    }

    public abstract void validateOptions(TemplateOption var1);

    @Override
    public String getReplacementString(String fileName, String key) {
        String value = this.getStringOption(key);
        if (value != null) {
            return value;
        }
        return super.getReplacementString(fileName, key);
    }

    @Override
    public void execute(IProject project, IProgressMonitor monitor) throws CoreException {
        super.execute(project, monitor);
    }

    protected void registerOption(TemplateOption option, Object value, int pageIndex) {
        option.setValue(value);
        this.options.put(option.getName(), option);
    }

    private TemplateOption getOption(String key) {
        return this.options.get(key);
    }
}

