/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.pde.manifest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChangerExportPackage;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChangerPluginDependency;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChangerSingleton;
import org.osgi.framework.BundleException;

public class ManifestChanger {
    private IFile _manifestFile;
    private Manifest _manifest;

    public ManifestChanger(IFile manifestFile) {
        this._manifestFile = manifestFile;
    }

    public ManifestChanger(IProject project) {
        this(project.getFile((IPath)new Path("META-INF/MANIFEST.MF")));
    }

    private void loadManifest(InputStream in) throws IOException {
        try {
            this._manifest = new Manifest(in);
        }
        finally {
            in.close();
        }
    }

    public Manifest getManifest() throws IOException, CoreException {
        if (this._manifest == null) {
            this._manifest = new Manifest();
            this.loadManifest(this._manifestFile.getContents());
        }
        return this._manifest;
    }

    public void commit() throws IOException, CoreException {
        this.writeManifest(this._manifestFile);
    }

    private void writeManifest(OutputStream out) throws IOException {
        StringBuilder builder = new StringBuilder();
        String vername = Attributes.Name.MANIFEST_VERSION.toString();
        String version = this._manifest.getMainAttributes().getValue(vername);
        if (version == null) {
            vername = Attributes.Name.SIGNATURE_VERSION.toString();
            version = this._manifest.getMainAttributes().getValue(vername);
        }
        if (version != null) {
            builder.append(String.valueOf(vername) + ": " + version + "\r\n");
        }
        for (Map.Entry<Object, Object> pairs : this._manifest.getMainAttributes().entrySet()) {
            Object key = pairs.getKey();
            String keyString = key.toString();
            Object value = pairs.getValue();
            if (version == null || keyString.equalsIgnoreCase(vername)) continue;
            builder.append(keyString);
            builder.append(": ");
            if ((keyString.equals("Require-Bundle") || keyString.equals("Export-Package")) && value instanceof String && !((String)value).contains("\n")) {
                String val = (String)value;
                String newVal = val.replaceAll(",", ",\n ");
                builder.append(newVal);
            } else {
                builder.append(value);
            }
            builder.append("\n");
        }
        out.write(builder.toString().getBytes());
    }

    private void writeManifest(IFile outputFile) throws IOException, CoreException {
        if (this._manifest != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.writeManifest(out);
            ByteArrayInputStream is = new ByteArrayInputStream(out.toByteArray());
            try {
                if (outputFile.exists()) {
                    if (!ManifestChanger.isStreamEqual(is, outputFile.getContents(true))) {
                        outputFile.setContents((InputStream)new ByteArrayInputStream(out.toByteArray()), true, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                } else {
                    outputFile.create((InputStream)is, true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void addPluginDependency(String plugin) throws BundleException, IOException, CoreException {
        if (plugin == null || plugin.isEmpty()) {
            return;
        }
        ManifestChangerPluginDependency dependency = new ManifestChangerPluginDependency(this);
        dependency.add(plugin);
    }

    public void addPluginDependency(String plugin, String version, boolean reexport, boolean overwrite) throws BundleException, IOException, CoreException {
        ManifestChangerPluginDependency dependency = new ManifestChangerPluginDependency(this);
        dependency.add(plugin, version, reexport, overwrite);
    }

    public void addExportPackage(String packageName) throws BundleException, IOException, CoreException {
        if (packageName == null || packageName.isEmpty()) {
            return;
        }
        ManifestChangerExportPackage exportPackageMFChanger = new ManifestChangerExportPackage(this);
        exportPackageMFChanger.add(packageName);
    }

    public void addSingleton() throws BundleException, IOException, CoreException {
        ManifestChangerSingleton singleton = new ManifestChangerSingleton(this);
        singleton.apply();
    }

    public void addAttributes(String attributeName, String value) {
        this._manifest.getMainAttributes().putValue(attributeName, value);
    }

    private static boolean isStreamEqual(InputStream i1, InputStream i2) throws IOException {
        ReadableByteChannel ch1 = Channels.newChannel(i1);
        ReadableByteChannel ch2 = Channels.newChannel(i2);
        ByteBuffer buf1 = ByteBuffer.allocateDirect(1024);
        ByteBuffer buf2 = ByteBuffer.allocateDirect(1024);
        try {
            while (true) {
                int n1 = ch1.read(buf1);
                int n2 = ch2.read(buf2);
                if (n1 == -1 || n2 == -1) {
                    boolean bl = n1 == n2;
                    return bl;
                }
                buf1.flip();
                buf2.flip();
                int i = 0;
                if (i < Math.min(n1, n2)) {
                }
                buf1.compact();
                buf2.compact();
            }
        }
        finally {
            if (i1 != null) {
                i1.close();
            }
            if (i2 != null) {
                i2.close();
            }
        }
    }
}

