/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.addon.stategraph.views;

import java.util.Map;
import java.util.Set;
import javafx.beans.value.ObservableValue;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Cursor;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.gemoc.addon.stategraph.Activator;
import org.eclipse.gemoc.addon.stategraph.layout.StateGraphLayoutCommand;
import org.eclipse.gemoc.addon.stategraph.logic.StateGraph;
import org.eclipse.gemoc.addon.stategraph.logic.StateVertex;
import org.eclipse.gemoc.addon.stategraph.views.StateGraphRenderer;
import org.eclipse.gemoc.executionframework.ui.views.engine.EngineSelectionDependentViewPart;
import org.eclipse.gemoc.executionframework.ui.views.engine.actions.AbstractEngineAction;
import org.eclipse.gemoc.trace.gemoc.api.IMultiDimensionalTraceAddon;
import org.eclipse.gemoc.trace.gemoc.api.ITraceListener;
import org.eclipse.gemoc.trace.gemoc.traceaddon.AbstractTraceAddon;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;

public class StateGraphViewPart
extends EngineSelectionDependentViewPart {
    public static final String ID = "org.eclipse.gemoc.addon.multidimensional.timeline.views.timeline.StateGraphViewPart";
    private FXCanvas fxCanvas;
    private StateGraphRenderer renderer;
    private StateGraph stateGraph;
    private Pane root;
    private double mouseX;
    private double mouseY;

    public StateGraph getStateGraph() {
        return this.stateGraph;
    }

    public void engineSelectionChanged(IExecutionEngine<?> engine) {
        if (engine != null) {
            engine.getAddonsTypedBy(IMultiDimensionalTraceAddon.class).stream().findFirst().ifPresent(addon -> {
                IMultiDimensionalTraceAddon traceAddon = addon;
                this.stateGraph = new StateGraph();
                this.stateGraph.setTraceExtractor(traceAddon.getTraceExtractor());
                this.stateGraph.setTraceExplorer(traceAddon.getTraceExplorer());
                traceAddon.getTraceNotifier().addListener((ITraceListener)this.stateGraph);
                this.renderer.setStateGraph(this.stateGraph);
                this.stateGraph.update();
            });
        }
    }

    private void setupRoot() {
        this.stateGraph = new StateGraph();
        this.renderer = new StateGraphRenderer(this.stateGraph, new StateGraphLayoutCommand((IWorkbenchPart)this));
        this.root.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)}));
        this.root.getChildren().add((Object)this.renderer);
        this.renderer.minWidthProperty().bind((ObservableValue)this.root.widthProperty());
        this.renderer.prefWidthProperty().bind((ObservableValue)this.root.widthProperty());
        this.renderer.maxWidthProperty().bind((ObservableValue)this.root.widthProperty());
        this.renderer.minHeightProperty().bind((ObservableValue)this.root.heightProperty());
        this.renderer.prefHeightProperty().bind((ObservableValue)this.root.heightProperty());
        this.renderer.maxHeightProperty().bind((ObservableValue)this.root.heightProperty());
        this.root.setOnMousePressed(event -> {
            this.root.setCursor(Cursor.MOVE);
            this.mouseX = event.getX();
            this.mouseY = event.getY();
            event.consume();
        });
        this.root.setOnMouseReleased(event -> this.root.setCursor(Cursor.DEFAULT));
        this.root.setOnMouseDragged(event -> {
            double deltaX = event.getX() - this.mouseX;
            double deltaY = event.getY() - this.mouseY;
            this.renderer.setTranslateX(this.renderer.getTranslateX() + deltaX);
            this.renderer.setTranslateY(this.renderer.getTranslateY() + deltaY);
            this.mouseX = event.getX();
            this.mouseY = event.getY();
            event.consume();
        });
    }

    public void createPartControl(Composite parent) {
        this.fxCanvas = new FXCanvas(parent, 0);
        this.root = new Pane();
        Scene scene = new Scene((Parent)this.root);
        this.fxCanvas.setScene(scene);
        this.setupRoot();
        this.buildMenu(parent.getShell());
    }

    private void buildMenu(final Shell shell) {
        this.addActionToToolbar((Action)new AbstractEngineAction(2){

            protected void init() {
                super.init();
                this.setText("Toggle Cycle Coloration");
                this.setToolTipText("Toggle Cycle Coloration");
                ImageDescriptor id = Activator.imageDescriptorFromPlugin((String)"org.eclipse.gemoc.addon.stategraph", (String)"icons/cycle_coloration.gif");
                this.setImageDescriptor(id);
                this.setEnabled(true);
            }

            public void engineSelectionChanged(IExecutionEngine<?> engine) {
            }

            public void run() {
                StateGraphViewPart.this.renderer.setCycleColorationEnabled(this.isChecked());
            }
        });
        this.addActionToToolbar((Action)new AbstractEngineAction(1){

            protected void init() {
                super.init();
                this.setText("Refresh Layout");
                this.setToolTipText("Refresh Layout");
                ImageDescriptor id = Activator.imageDescriptorFromPlugin((String)"org.eclipse.gemoc.addon.stategraph", (String)"icons/refresh_layout.gif");
                this.setImageDescriptor(id);
                this.setEnabled(true);
            }

            public void engineSelectionChanged(IExecutionEngine<?> engine) {
            }

            public void run() {
                StateGraphViewPart.this.renderer.forceLayout();
            }
        });
        this.addActionToToolbar((Action)new AbstractEngineAction(1){
            private FileDialog fileDialog;

            protected void init() {
                super.init();
                this.setText("Open Trace");
                this.setToolTipText("Open Trace");
                ImageDescriptor id = Activator.imageDescriptorFromPlugin((String)"org.eclipse.gemoc.addon.stategraph", (String)"icons/jload_obj.gif");
                this.setImageDescriptor(id);
                this.setEnabled(true);
                this.fileDialog = new FileDialog(shell, 4096);
                this.fileDialog.setFilterExtensions(new String[]{"*.trace"});
            }

            public void engineSelectionChanged(IExecutionEngine<?> engine) {
            }

            public void run() {
                this.fileDialog.setText("Open Trace");
                String filePath = this.fileDialog.open();
                if (filePath != null && !filePath.equals("")) {
                    Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
                    Map m = reg.getExtensionToFactoryMap();
                    m.put("trace", new XMIResourceFactoryImpl());
                    ResourceSetImpl resSet = new ResourceSetImpl();
                    URI filePath1URI = URI.createFileURI((String)filePath);
                    Resource traceResource = resSet.getResource(filePath1URI, true);
                    EcoreUtil.resolveAll((Resource)traceResource);
                    AbstractTraceAddon newTraceAddon = null;
                    try {
                        IExtensionRegistry extReg = Platform.getExtensionRegistry();
                        IExtensionPoint ep = extReg.getExtensionPoint("org.eclipse.gemoc.gemoc_language_workbench.engine_addon");
                        IExtension[] extensions = ep.getExtensions();
                        int i = 0;
                        while (i < extensions.length && newTraceAddon == null) {
                            IExtension ext = extensions[i];
                            IConfigurationElement[] confElements = ext.getConfigurationElements();
                            int j = 0;
                            while (j < confElements.length) {
                                AbstractTraceAddon obj_cast;
                                Object obj;
                                IConfigurationElement confElement = confElements[j];
                                String attr = confElement.getAttribute("Class");
                                if (attr != null && (obj = confElement.createExecutableExtension("Class")) instanceof AbstractTraceAddon && (obj_cast = (AbstractTraceAddon)obj).isAddonForTrace((EObject)traceResource.getContents().get(0))) {
                                    newTraceAddon = obj_cast;
                                    break;
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    if (newTraceAddon != null) {
                        newTraceAddon.load(traceResource);
                        StateGraphViewPart.this.stateGraph.setTraceExtractor(newTraceAddon.getTraceExtractor());
                        StateGraphViewPart.this.stateGraph.update();
                    }
                }
            }
        });
    }

    private void addActionToToolbar(Action action) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)action);
    }

    public Set<StateVertex> getMovedVertice() {
        return this.renderer.getMovedVertice();
    }

    public void setFocus() {
        if (this.fxCanvas != null) {
            this.fxCanvas.setFocus();
        }
    }
}

