/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxgraph.ui.hyperlinking;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fx.ide.fxgraph.fXGraph.ComponentDefinition;
import org.eclipse.fx.ide.fxgraph.fXGraph.ControllerHandledValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.FXGraphPackage;
import org.eclipse.fx.ide.fxgraph.fXGraph.Model;
import org.eclipse.fx.ide.model.FXPlugin;
import org.eclipse.fx.ide.model.IFXCtrlClass;
import org.eclipse.fx.ide.model.IFXCtrlEventMethod;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.PartInitException;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.common.types.xtext.ui.TypeAwareHyperlinkHelper;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkAcceptor;

public class FXGraphHyperlinkHelper
extends TypeAwareHyperlinkHelper {
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;
    @Inject
    private IJavaProjectProvider javaProjectProvider;

    private IType getJDTType(JvmType jvmTypeRef) {
        try {
            IJavaProject javaProject = this.javaProjectProvider.getJavaProject(jvmTypeRef.eResource().getResourceSet());
            return javaProject.findType(jvmTypeRef.getQualifiedName());
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    public IHyperlink[] createHyperlinksByOffset(XtextResource resource, int offset, boolean createMultipleHyperlinks) {
        ICompositeNode n;
        IHyperlink[] links = super.createHyperlinksByOffset(resource, offset, createMultipleHyperlinks);
        EObject eo = this.eObjectAtOffsetHelper.resolveElementAt(resource, offset);
        if (eo instanceof ControllerHandledValueProperty && (n = NodeModelUtils.getNode((EObject)eo)) != null) {
            ILeafNode currentNode = NodeModelUtils.findLeafNodeAtOffset((INode)n, (int)offset);
            List l = NodeModelUtils.findNodesForFeature((EObject)eo, (EStructuralFeature)FXGraphPackage.Literals.CONTROLLER_HANDLED_VALUE_PROPERTY__METHODNAME);
            if (l.contains(currentNode)) {
                IFXCtrlEventMethod fxp;
                IFXCtrlClass fxClass;
                IType t;
                ComponentDefinition def;
                Region region = new Region(currentNode.getOffset(), currentNode.getLength());
                Model m = (Model)eo.eResource().getContents().get(0);
                if (m != null && (def = m.getComponentDef()) != null && def.getController() != null && def.getController().getType() != null && (t = this.getJDTType(def.getController().getType())) != null && (fxClass = FXPlugin.getClassmodel().findCtrlClass(t.getJavaProject(), t)) != null && (fxp = (IFXCtrlEventMethod)fxClass.getAllEventMethods().get(currentNode.getText())) != null) {
                    HyperlinkImpl h = new HyperlinkImpl((IRegion)region, fxp.getJavaElement());
                    if (links == null || links.length == 0) {
                        return new IHyperlink[]{h};
                    }
                    IHyperlink[] rv = new IHyperlink[links.length + 1];
                    System.arraycopy(links, 0, rv, 0, rv.length);
                    rv[rv.length - 1] = h;
                    return rv;
                }
            }
        }
        return links;
    }

    public void createHyperlinksTo(XtextResource from, Region region, EObject to, IHyperlinkAcceptor acceptor) {
        super.createHyperlinksTo(from, region, to, acceptor);
    }

    static class HyperlinkImpl
    implements IHyperlink {
        private final IRegion region;
        private final IJavaElement element;

        public HyperlinkImpl(IRegion region, IJavaElement element) {
            this.region = region;
            this.element = element;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getTypeLabel() {
            return null;
        }

        public String getHyperlinkText() {
            return null;
        }

        public void open() {
            try {
                JavaUI.openInEditor((IJavaElement)this.element);
            }
            catch (JavaModelException | PartInitException e) {
                e.printStackTrace();
            }
        }
    }
}

