/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalog;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.wizards.Operation;
import org.eclipse.epp.internal.mpc.ui.wizards.SelectionModel;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;

public class SelectionModelStateSerializer {
    private final SelectionModel selectionModel;
    private final MarketplaceCatalog catalog;

    public SelectionModelStateSerializer(MarketplaceCatalog catalog, SelectionModel selectionModel) {
        this.catalog = catalog;
        this.selectionModel = selectionModel;
    }

    public String serialize() {
        StringBuilder state = new StringBuilder(1024);
        for (Map.Entry<CatalogItem, org.eclipse.epp.mpc.ui.Operation> entry : this.selectionModel.getItemToSelectedOperation().entrySet()) {
            if (entry.getValue() == org.eclipse.epp.mpc.ui.Operation.NONE) continue;
            if (state.length() > 0) {
                state.append(' ');
            }
            INode data = (INode)entry.getKey().getData();
            state.append(data.getId());
            state.append('=');
            state.append(entry.getValue().name());
        }
        return state.toString();
    }

    @Deprecated
    public void deserialize(IProgressMonitor monitor, String state, Map<String, Operation> operationByNodeIdExtras) {
        HashMap<String, org.eclipse.epp.mpc.ui.Operation> operationByNodeId = new HashMap<String, org.eclipse.epp.mpc.ui.Operation>();
        Iterator<Map.Entry<String, Operation>> iterator = operationByNodeIdExtras.entrySet().iterator();
        while (iterator.hasNext()) {
            Operation op;
            Map.Entry<String, Operation> entry;
            operationByNodeId.put(entry.getKey(), (op = (entry = iterator.next()).getValue()) == null ? null : op.getOperation());
        }
        this.deserialize(state, operationByNodeId, monitor);
    }

    public void deserialize(String state, Map<String, org.eclipse.epp.mpc.ui.Operation> operationByNodeExtras, IProgressMonitor monitor) {
        HashMap<String, org.eclipse.epp.mpc.ui.Operation> operationByNodeId = new HashMap<String, org.eclipse.epp.mpc.ui.Operation>();
        if (state != null && state.length() > 0) {
            Pattern pattern = Pattern.compile("([^\\s=]+)=(\\S+)");
            Matcher matcher = pattern.matcher(state);
            while (matcher.find()) {
                String nodeId = matcher.group(1);
                String operationName = matcher.group(2);
                org.eclipse.epp.mpc.ui.Operation operation = org.eclipse.epp.mpc.ui.Operation.valueOf(operationName);
                operationByNodeId.put(nodeId, operation);
            }
        }
        if (operationByNodeExtras != null) {
            operationByNodeId.putAll(operationByNodeExtras);
        }
        if (!operationByNodeId.isEmpty()) {
            this.catalog.performQuery(monitor, operationByNodeId.keySet());
            for (CatalogItem item : this.catalog.getItems()) {
                MarketplaceNodeCatalogItem nodeItem;
                org.eclipse.epp.mpc.ui.Operation operation;
                if (!(item instanceof MarketplaceNodeCatalogItem) || (operation = (org.eclipse.epp.mpc.ui.Operation)((Object)operationByNodeId.get((nodeItem = (MarketplaceNodeCatalogItem)item).getData().getId()))) == null || operation == org.eclipse.epp.mpc.ui.Operation.NONE) continue;
                if (nodeItem.isInstalled() && operation == org.eclipse.epp.mpc.ui.Operation.INSTALL) {
                    operation = org.eclipse.epp.mpc.ui.Operation.UPDATE;
                }
                this.selectionModel.select((CatalogItem)nodeItem, operation);
            }
        }
    }

    @Deprecated
    public void deserialize(IProgressMonitor monitor, String state) {
        this.deserialize(state, monitor);
    }

    public void deserialize(String state, IProgressMonitor monitor) {
        this.deserialize(state, null, monitor);
    }
}

