/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.ast.AstPackage;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecoretools.ale.core.interpreter.ALEEngine;
import org.eclipse.emf.ecoretools.ale.core.interpreter.DiagnosticLogger;
import org.eclipse.emf.ecoretools.ale.core.interpreter.EvalEnvironment;
import org.eclipse.emf.ecoretools.ale.core.interpreter.ExtensionEnvironment;
import org.eclipse.emf.ecoretools.ale.core.interpreter.services.EvalBodyService;
import org.eclipse.emf.ecoretools.ale.core.interpreter.services.ServiceCallListener;
import org.eclipse.emf.ecoretools.ale.core.parser.Dsl;
import org.eclipse.emf.ecoretools.ale.core.parser.DslBuilder;
import org.eclipse.emf.ecoretools.ale.core.parser.visitor.ParseResult;
import org.eclipse.emf.ecoretools.ale.debug.DebugQueryEnvironment;
import org.eclipse.emf.ecoretools.ale.debug.ILookupEngineListener;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationPackage;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.sirius.common.tools.api.interpreter.ClassLoadingCallback;
import org.eclipse.sirius.common.tools.api.interpreter.EPackageLoadingCallback;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterWithDiagnostic;
import org.eclipse.sirius.common.tools.api.interpreter.JavaExtensionsManager;

public class ALEInterpreter
implements AutoCloseable {
    public static final String NO_MAIN_ERROR = "No operation with @main found";
    IQueryEnvironment queryEnvironment;
    public JavaExtensionsManager javaExtensions;
    EPackageLoadingCallback ePackageCallBack;
    protected boolean isClosed = false;
    private final ClassLoadingCallback callback = new ClassLoadingCallback(){

        public void loaded(String qualifiedName, Class<?> clazz) {
            ServiceUtils.registerServices((IQueryEnvironment)ALEInterpreter.this.queryEnvironment, (Set)ServiceUtils.getServices((IReadOnlyQueryEnvironment)ALEInterpreter.this.queryEnvironment, clazz));
        }

        public void notFound(String qualifiedName) {
        }

        public void unloaded(String qualifiedName, Class<?> clazz) {
            ServiceUtils.removeServices((IQueryEnvironment)ALEInterpreter.this.queryEnvironment, (Set)ServiceUtils.getServices((IReadOnlyQueryEnvironment)ALEInterpreter.this.queryEnvironment, clazz));
        }
    };
    DiagnosticLogger logger;
    List<ServiceCallListener> serviceListeners;
    ALEEngine currentEngine;

    public ALEInterpreter() {
        this(false);
    }

    public ALEInterpreter(boolean isDebugMode) {
        this.queryEnvironment = this.createQueryEnvironment(isDebugMode, null);
        this.queryEnvironment.registerEPackage((EPackage)ImplementationPackage.eINSTANCE);
        this.queryEnvironment.registerEPackage((EPackage)AstPackage.eINSTANCE);
        this.ePackageCallBack = new EPackageLoadingCallback(){

            public void loaded(String nsURI, EPackage pak) {
                ALEInterpreter.this.queryEnvironment.registerEPackage(pak);
            }

            public void unloaded(String nsURI, EPackage pak) {
                ALEInterpreter.this.queryEnvironment.removeEPackage(pak);
            }
        };
        this.javaExtensions = JavaExtensionsManager.createManagerWithOverride();
        this.javaExtensions.addClassLoadingCallBack(this.callback);
        this.javaExtensions.addEPackageCallBack(this.ePackageCallBack);
        this.serviceListeners = new ArrayList<ServiceCallListener>();
    }

    private IQueryEnvironment createQueryEnvironment(boolean isDebug, CrossReferenceProvider xRefProvider) {
        ExtensionEnvironment newEnv = new ExtensionEnvironment();
        newEnv.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        newEnv.registerCustomClassMapping((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry(), EStringToStringMapEntryImpl.class);
        if (isDebug) {
            DebugQueryEnvironment debugQryEnv = new DebugQueryEnvironment((IQueryEnvironment)newEnv);
            debugQryEnv.registerListener(new ILookupEngineListener(){

                @Override
                public void preLookup(String name, IType[] argumentTypes) {
                }

                @Override
                public void postLookup(IService foundService) {
                    if (foundService instanceof EvalBodyService) {
                        System.out.println("Call : " + foundService.getLongSignature());
                    }
                }
            });
            return debugQryEnv;
        }
        return newEnv;
    }

    public IInterpreterWithDiagnostic.IEvaluationResult eval(String modelURI, List<Object> args, Dsl dsl) throws ClosedALEInterpreterException {
        List parsedSemantics = new DslBuilder(this.queryEnvironment).parse(dsl);
        Resource model = this.loadModel(modelURI);
        EObject caller = (EObject)model.getContents().get(0);
        return this.eval(caller, args, parsedSemantics);
    }

    public IInterpreterWithDiagnostic.IEvaluationResult eval(EObject caller, List<Object> args, List<ParseResult<ModelUnit>> parsedSemantics) throws ClosedALEInterpreterException {
        return this.eval(caller, null, args, parsedSemantics);
    }

    public IInterpreterWithDiagnostic.IEvaluationResult eval(EObject caller, Method calledOp, List<Object> args, List<ParseResult<ModelUnit>> parsedSemantics) throws ClosedALEInterpreterException {
        if (this.isClosed) {
            throw new ClosedALEInterpreterException("ALEInterpreter has been closed");
        }
        final BasicDiagnostic diagnostic = new BasicDiagnostic();
        parsedSemantics.stream().filter(parseResult -> parseResult.getDiagnostic().getSeverity() != 0).forEach(parseResult -> diagnostic.merge(parseResult.getDiagnostic()));
        this.logger = new DiagnosticLogger(parsedSemantics);
        if (calledOp == null) {
            calledOp = this.firstOperationTaggedMain(parsedSemantics);
        }
        Object value = null;
        if (calledOp != null) {
            EvaluationResult evalResult = this.doEval(caller, calledOp, args, parsedSemantics);
            if (evalResult.getDiagnostic().getSeverity() != 0) {
                diagnostic.merge(evalResult.getDiagnostic());
            }
            value = evalResult.getResult();
        } else {
            BasicDiagnostic child = new BasicDiagnostic(4, "interpreter", 0, NO_MAIN_ERROR, new Object[]{caller});
            diagnostic.add((Diagnostic)child);
        }
        final Object dumbFinal = value;
        return new IInterpreterWithDiagnostic.IEvaluationResult(){

            public Object getValue() {
                return dumbFinal;
            }

            public Diagnostic getDiagnostic() {
                List children = diagnostic.getChildren();
                if (children.size() == 1) {
                    return (Diagnostic)children.get(0);
                }
                return diagnostic;
            }
        };
    }

    private EvaluationResult doEval(EObject caller, Method operation, List<Object> args, List<ParseResult<ModelUnit>> parsedSemantics) {
        ALEEngine engine;
        List allBehaviors = parsedSemantics.stream().filter(sem -> sem.getRoot() != null).map(sem -> (ModelUnit)sem.getRoot()).collect(Collectors.toList());
        List<String> services = parsedSemantics.stream().map(unit -> (ModelUnit)unit.getRoot()).filter(root -> root != null).flatMap(root -> root.getServices().stream()).collect(Collectors.toList());
        this.registerServices(services);
        EvalEnvironment env = new EvalEnvironment(this.queryEnvironment, allBehaviors, this.logger, this.serviceListeners);
        ArrayList<Object> inputElems = new ArrayList<Object>();
        inputElems.add(caller);
        inputElems.addAll(args);
        this.initDynamicFeatures(inputElems, env);
        this.currentEngine = engine = new ALEEngine(env);
        return engine.eval(caller, operation, args);
    }

    private Method firstOperationTaggedMain(List<ParseResult<ModelUnit>> semantics) {
        return semantics.stream().filter(sem -> sem.getRoot() != null).map(sem -> this.getMainOp((ModelUnit)sem.getRoot())).filter(op -> op.isPresent()).map(op -> (Method)op.get()).findFirst().orElse(null);
    }

    private void initDynamicFeatures(List<Object> inputElems, EvalEnvironment env) {
        HashSet accessibleInputElements = new HashSet();
        Set<Resource> allResources = inputElems.stream().filter(elem -> elem instanceof EObject).map(elem -> ((EObject)elem).eResource()).filter(res -> res != null).collect(Collectors.toSet());
        allResources.forEach(res -> res.getAllContents().forEachRemaining(e -> {
            boolean bl = accessibleInputElements.add(e);
        }));
        inputElems.stream().filter(elem -> elem instanceof EObject).filter(elem -> ((EObject)elem).eResource() == null).forEach(elem -> {
            boolean bl = accessibleInputElements.add((EObject)elem);
        });
        env.initialize(accessibleInputElements);
    }

    private Optional<Method> getMainOp(ModelUnit implem) {
        return implem.getClassExtensions().stream().flatMap(cls -> cls.getMethods().stream()).filter(op -> op.getTags().contains((Object)"main")).findFirst();
    }

    public IQueryEnvironment getQueryEnvironment() {
        return this.queryEnvironment;
    }

    public DiagnosticLogger getLogger() {
        return this.logger;
    }

    public Resource loadModel(String modelURI) {
        ResourceSetImpl modelRs = new ResourceSetImpl();
        modelRs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        this.queryEnvironment.getEPackageProvider().getRegisteredEPackages().stream().forEach(arg_0 -> ALEInterpreter.lambda$21((ResourceSet)modelRs, arg_0));
        URI uri = URI.createURI((String)modelURI);
        return modelRs.getResource(uri, true);
    }

    public void registerServices(List<String> services) {
        services.forEach(srv -> this.javaExtensions.addImport(srv));
        this.javaExtensions.reloadIfNeeded();
    }

    public void initScope(Set<String> plugins, Set<String> project) {
        this.javaExtensions.updateScope(plugins, project);
        this.javaExtensions.reloadIfNeeded();
    }

    public void addListener(ServiceCallListener listener) {
        this.serviceListeners.add(listener);
    }

    public List<ServiceCallListener> getServiceListeners() {
        return this.serviceListeners;
    }

    public ALEEngine getCurrentEngine() {
        return this.currentEngine;
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.queryEnvironment.removeEPackage((EPackage)ImplementationPackage.eINSTANCE);
        this.queryEnvironment.removeEPackage((EPackage)AstPackage.eINSTANCE);
        this.javaExtensions.removeClassLoadingCallBack(this.callback);
        this.javaExtensions.removeEPackageCallBack(this.ePackageCallBack);
        this.javaExtensions.dispose();
    }

    private static /* synthetic */ void lambda$21(ResourceSet resourceSet, EPackage pkg) {
        resourceSet.getPackageRegistry().put((Object)pkg.getNsURI(), (Object)pkg);
    }

    public class ClosedALEInterpreterException
    extends Exception {
        private static final long serialVersionUID = -8494003054984405449L;

        public ClosedALEInterpreterException(String string) {
            super(string);
        }
    }
}

