/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.ide.ui.launchconfig;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecoretools.ale.ALEInterpreter;
import org.eclipse.emf.ecoretools.ale.core.parser.Dsl;
import org.eclipse.emf.ecoretools.ale.ide.WorkbenchDsl;
import org.eclipse.emf.ecoretools.ale.ide.ui.Activator;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterWithDiagnostic;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class RunModelAction {
    public static void launch(Shell shell, IResource dslFile) {
        FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(shell, false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
        dialog.setTitle("Resource Selection");
        dialog.setInitialPattern("*.xmi");
        Optional<IResource> siblingXmi = RunModelAction.findSiblingXmi(dslFile);
        siblingXmi.ifPresent(iResource -> dialog.setInitialSelections(new Object[]{iResource}));
        dialog.open();
        Object[] selected = dialog.getResult();
        if (selected != null && selected.length == 1 && selected[0] instanceof IResource) {
            RunModelAction.launch(dslFile, (IResource)selected[0]);
        }
    }

    public static void launch(final IResource dslFile, IResource modelFile) {
        String dslProject = dslFile.getProject().getName();
        final String modelLocation = modelFile.getLocationURI().toString();
        String modelProject = modelFile.getProject().getName();
        final HashSet<String> projects = new HashSet<String>();
        final HashSet plugins = new HashSet();
        projects.add(dslProject);
        projects.add(modelProject);
        Job evalJob = new Job("AQL Eval"){

            protected IStatus run(IProgressMonitor monitor) {
                MessageConsole console = RunModelAction.findConsole("ALE Console");
                PrintStream oldOut = System.out;
                try {
                    System.setOut(new PrintStream((OutputStream)console.newMessageStream()));
                    System.out.println("\nRun " + dslFile.getName());
                    System.out.println("------------");
                    Thread execThread = new Thread("Aql eval thread"){

                        @Override
                        public void run() {
                            try {
                                Throwable throwable = null;
                                Object var2_4 = null;
                                try (ALEInterpreter interpreter = new ALEInterpreter();){
                                    interpreter.javaExtensions.updateScope(plugins, projects);
                                    interpreter.javaExtensions.reloadIfNeeded();
                                    IInterpreterWithDiagnostic.IEvaluationResult result = interpreter.eval(modelLocation, new ArrayList(), (Dsl)new WorkbenchDsl(dslFile.getLocationURI().getPath()));
                                    interpreter.getLogger().diagnosticForHuman();
                                    if (result.getDiagnostic().getMessage() != null) {
                                        System.out.println(result.getDiagnostic().getMessage());
                                    }
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (IOException | ALEInterpreter.ClosedALEInterpreterException e) {
                                e.printStackTrace();
                                Activator.error(e.getMessage(), e);
                            }
                            this.stop();
                        }
                    };
                    execThread.start();
                    while (execThread.isAlive()) {
                        if (monitor.isCanceled()) {
                            execThread.stop();
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            execThread.stop();
                            Status status = new Status(8, "org.eclipse.emf.ecoretools.ale.ide.ui", "Execution thread has been interrupted", (Throwable)e);
                            System.setOut(oldOut);
                            return status;
                        }
                    }
                    if (execThread.isAlive()) {
                        execThread.stop();
                    }
                }
                finally {
                    System.setOut(oldOut);
                }
                return Status.OK_STATUS;
            }
        };
        evalJob.schedule();
    }

    private static MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    private static Optional<IResource> findSiblingXmi(IResource dslFile) {
        Stream<IResource> siblings;
        try {
            siblings = Arrays.stream(dslFile.getParent().members());
        }
        catch (NullPointerException | CoreException e) {
            return Optional.empty();
        }
        return siblings.filter(sibling -> "xmi".equalsIgnoreCase(sibling.getFileExtension())).findAny();
    }
}

