/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.ide.ui.launchconfig;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;

public class AleLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    Text dslSelection;
    Text modelSelection;

    public void createControl(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        area.setLayout((Layout)gl);
        area.layout();
        this.setControl((Control)area);
        Group dslArea = this.createGroup(area, "DSL location");
        this.createDslWidgets((Composite)dslArea);
        Group modelArea = this.createGroup(area, "Model to run");
        this.createModelWidgets((Composite)modelArea);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("DSL_FILE", "");
        configuration.setAttribute("MODEL_FILE", "");
        try {
            configuration.doSave();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.dslSelection.setText(configuration.getAttribute("DSL_FILE", ""));
            this.modelSelection.setText(configuration.getAttribute("MODEL_FILE", ""));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("DSL_FILE", this.dslSelection.getText());
        configuration.setAttribute("MODEL_FILE", this.modelSelection.getText());
    }

    public String getName() {
        return "ALE Launch Tab";
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String dslName = this.dslSelection.getText().trim();
        String modelName = this.modelSelection.getText().trim();
        if (!dslName.isEmpty() && !modelName.isEmpty()) {
            IResource dslFile = workspace.getRoot().findMember(dslName);
            IResource modelFile = workspace.getRoot().findMember(modelName);
            if (dslFile == null || !dslFile.exists()) {
                return false;
            }
            if (modelFile == null || !modelFile.exists()) {
                return false;
            }
        }
        return true;
    }

    private Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 0);
        group.setText(text);
        GridLayout locationLayout = new GridLayout();
        locationLayout.numColumns = 3;
        locationLayout.marginHeight = 10;
        locationLayout.marginWidth = 10;
        group.setLayout((Layout)locationLayout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        return group;
    }

    private void createModelWidgets(Composite parent) {
        this.modelSelection = new Text(parent, 2052);
        this.modelSelection.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.modelSelection.addModifyListener(modifyEvent -> this.updateLaunchConfigurationDialog());
        Button modelLocationButton = this.createPushButton(parent, "Browse", null);
        modelLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ResourceListSelectionDialog dialog = new ResourceListSelectionDialog(shell, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
                dialog.setTitle("Model Selection");
                if (dialog.open() == 0) {
                    Object[] selected = dialog.getResult();
                    AleLaunchConfigurationTab.this.modelSelection.setText(((IResource)selected[0]).getFullPath().toPortableString());
                }
            }
        });
    }

    private void createDslWidgets(Composite parent) {
        this.dslSelection = new Text(parent, 2052);
        this.dslSelection.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dslSelection.addModifyListener(modifyEvent -> this.updateLaunchConfigurationDialog());
        Button dslLocationButton = this.createPushButton(parent, "Browse", null);
        dslLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ResourceListSelectionDialog dialog = new ResourceListSelectionDialog(shell, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
                dialog.setTitle("DSL Selection");
                if (dialog.open() == 0) {
                    Object[] selected = dialog.getResult();
                    AleLaunchConfigurationTab.this.dslSelection.setText(((IResource)selected[0]).getFullPath().toPortableString());
                }
            }
        });
    }
}

