/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.validation;

import java.util.LinkedList;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;

final class QualifiedNames {
    private QualifiedNames() {
    }

    public static String getQualifiedName(EClassifier cls) {
        return String.valueOf(QualifiedNames.getQualifiedName(cls.getEPackage())) + "::" + cls.getName();
    }

    public static String getQualifiedName(EPackage pkg) {
        LinkedList<EPackage> pkgs = new LinkedList<EPackage>();
        EPackage current = pkg;
        while (current != null) {
            pkgs.addFirst(current);
            current = current.getESuperPackage();
        }
        return pkgs.stream().map(p -> p.getName()).collect(Collectors.joining("::"));
    }

    public static String getQualifiedName(IType type) {
        if (type instanceof EClassifierType) {
            EClassifier cls = ((EClassifierType)type).getType();
            return QualifiedNames.getQualifiedName(cls);
        }
        return type.toString();
    }
}

