/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.interpreter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.lookup.basic.BasicLookupEngine;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.ale.core.interpreter.services.EvalBodyService;
import org.eclipse.emf.ecoretools.ale.implementation.BehavioredClass;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;

public class ExtensionLookupEngine
extends BasicLookupEngine {
    public ExtensionLookupEngine(IReadOnlyQueryEnvironment queryEnvironment) {
        super(queryEnvironment);
    }

    private List<IService> lookupAll(String name, IType[] argumentTypes) {
        List multiMethod = this.getServices().getMultiService(name, argumentTypes.length);
        if (multiMethod == null) {
            return null;
        }
        ArrayList<IService> candidates = new ArrayList<IService>();
        for (IService service : multiMethod) {
            if (!service.matches(this.queryEnvironment, argumentTypes)) continue;
            candidates.add(service);
        }
        return candidates;
    }

    public IService lookup(String name, IType[] argumentTypes) {
        List<IService> candidates;
        if (name.equals("selectedCall") && argumentTypes.length >= 4) {
            boolean isMatching;
            EClassifier eObject = (EClassifier)this.queryEnvironment.getEPackageProvider().getTypes("EObject").iterator().next();
            ClassType stringType = new ClassType(this.queryEnvironment, String.class);
            boolean bl = isMatching = argumentTypes[0].getType() instanceof EObject && argumentTypes[1].getType() == String.class && argumentTypes[2].getType() == String.class && argumentTypes[3].getType() == String.class;
            if (isMatching) {
                return (IService)this.getServices().getMultiService(name, 5).get(0);
            }
        }
        if ((candidates = this.lookupAll(name, argumentTypes)) == null) {
            return null;
        }
        return this.selectBestCandidate(candidates, argumentTypes);
    }

    public IService filteredLookup(String modelUnitID, String className, String name, IType[] argumentTypes) {
        List<IService> candidates = this.lookupAll(name, argumentTypes);
        if (candidates == null) {
            return null;
        }
        return this.selectBestCandidate(candidates, modelUnitID, className);
    }

    private IService selectBestCandidate(List<IService> candidates, IType[] argumentTypes) {
        List evalServices = candidates.stream().filter(srv -> srv instanceof EvalBodyService).map(srv -> (EvalBodyService)((Object)srv)).collect(Collectors.toList());
        Object callerType = argumentTypes[0].getType();
        if (!evalServices.isEmpty() && callerType instanceof EClass) {
            EvalBodyService selection = null;
            int distance = -1;
            for (EvalBodyService service : evalServices) {
                if (selection == null) {
                    selection = service;
                    distance = this.getDistance((EClass)callerType, (EClass)service.getParameterTypes(this.queryEnvironment).get(0).getType());
                    continue;
                }
                int newDistance = this.getDistance((EClass)callerType, (EClass)service.getParameterTypes(this.queryEnvironment).get(0).getType());
                if (newDistance < distance) {
                    selection = service;
                    distance = newDistance;
                    continue;
                }
                if (((IType)selection.getParameterTypes(this.queryEnvironment).get(0)).getType() != service.getParameterTypes(this.queryEnvironment).get(0).getType() || service.getPriority() <= selection.getPriority() && !service.isLowerOrEqualParameterTypes(this.queryEnvironment, (IService)selection)) continue;
                selection = service;
            }
            return selection;
        }
        IService result = null;
        for (IService service : candidates) {
            if (result != null && service.getPriority() <= result.getPriority() && (service.getPriority() != result.getPriority() || !service.isLowerOrEqualParameterTypes(this.queryEnvironment, result))) continue;
            result = service;
        }
        return result;
    }

    private IService selectBestCandidate(List<IService> candidates, String modelUnitID, String className) {
        List evalServices = candidates.stream().filter(srv -> srv instanceof EvalBodyService).map(srv -> (EvalBodyService)((Object)srv)).collect(Collectors.toList());
        ArrayList<EvalBodyService> matchingServices = new ArrayList<EvalBodyService>();
        if (!evalServices.isEmpty()) {
            for (EvalBodyService service : evalServices) {
                BehavioredClass behavioredClass = (BehavioredClass)service.getImplem().eContainer();
                ModelUnit unit = (ModelUnit)behavioredClass.eContainer();
                if (!behavioredClass.getName().equals(className) || !unit.getName().equals(modelUnitID)) continue;
                matchingServices.add(service);
            }
        }
        if (!matchingServices.isEmpty()) {
            IService result = null;
            for (IService iService : matchingServices) {
                if (result != null && iService.getPriority() <= result.getPriority() && (iService.getPriority() != result.getPriority() || !iService.isLowerOrEqualParameterTypes(this.queryEnvironment, result))) continue;
                result = iService;
            }
            return result;
        }
        return null;
    }

    private int getDistance(EClass source, EClass target) {
        EList<EClass> superTypes = this.getEAllSuperTypes(source);
        return superTypes.indexOf((Object)target);
    }

    private EList<EClass> getEAllSuperTypes(EClass cls) {
        BasicEList result = new BasicEList();
        LinkedList<EClass> toVisit = new LinkedList<EClass>();
        toVisit.add(cls);
        while (!toVisit.isEmpty()) {
            EClass current = (EClass)toVisit.poll();
            if (result.contains((Object)current)) continue;
            result.add((Object)current);
            Lists.reverse((List)current.getESuperTypes()).forEach(elem -> {
                boolean bl = toVisit.offer((EClass)elem);
            });
        }
        return result;
    }
}

