/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.solver.expression;

import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.AbstractEntity;
import fr.inria.aoste.timesquare.ccslkernel.runtime.AbstractConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.ICCSLConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.IRuntimeContainer;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;
import fr.inria.aoste.timesquare.ccslkernel.solver.ISolverConcrete;
import fr.inria.aoste.timesquare.ccslkernel.solver.ISolverElement;
import fr.inria.aoste.timesquare.ccslkernel.solver.ImplicitClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.SolverClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.expression.SolverExpression;
import fr.inria.aoste.timesquare.ccslkernel.solver.relation.SolverRelation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UserDefinedExpression
extends SolverExpression {
    private String definitionName;
    private ImplicitClock rootClock;
    private HashMap<AbstractEntity, ISolverElement> parameterValues;
    private List<ISolverConcrete> subConcretes;

    public UserDefinedExpression(String definitionName) {
        this.definitionName = definitionName;
        this.parameterValues = new HashMap();
        this.subConcretes = new ArrayList<ISolverConcrete>();
    }

    @Override
    public void addContent(IRuntimeContainer element) {
        if (element instanceof SolverRelation || element instanceof SolverExpression) {
            this.getSubConcretes().add((ISolverConcrete)element);
        }
    }

    public ImplicitClock getRootClock() {
        return this.rootClock;
    }

    public void setRootClock(ImplicitClock rootClock) {
        this.rootClock = rootClock;
    }

    public void setParameterValue(AbstractEntity parameter, ISolverElement value) {
        this.parameterValues.put(parameter, value);
    }

    public List<ISolverConcrete> getSubConcretes() {
        return this.subConcretes;
    }

    @Override
    public void start(AbstractSemanticHelper helper) throws SimulationException {
        if (!this.canCallStart()) {
            return;
        }
        super.start(helper);
        for (ISolverConcrete subConcrete : this.subConcretes) {
            if (subConcrete instanceof SolverExpression) {
                ((SolverExpression)subConcrete).getImplicitClock().start(helper);
                continue;
            }
            subConcrete.start(helper);
        }
    }

    @Override
    public void semantic(AbstractSemanticHelper semanticHelper) throws SimulationException {
        if (traceSemantic) {
            System.out.println("Entry: UserDefinedExpression.semantic(" + this.toString() + ")");
        }
        if (!this.canCallSemantic()) {
            if (traceSemantic) {
                System.out.println("Exit: UserDefinedExpression.semantic(" + this.toString() + ") not active.");
            }
            return;
        }
        super.semantic(semanticHelper);
        if (this.getImplicitClock() != this.rootClock) {
            this.rootClock.semantic(semanticHelper);
            semanticHelper.semanticBDDAnd(semanticHelper.createEqual((RuntimeClock)this.getImplicitClock(), (RuntimeClock)this.getRootClock()));
            semanticHelper.registerClockUse((RuntimeClock[])new SolverClock[]{this.getImplicitClock(), this.getRootClock()});
        }
        if (traceSemantic) {
            System.out.println("Exit: UserDefinedExpression.semantic(" + this.toString() + ")");
        }
        for (ISolverConcrete subConcrete : this.subConcretes) {
            if (!(subConcrete instanceof SolverRelation)) continue;
            ((SolverRelation)subConcrete).semantic(semanticHelper);
        }
    }

    @Override
    public void deathSemantic(AbstractSemanticHelper semanticHelper) throws SimulationException {
        super.deathSemantic(semanticHelper);
        for (ISolverConcrete subConcrete : this.subConcretes) {
            if (!(subConcrete instanceof SolverRelation)) continue;
            ((SolverRelation)subConcrete).deathSemantic(semanticHelper);
        }
        if (this.getImplicitClock() != this.rootClock) {
            this.rootClock.deathSemantic(semanticHelper);
            if (semanticHelper.isSemanticDone((ICCSLConstraint)this)) {
                return;
            }
            semanticHelper.registerSemanticDone((ICCSLConstraint)this);
            semanticHelper.registerDeathEquality((RuntimeClock)this.getImplicitClock(), (RuntimeClock)this.getRootClock());
        }
    }

    @Override
    public void update(AbstractUpdateHelper helper) throws SimulationException {
        if (traceUpdate) {
            System.out.println("Entry: UserDefinedExpression.update(" + this.toString() + ")");
        }
        if (!this.canCallUpdate()) {
            if (traceUpdate) {
                System.out.println("Exit: UserDefinedExpression.update(" + this.toString() + ") not active.");
            }
            return;
        }
        super.update(helper);
        this.rootClock.update(helper);
        for (ISolverConcrete subConcrete : this.getSubConcretes()) {
            if (!(subConcrete instanceof SolverRelation)) continue;
            subConcrete.update(helper);
        }
        if (this.rootClock.isDead()) {
            this.terminate(helper);
        }
        if (traceUpdate) {
            System.out.println("Exit: UserDefinedExpression.update(" + this.toString() + ")");
        }
    }

    @Override
    public void terminate(AbstractUpdateHelper helper) throws SimulationException {
        if (!this.canCallTerminate()) {
            return;
        }
        super.terminate(helper);
        if (traceTerminate) {
            System.out.println("Entry: UserDefinedExpression.terminate(" + this.toString() + ")");
        }
        super.terminate(helper);
        for (ISolverConcrete subConcrete : this.subConcretes) {
            subConcrete.terminate(helper);
        }
        if (traceTerminate) {
            System.out.println("Exit: UserDefinedExpression.terminate(" + this.toString() + ")");
        }
    }

    @Override
    public boolean isTerminated() {
        return this.rootClock.isTerminated();
    }

    public String toString() {
        return "[" + this.getImplicitClock().getName() + "]" + (this.state != AbstractConstraint.State.INIT ? "*" : (this.state == AbstractConstraint.State.DEAD ? "D" : "")) + "Call(" + this.definitionName + ")" + "->" + this.rootClock.getName();
    }
}

