/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.runtime.helpers;

import net.sf.javabdd.BuDDyFactory;

public class BDDHelper {
    private BuDDyFactory factory;
    public static String defaultBDDLibName = "cudd";
    private static BuDDyFactory BuddyFactoryInstance = null;

    public BDDHelper() {
        this.factory = BDDHelper.createFactory();
    }

    public BDDHelper(BuDDyFactory factory) {
        this.factory = factory;
    }

    public BuDDyFactory getFactory() {
        return this.factory;
    }

    public BuDDyFactory.BuDDyBDD createEqual(int leftVarNum, int rightVarNum) {
        BuDDyFactory.BuDDyBDD left = this.factory.ithVar(leftVarNum);
        BuDDyFactory.BuDDyBDD right = this.factory.ithVar(rightVarNum);
        BuDDyFactory.BuDDyBDD res = this.createEqual(left, right);
        left.free();
        right.free();
        return res;
    }

    public BuDDyFactory.BuDDyBDD createEqual(BuDDyFactory.BuDDyBDD left, BuDDyFactory.BuDDyBDD right) {
        BuDDyFactory.BuDDyBDD notLeft = left.not();
        BuDDyFactory.BuDDyBDD notRight = right.not();
        notRight.andWith(notLeft);
        BuDDyFactory.BuDDyBDD rightLeft = right.and(left);
        rightLeft.orWith(notRight);
        return rightLeft;
    }

    public BuDDyFactory.BuDDyBDD createExclusion(int leftVarNum, int rightVarNum) {
        BuDDyFactory.BuDDyBDD left = this.factory.ithVar(leftVarNum);
        BuDDyFactory.BuDDyBDD right = this.factory.ithVar(rightVarNum);
        BuDDyFactory.BuDDyBDD res = this.createExclusion(left, right);
        left.free();
        right.free();
        return res;
    }

    public BuDDyFactory.BuDDyBDD createExclusion(BuDDyFactory.BuDDyBDD left, BuDDyFactory.BuDDyBDD right) {
        BuDDyFactory.BuDDyBDD notLeft = left.not();
        BuDDyFactory.BuDDyBDD notRight = right.not();
        BuDDyFactory.BuDDyBDD res = notRight.or(notLeft);
        notLeft.free();
        notRight.free();
        return res;
    }

    public BuDDyFactory.BuDDyBDD createImplication(int leftVarNum, int rightVarNum) {
        BuDDyFactory.BuDDyBDD left = this.factory.ithVar(leftVarNum);
        BuDDyFactory.BuDDyBDD right = this.factory.ithVar(rightVarNum);
        BuDDyFactory.BuDDyBDD res = this.createImplication(left, right);
        left.free();
        right.free();
        return res;
    }

    public BuDDyFactory.BuDDyBDD createImplication(BuDDyFactory.BuDDyBDD left, BuDDyFactory.BuDDyBDD right) {
        BuDDyFactory.BuDDyBDD res = left.imp(right);
        return res;
    }

    public BuDDyFactory.BuDDyBDD createUnion(int leftVarNum, int rightVarNum) {
        BuDDyFactory.BuDDyBDD left = this.factory.ithVar(leftVarNum);
        BuDDyFactory.BuDDyBDD right = this.factory.ithVar(rightVarNum);
        BuDDyFactory.BuDDyBDD res = this.createUnion(left, right);
        left.free();
        right.free();
        return res;
    }

    public BuDDyFactory.BuDDyBDD createUnion(BuDDyFactory.BuDDyBDD left, BuDDyFactory.BuDDyBDD right) {
        BuDDyFactory.BuDDyBDD res = left.or(right);
        return res;
    }

    public BuDDyFactory.BuDDyBDD createInter(int leftVarNum, int rightVarNum) {
        BuDDyFactory.BuDDyBDD left = this.factory.ithVar(leftVarNum);
        BuDDyFactory.BuDDyBDD right = this.factory.ithVar(rightVarNum);
        BuDDyFactory.BuDDyBDD res = this.createInter(left, right);
        left.free();
        right.free();
        return res;
    }

    public BuDDyFactory.BuDDyBDD createInter(BuDDyFactory.BuDDyBDD left, BuDDyFactory.BuDDyBDD right) {
        BuDDyFactory.BuDDyBDD res = left.and(right);
        return res;
    }

    public static synchronized BuDDyFactory createFactory() {
        if (BuddyFactoryInstance != null && BuddyFactoryInstance.isInitialized()) {
            return BuddyFactoryInstance;
        }
        BuddyFactoryInstance = BDDHelper.initBuddyFactory(defaultBDDLibName);
        return BuddyFactoryInstance;
    }

    public static synchronized BuDDyFactory createFactory(String bddLibName) {
        if (BuddyFactoryInstance != null && BuddyFactoryInstance.isInitialized()) {
            return BuddyFactoryInstance;
        }
        BuddyFactoryInstance = BDDHelper.initBuddyFactory(bddLibName);
        return BuddyFactoryInstance;
    }

    private static synchronized BuDDyFactory initBuddyFactory(String bddLib) {
        BuDDyFactory bddf = null;
        int node = 200000;
        int cache = 10000;
        bddf = bddLib != null ? BuDDyFactory.init((int)node, (int)cache) : BuDDyFactory.init((int)node, (int)cache);
        return bddf;
    }

    public static synchronized void terminateBDDUsage() {
        if (BuddyFactoryInstance != null) {
            BuddyFactoryInstance.done();
        }
        BuddyFactoryInstance = null;
    }

    private static int newBDDVariableNumber(BuDDyFactory factory) {
        int res = factory.varNum();
        factory.setVarNum(res + 1);
        return res;
    }

    public static int newBDDVariableNumber() {
        return BDDHelper.newBDDVariableNumber(BDDHelper.createFactory());
    }
}

