/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.k3.al.annotationprocessor;

import fr.inria.diverse.k3.al.annotationprocessor.Helper;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.macro.CodeGenerationContext;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class AspectMappingBuilder {
    public static String ASPECTMAPPING_FOLDER = "META-INF/xtend-gen";
    private List<? extends MutableClassDeclaration> classes;
    private Path targetFilePath;
    private String projectName;
    private static Map<String, WeakReference<AspectMappingBuilder>> projectsAspectMappingBuilder = new HashMap<String, WeakReference<AspectMappingBuilder>>();
    private final Map<String, List<String>> mapping = CollectionLiterals.newHashMap((Pair[])new Pair[0]);

    private AspectMappingBuilder(String projectName) {
        this.projectName = projectName;
    }

    public static AspectMappingBuilder getAspectMappingBuilder(String projectName) {
        WeakReference<AspectMappingBuilder> weakRef = projectsAspectMappingBuilder.get(projectName);
        if (weakRef != null && weakRef.get() != null) {
            return (AspectMappingBuilder)weakRef.get();
        }
        AspectMappingBuilder result = new AspectMappingBuilder(projectName);
        WeakReference<AspectMappingBuilder> _weakReference = new WeakReference<AspectMappingBuilder>(result);
        projectsAspectMappingBuilder.put(projectName, _weakReference);
        return result;
    }

    public void readCurrentMapping(List<? extends MutableClassDeclaration> classes, @Extension TransformationContext context) {
        int _size_1;
        boolean _greaterThan_1;
        boolean _greaterThan;
        this.classes = classes;
        int _size = classes.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            Path filePath = ((MutableClassDeclaration)IterableExtensions.head(classes)).getCompilationUnit().getFilePath();
            Path _projectFolder = context.getProjectFolder(filePath);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("/");
            _builder.append(ASPECTMAPPING_FOLDER);
            _builder.append("/");
            String _lastSegment = context.getProjectFolder(filePath).getLastSegment();
            _builder.append(_lastSegment);
            _builder.append(".k3_aspect_mapping.properties");
            this.targetFilePath = _projectFolder.append(_builder.toString());
        }
        boolean bl2 = _greaterThan_1 = (_size_1 = classes.size()) > 0;
        if (_greaterThan_1) {
            Properties properties = new Properties();
            boolean _exists = context.exists(this.targetFilePath);
            if (_exists) {
                try {
                    properties.load(context.getContentsAsStream(this.targetFilePath));
                    BiConsumer<Object, Object> _function = (propKey, commaSeparatedPropvalues) -> {
                        Functions.Function1 _function_1 = s -> s.trim();
                        List propValues = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)((String)commaSeparatedPropvalues).split(","))), (Functions.Function1)_function_1);
                        Consumer<String> _function_2 = propValue -> this.addMapping((String)propKey, (String)propValue);
                        propValues.forEach(_function_2);
                    };
                    properties.forEach((BiConsumer<? super Object, ? super Object>)_function);
                }
                catch (Throwable _t) {
                    if (_t instanceof IOException) {
                        IOException iOException = (IOException)_t;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllDeclaredAspects() {
        ArrayList result = CollectionLiterals.newArrayList((Object[])new String[0]);
        Map<String, List<String>> map = this.mapping;
        synchronized (map) {
            Functions.Function1 _function = l -> result.addAll(l);
            IterableExtensions.forall(this.mapping.values(), (Functions.Function1)_function);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUnusedMapping(@Extension TransformationContext context) {
        Map<String, List<String>> map = this.mapping;
        synchronized (map) {
            boolean _greaterThan;
            int _size = this.classes.size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                ArrayList keytoRemove = new ArrayList();
                HashMap<String, List<String>> mappingCopy = new HashMap<String, List<String>>(this.mapping);
                BiConsumer<String, List> _function = (key, valueList) -> {
                    boolean _equals;
                    Functions.Function1 _function_1 = value -> {
                        Type _findTypeGlobally = context.findTypeGlobally(value);
                        return _findTypeGlobally != null;
                    };
                    List newValueList = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)valueList, (Functions.Function1)_function_1));
                    this.mapping.put((String)key, newValueList);
                    int _size_1 = newValueList.size();
                    boolean bl = _equals = _size_1 == 0;
                    if (_equals) {
                        keytoRemove.add(key);
                    }
                };
                mappingCopy.forEach(_function);
                for (String key2 : keytoRemove) {
                    this.mapping.remove(key2);
                }
            }
        }
    }

    public void addMappingForAnnotatedSourceElements() {
        for (MutableClassDeclaration mutableClassDeclaration : this.classes) {
            TypeReference aspectizedClassType = Helper.getAnnotationAspectType((TypeDeclaration)mutableClassDeclaration);
            if (aspectizedClassType == null) continue;
            this.addMapping(aspectizedClassType.getName(), mutableClassDeclaration.getQualifiedName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePropertyFile(@Extension CodeGenerationContext context) {
        if (this.classes != null && this.classes.size() > 0) {
            StringConcatenation _builder = new StringConcatenation();
            String buf = _builder.toString();
            Map<String, List<String>> map = this.mapping;
            synchronized (map) {
                Set<Map.Entry<String, List<String>>> _entrySet = this.mapping.entrySet();
                for (Map.Entry<String, List<String>> entrySet : _entrySet) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    String _string = buf.toString();
                    _builder_1.append(_string);
                    _builder_1.newLineIfNotEmpty();
                    String _key = entrySet.getKey();
                    _builder_1.append(_key);
                    _builder_1.append(" = ");
                    List<String> _value = entrySet.getValue();
                    boolean _hasElements = false;
                    for (String aString : _value) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder_1.appendImmediate((Object)", ", "");
                        }
                        _builder_1.append(aString);
                    }
                    buf = _builder_1.toString();
                }
            }
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("# List of the Java classes that have been aspectized and name of the aspect classes separated by comma");
            _builder_1.newLine();
            _builder_1.append("\t");
            String _string = buf.toString();
            _builder_1.append(_string, "\t");
            String contents = _builder_1.toString();
            Helper.writeContentsIfNew(this.targetFilePath, contents, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMapping(String aspectizedClassName, String aspectClassName) {
        Map<String, List<String>> map = this.mapping;
        synchronized (map) {
            boolean _contains;
            boolean _not;
            ArrayList existingListForAspectizedElement = this.mapping.get(aspectizedClassName);
            if (existingListForAspectizedElement == null) {
                existingListForAspectizedElement = CollectionLiterals.newArrayList((Object[])new String[0]);
                this.mapping.put(aspectizedClassName, existingListForAspectizedElement);
            }
            boolean bl = _not = !(_contains = existingListForAspectizedElement.contains(aspectClassName));
            if (_not) {
                existingListForAspectizedElement.add(aspectClassName);
            }
        }
    }
}

