/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.editor;

import com.google.inject.Inject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.xtend.ide.labeling.XtendImages;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ui.IImageHelper;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.XtextEditorErrorTickUpdater;
import org.eclipse.xtext.ui.internal.XtextPluginImages;

public class XtendEditorErrorTickUpdater
extends XtextEditorErrorTickUpdater {
    @Inject
    private XtendImages images;
    @Inject
    private IImageHelper pluginImageHelper;

    protected void updateEditorImage(XtextEditor xtextEditor) {
        if (xtextEditor != null && !xtextEditor.isEditable()) {
            Severity severity = this.getSeverity(xtextEditor);
            if (severity != null && severity != Severity.INFO) {
                ImageDescriptor descriptor = severity == Severity.ERROR ? XtextPluginImages.DESC_OVR_ERROR : XtextPluginImages.DESC_OVR_WARNING;
                DecorationOverlayIcon decorationOverlayIcon = new DecorationOverlayIcon(this.pluginImageHelper.getImage(this.images.forReadonly()), descriptor, 2);
                this.scheduleUpdateEditor((ImageDescriptor)decorationOverlayIcon);
            } else {
                this.scheduleUpdateEditor(this.images.forReadonly());
            }
        } else {
            super.updateEditorImage(xtextEditor);
        }
    }
}

