/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide.sirius.ui;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gemoc.dsl.debug.ide.DSLBreakpoint;
import org.eclipse.gemoc.dsl.debug.ide.adapter.DSLDebugTargetAdapter;
import org.eclipse.gemoc.dsl.debug.ide.adapter.DSLStackFrameAdapter;
import org.eclipse.gemoc.dsl.debug.ide.adapter.IDSLCurrentInstructionListener;
import org.eclipse.gemoc.dsl.debug.ide.sirius.ui.SiriusEditorUtils;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class DSLDebugModelPresentation
extends org.eclipse.gemoc.dsl.debug.ide.ui.DSLDebugModelPresentation {
    IEditorPart editor;

    public IEditorInput getEditorInput(Object element) {
        IEditorInput res;
        Object instructionURI = element instanceof EObject ? EcoreUtil.getURI((EObject)((EObject)element)) : (element instanceof DSLBreakpoint ? ((DSLBreakpoint)element).getURI() : null);
        this.editor = null;
        if (instructionURI != null) {
            List<Session> sessions;
            Session inSession = element instanceof EObject ? SessionManager.INSTANCE.getSession((EObject)element) : null;
            Object session = inSession != null ? inSession : ((sessions = SiriusEditorUtils.getSessions(instructionURI)).size() > 1 ? this.selectSession(sessions) : (sessions.size() == 1 ? sessions.get(0) : null));
            if (session != null) {
                List<DRepresentation> representations = SiriusEditorUtils.getRepresentations(session, instructionURI);
                Object representation = representations.size() > 1 ? this.selectRepresentation(representations) : (representations.size() == 1 ? representations.get(0) : null);
                if (representation != null) {
                    this.editor = DialectUIManager.INSTANCE.openEditor(session, representation, (IProgressMonitor)new NullProgressMonitor());
                    res = this.editor.getEditorInput();
                } else {
                    res = super.getEditorInput(instructionURI);
                }
            } else {
                res = super.getEditorInput(instructionURI);
            }
        } else {
            return null;
        }
        return res;
    }

    protected Session selectSession(List<Session> sessions) {
        return sessions.get(0);
    }

    protected DRepresentation selectRepresentation(List<DRepresentation> representations) {
        return representations.get(0);
    }

    public String getEditorId(IEditorInput input, Object element) {
        String res = this.editor != null ? this.editor.getEditorSite().getId() : super.getEditorId(input, element);
        return res;
    }

    public boolean addAnnotations(IEditorPart editorPart, IStackFrame frame) {
        if (frame instanceof DSLStackFrameAdapter) {
            this.changeCurrentStackFrame(frame);
            if (editorPart instanceof DialectEditor) {
                EObject instruction = ((DSLStackFrameAdapter)frame).getCurrentInstruction();
                SiriusEditorUtils.showInstruction((DialectEditor)editorPart, instruction);
            } else {
                super.addAnnotations(editorPart, frame);
            }
        }
        return true;
    }

    protected void changeCurrentStackFrame(IStackFrame frame) {
        IDebugTarget debugTarget = frame.getDebugTarget();
        for (IDSLCurrentInstructionListener listener : ((DSLDebugTargetAdapter)debugTarget).getCurrentInstructionListeners()) {
            listener.setCurrentFrame(frame.getModelIdentifier(), ((DSLStackFrameAdapter)frame).getHost());
        }
    }

    public void removeAnnotations(IEditorPart editorPart, IThread thread) {
    }
}

