/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.common.tools.api.resource.FileProvider;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.internal.query.DDiagramElementContainerExperimentalQuery;
import org.eclipse.sirius.diagram.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.NodeQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.DNodeContainerQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.DNodeQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.sirius.diagram.ui.internal.refresh.borderednode.CanonicalDBorderItemLocator;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutUtils;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.AlphaDropShadowBorder;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.style.LabelBorderStyleDescription;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;

public final class GMFHelper {
    private static Point CONTAINER_INSETS = new Point(4, 5);
    private static final int ICON_TEXT_GAP = 3;

    private GMFHelper() {
    }

    public static Point getAbsoluteLocation(Node node) {
        return GMFHelper.getAbsoluteLocation(node, false);
    }

    public static Point getAbsoluteLocation(Node node, boolean insetsAware) {
        Node currentNode = node;
        Point absoluteNodeLocation = GMFHelper.getLocation(currentNode);
        if (currentNode.eContainer() instanceof Node) {
            currentNode = (Node)currentNode.eContainer();
            Point parentNodeLocation = GMFHelper.getAbsoluteLocation(currentNode, insetsAware);
            absoluteNodeLocation.translate(parentNodeLocation);
            if (insetsAware) {
                GMFHelper.translateWithInsets(absoluteNodeLocation, node);
            }
        }
        return absoluteNodeLocation;
    }

    public static Dimension getContainerTopLeftInsets(Node node, boolean searchFirstParentContainer) {
        Dimension result = new Dimension(0, 0);
        EObject nodeContainer = node.eContainer();
        if (nodeContainer instanceof Node) {
            Node parentNode = (Node)nodeContainer;
            NodeQuery nodeQuery = new NodeQuery(parentNode);
            if (nodeQuery.isContainer()) {
                EObject element = parentNode.getElement();
                if (element instanceof DDiagramElementContainer) {
                    DDiagramElementContainer ddec = (DDiagramElementContainer)element;
                    if (ddec instanceof DNodeContainer) {
                        if (new DNodeContainerExperimentalQuery((DNodeContainer)ddec).isRegionContainer() || GMFHelper.hasFullLabelBorder(ddec)) {
                            result.setHeight(GMFHelper.CONTAINER_INSETS.y + GMFHelper.getLabelSize(parentNode) + 5);
                        } else {
                            result.setWidth(GMFHelper.CONTAINER_INSETS.x);
                            result.setHeight(GMFHelper.CONTAINER_INSETS.y);
                        }
                    }
                    Dimension borderSize = GMFHelper.getBorderSize(ddec);
                    result.setWidth(result.width() + borderSize.width());
                    result.setHeight(result.height() + borderSize.height());
                }
            } else if (searchFirstParentContainer) {
                result = GMFHelper.getContainerTopLeftInsets(parentNode, searchFirstParentContainer);
            }
        }
        return result;
    }

    public static Dimension getContainerTopLeftInsetsAfterLabel(Node node, boolean searchFirstParentContainer) {
        Dimension result = new Dimension(0, 0);
        EObject nodeContainer = node.eContainer();
        if (nodeContainer instanceof Node) {
            Node parentNode = (Node)nodeContainer;
            NodeQuery nodeQuery = new NodeQuery(parentNode);
            if (nodeQuery.isContainer()) {
                EObject element = parentNode.getElement();
                if (element instanceof DDiagramElementContainer) {
                    result.setWidth(GMFHelper.CONTAINER_INSETS.x);
                    result.setHeight(GMFHelper.CONTAINER_INSETS.y);
                    Dimension borderSize = GMFHelper.getBorderSize((DDiagramElementContainer)element);
                    result.setWidth(result.width() + borderSize.width());
                    result.setHeight(result.height() + borderSize.height());
                }
            } else if (searchFirstParentContainer) {
                result = GMFHelper.getContainerTopLeftInsets(parentNode, searchFirstParentContainer);
            }
        }
        return result;
    }

    public static Dimension getBorderSize(DDiagramElementContainer ddec) {
        DDiagramElementContainerExperimentalQuery regionQuery;
        Dimension result = new Dimension(0, 0);
        int borderSize = 0;
        ContainerStyle containerStyle = ddec.getOwnedStyle();
        if (containerStyle != null && containerStyle.getBorderSize() != null) {
            borderSize = containerStyle.getBorderSize();
        }
        if ((regionQuery = new DDiagramElementContainerExperimentalQuery(ddec)).isRegionInHorizontalStack()) {
            result.setWidth(GMFHelper.isFirstRegion(ddec) ? 0 : borderSize);
            result.setHeight(1);
        } else if (regionQuery.isRegionInVerticalStack()) {
            result.setWidth(1);
            result.setHeight(GMFHelper.isFirstRegion(ddec) ? 1 : borderSize);
        } else {
            result.setWidth(borderSize);
            result.setHeight(borderSize);
        }
        return result;
    }

    private static void translateWithInsets(Point locationToTranslate, Node currentNode) {
        NodeQuery nodeQuery = new NodeQuery(currentNode);
        if (!nodeQuery.isBorderedNode()) {
            locationToTranslate.translate(GMFHelper.getContainerTopLeftInsets(currentNode, false));
        }
    }

    private static boolean hasFullLabelBorder(DDiagramElementContainer ddec) {
        Option labelBorderStyle = new DDiagramElementContainerExperimentalQuery(ddec).getLabelBorderStyle();
        return labelBorderStyle.some() && "labelBorderForContainer".equals(((LabelBorderStyleDescription)labelBorderStyle.get()).getId());
    }

    private static int getLabelSize(Node parentNode) {
        int labelSize = 0;
        for (Node child : Iterables.filter((Iterable)parentNode.getVisibleChildren(), Node.class)) {
            if (!new ViewQuery((View)child).isForNameEditPart()) continue;
            labelSize = 16;
            break;
        }
        return labelSize;
    }

    private static boolean isFirstRegion(DDiagramElementContainer ddec) {
        EObject potentialRegionContainer = ddec.eContainer();
        if (potentialRegionContainer instanceof DNodeContainer) {
            Iterable regions = Iterables.filter((Iterable)((DNodeContainer)potentialRegionContainer).getOwnedDiagramElements(), DDiagramElementContainer.class);
            return !Iterables.isEmpty((Iterable)regions) && ddec == Iterables.getFirst((Iterable)regions, null);
        }
        return false;
    }

    private static void translateWithInsets(Rectangle boundsToTranslate, Node currentNode) {
        Point location = boundsToTranslate.getLocation();
        GMFHelper.translateWithInsets(location, currentNode);
        boundsToTranslate.setLocation(location);
    }

    public static Point getLocation(Node node) {
        Point location = new Point(0, 0);
        LayoutConstraint layoutConstraint = node.getLayoutConstraint();
        if (layoutConstraint instanceof Bounds) {
            Node parentNode;
            LayoutConstraint parentLayoutConstraint;
            DNode dNode;
            AbstractDNode parentAbstractDNode;
            Bounds gmfBounds = (Bounds)layoutConstraint;
            location.x = gmfBounds.getX();
            location.y = gmfBounds.getY();
            if (node.getElement() instanceof DNode && node.getElement().eContainer() instanceof AbstractDNode && (parentAbstractDNode = (AbstractDNode)(dNode = (DNode)node.getElement()).eContainer()).getOwnedBorderedNodes().contains((Object)dNode) && (parentLayoutConstraint = (parentNode = (Node)node.eContainer()).getLayoutConstraint()) instanceof Bounds) {
                Bounds parentBounds = (Bounds)parentLayoutConstraint;
                int position = CanonicalDBorderItemLocator.findClosestSideOfParent(new Rectangle(gmfBounds.getX(), gmfBounds.getY(), gmfBounds.getWidth(), gmfBounds.getHeight()), new Rectangle(parentBounds.getX(), parentBounds.getY(), parentBounds.getWidth(), parentBounds.getHeight()));
                GMFHelper.updateLocation(location, position, parentBounds, gmfBounds);
            }
        }
        return location;
    }

    private static void updateLocation(Point location, int position, Bounds parentBounds, Bounds gmfBounds) {
        switch (position) {
            case 1: 
            case 4: {
                if (location.x != 0) break;
                location.x += (parentBounds.getWidth() - gmfBounds.getWidth()) / 2;
                break;
            }
            case 8: 
            case 16: {
                if (location.y != 0) break;
                location.y += (parentBounds.getHeight() - gmfBounds.getHeight()) / 2;
                break;
            }
        }
    }

    public static Rectangle getAbsoluteBounds(Node node) {
        return GMFHelper.getAbsoluteBounds(node, false, false);
    }

    public static Rectangle getAbsoluteBounds(Node node, boolean insetsAware) {
        return GMFHelper.getAbsoluteBounds(node, insetsAware, false);
    }

    public static Rectangle getAbsoluteBounds(Node node, boolean insetsAware, boolean boxForConnection) {
        Node currentNode = node;
        Rectangle absoluteNodeBounds = GMFHelper.getBounds(currentNode, false, false, boxForConnection);
        if (currentNode.eContainer() instanceof Node) {
            currentNode = (Node)currentNode.eContainer();
            Point parentNodeLocation = GMFHelper.getAbsoluteLocation(currentNode, insetsAware);
            absoluteNodeBounds = absoluteNodeBounds.getTranslated(parentNodeLocation);
            if (insetsAware) {
                GMFHelper.translateWithInsets(absoluteNodeBounds, node);
            }
        }
        return absoluteNodeBounds;
    }

    public static Option<Rectangle> getAbsoluteBounds(Edge edge) {
        return GMFHelper.getAbsoluteBounds(edge, false, false);
    }

    public static Option<Rectangle> getAbsoluteBounds(Edge edge, boolean insetsAware, boolean boxForConnection) {
        Option<Rectangle> optionalSourceBounds = GMFHelper.getAbsoluteBounds(edge.getSource(), insetsAware, boxForConnection);
        Option<Rectangle> optionalTargetBounds = GMFHelper.getAbsoluteBounds(edge.getTarget(), insetsAware, boxForConnection);
        if (optionalSourceBounds.some() && optionalTargetBounds.some()) {
            return Options.newSome((Object)((Rectangle)optionalSourceBounds.get()).union((Rectangle)optionalTargetBounds.get()));
        }
        return Options.newNone();
    }

    public static Option<Rectangle> getAbsoluteBounds(View view) {
        return GMFHelper.getAbsoluteBounds(view, false);
    }

    public static Option<Rectangle> getAbsoluteBounds(View view, boolean insetsAware) {
        return GMFHelper.getAbsoluteBounds(view, insetsAware, false);
    }

    public static Option<Rectangle> getAbsoluteBounds(View view, boolean insetsAware, boolean boxForConnection) {
        Option<Rectangle> result = Options.newNone();
        if (view instanceof Node) {
            result = Options.newSome((Object)GMFHelper.getAbsoluteBounds((Node)view, insetsAware, boxForConnection));
        } else if (view instanceof Edge) {
            result = GMFHelper.getAbsoluteBounds((Edge)view, insetsAware, boxForConnection);
        }
        return result;
    }

    public static Rectangle getBounds(Node node) {
        return GMFHelper.getBounds(node, false);
    }

    public static Rectangle getBounds(Node node, boolean useFigureForAutoSizeConstraint) {
        return GMFHelper.getBounds(node, useFigureForAutoSizeConstraint, false);
    }

    public static Rectangle getBounds(Node node, boolean useFigureForAutoSizeConstraint, boolean forceFigureAutoSize) {
        return GMFHelper.getBounds(node, useFigureForAutoSizeConstraint, forceFigureAutoSize, false);
    }

    public static Rectangle getBounds(Node node, boolean useFigureForAutoSizeConstraint, boolean forceFigureAutoSize, boolean boxForConnection) {
        PrecisionRectangle bounds = new PrecisionRectangle(0.0, 0.0, 0.0, 0.0);
        LayoutConstraint layoutConstraint = node.getLayoutConstraint();
        EObject element = node.getElement();
        if (element instanceof AbstractDNode) {
            AbstractDNode abstractDNode = (AbstractDNode)element;
            if (layoutConstraint instanceof Location) {
                bounds.x = ((Location)layoutConstraint).getX();
                bounds.y = ((Location)layoutConstraint).getY();
            }
            if (layoutConstraint instanceof Size) {
                bounds.width = ((Size)layoutConstraint).getWidth();
                bounds.height = ((Size)layoutConstraint).getHeight();
            } else {
                bounds.width = -1;
                bounds.height = -1;
            }
            if (new ViewQuery((View)node).isForNameEditPart()) {
                if (abstractDNode.getName() == null || abstractDNode.getName().length() == 0) {
                    if (bounds.width == -1) {
                        bounds.width = 0;
                    }
                    if (bounds.height == -1) {
                        bounds.height = 0;
                    }
                } else {
                    GMFHelper.replaceAutoSize(node, (Rectangle)bounds, useFigureForAutoSizeConstraint, GMFHelper.getLabelDimension(node, new Dimension(50, 20)));
                }
            } else {
                GMFHelper.replaceAutoSize(node, (Rectangle)bounds, useFigureForAutoSizeConstraint, null);
            }
            if (boxForConnection) {
                double shadowBorderSize = GMFHelper.getShadowBorderSize(node);
                bounds.width = (int)((double)bounds.width - shadowBorderSize);
                bounds.height = (int)((double)bounds.height - shadowBorderSize);
            }
        }
        return bounds;
    }

    public static double getShadowBorderSize(Node node) {
        double shadowBorderSize = 0.0;
        if (GMFHelper.isShadowBorderNeeded(node)) {
            shadowBorderSize = AlphaDropShadowBorder.getDefaultShadowSize();
        }
        return shadowBorderSize;
    }

    public static boolean isShadowBorderNeeded(Node node) {
        boolean needShadowBorder = false;
        EObject element = node.getElement();
        if (element instanceof DDiagramElementContainer) {
            DDiagramElementContainer ddec = (DDiagramElementContainer)element;
            needShadowBorder = !new DDiagramElementContainerExperimentalQuery(ddec).isRegion() && !(ddec.getOwnedStyle() instanceof WorkspaceImage);
        }
        return needShadowBorder;
    }

    private static void replaceAutoSize(Node node, Rectangle bounds, boolean useFigureForAutoSizeConstraint, Dimension providedDefaultSize) {
        if (bounds.width == -1 || bounds.height == -1) {
            EObject element;
            Dimension defaultSize = providedDefaultSize;
            if (providedDefaultSize == null && (element = node.getElement()) instanceof AbstractDNode) {
                defaultSize = GMFHelper.getDefaultSize((AbstractDNode)element);
            }
            if (useFigureForAutoSizeConstraint) {
                Option<GraphicalEditPart> optionalTargetEditPart = GMFHelper.getGraphicalEditPart((View)node);
                if (optionalTargetEditPart.some()) {
                    GraphicalEditPart graphicalEditPart = (GraphicalEditPart)optionalTargetEditPart.get();
                    if (graphicalEditPart instanceof AbstractDiagramElementContainerEditPart) {
                        ((AbstractDiagramElementContainerEditPart)graphicalEditPart).forceFigureAutosize();
                        ((GraphicalEditPart)graphicalEditPart.getParent()).getFigure().validate();
                    }
                    Rectangle figureBounds = graphicalEditPart.getFigure().getBounds();
                    if (bounds.width == -1) {
                        bounds.width = figureBounds.width;
                    }
                    if (bounds.height == -1) {
                        bounds.height = figureBounds.height;
                    }
                } else {
                    GMFHelper.lookForNextRegionLocation(bounds, node);
                }
            } else {
                Point bottomRight = GMFHelper.getBottomRight(node);
                if (bounds.width == -1) {
                    bounds.width = bottomRight.x > defaultSize.width ? bottomRight.x : defaultSize.width;
                }
                if (bounds.height == -1) {
                    bounds.height = bottomRight.y > defaultSize.height ? bottomRight.y : defaultSize.height;
                }
            }
            if (bounds.width == -1) {
                bounds.width = defaultSize.width;
            }
            if (bounds.height == -1) {
                bounds.height = defaultSize.height;
            }
        }
    }

    private static void lookForNextRegionLocation(Rectangle bounds, Node node) {
        EObject element = node.getElement();
        if (element instanceof DDiagramElementContainer && node.eContainer() instanceof Node) {
            DDiagramElementContainer ddec = (DDiagramElementContainer)element;
            DDiagramElementContainerExperimentalQuery query = new DDiagramElementContainerExperimentalQuery(ddec);
            boolean isRegion = query.isRegion();
            EList children = ((Node)node.eContainer()).getChildren();
            int currentIndex = children.indexOf((Object)node);
            if (currentIndex == 0 || !bounds.equals((Object)new Rectangle(0, 0, -1, -1))) {
                LayoutConstraint layoutConstraint;
                Node nextNode;
                int visualID;
                int nextIndex = currentIndex + 1;
                if (isRegion && nextIndex != 0 && nextIndex < children.size() && children.get(nextIndex) instanceof Node && (3008 == (visualID = SiriusVisualIDRegistry.getVisualID((nextNode = (Node)children.get(nextIndex)).getType())) || 2003 == visualID || 3009 == visualID) && (layoutConstraint = nextNode.getLayoutConstraint()) instanceof Location) {
                    Location nextLocation = (Location)layoutConstraint;
                    if (bounds.width == -1 && query.isRegionInHorizontalStack() && nextLocation.getX() != 0) {
                        bounds.width = nextLocation.getX() - bounds.x;
                    }
                    if (bounds.height == -1 && query.isRegionInVerticalStack() && nextLocation.getY() != 0) {
                        bounds.height = nextLocation.getY() - bounds.y;
                    }
                }
            }
        }
    }

    public static Point getBottomRight(Node node) {
        int right = 0;
        int bottom = 0;
        UnmodifiableIterator children = Iterators.filter((Iterator)node.getChildren().iterator(), Node.class);
        while (children.hasNext()) {
            Node child = (Node)children.next();
            if (new NodeQuery(node).isBorderedNode()) continue;
            Rectangle bounds = GMFHelper.getBounds(child);
            Point bottomRight = bounds.getBottomRight();
            if (bottomRight.x > right) {
                right = bottomRight.x;
            }
            if (bottomRight.y <= bottom) continue;
            bottom = bottomRight.y;
        }
        return new Point(right, bottom);
    }

    private static Dimension getDefaultSize(AbstractDNode abstractDNode) {
        Dimension defaultSize = new Dimension(-1, -1);
        if (abstractDNode instanceof DNode) {
            defaultSize = new DNodeQuery((DNode)abstractDNode).getDefaultDimension();
        } else if (abstractDNode instanceof DNodeContainer) {
            defaultSize = new DNodeContainerQuery((DNodeContainer)abstractDNode).getDefaultDimension();
        } else if (abstractDNode instanceof DNodeList) {
            defaultSize = LayoutUtils.NEW_DEFAULT_CONTAINER_DIMENSION;
        }
        return defaultSize;
    }

    public static Option<GraphicalEditPart> getGraphicalEditPart(View view) {
        if (view != null) {
            Diagram gmfDiagram = view.getDiagram();
            IEditorPart editor = EclipseUIUtil.getActiveEditor();
            if (GMFHelper.isEditorFor(editor, gmfDiagram)) {
                return GMFHelper.getGraphicalEditPart(view, (DiagramEditor)editor);
            }
            if (gmfDiagram.getElement() instanceof DDiagram) {
                for (IEditingSession uiSession : SessionUIManager.INSTANCE.getUISessions()) {
                    DialectEditor dialectEditor = uiSession.getEditor((DRepresentation)((DDiagram)gmfDiagram.getElement()));
                    if (!GMFHelper.isEditorFor((IEditorPart)dialectEditor, gmfDiagram)) continue;
                    return GMFHelper.getGraphicalEditPart(view, (DiagramEditor)dialectEditor);
                }
            }
        }
        return Options.newNone();
    }

    private static boolean isEditorFor(IEditorPart editor, Diagram diagram) {
        return editor instanceof DiagramEditor && ((DiagramEditor)editor).getDiagram() == diagram;
    }

    public static Option<GraphicalEditPart> getGraphicalEditPart(View view, DiagramEditor editor) {
        Option result = Options.newNone();
        Map editPartRegistry = editor.getDiagramGraphicalViewer().getEditPartRegistry();
        EditPart targetEditPart = (EditPart)editPartRegistry.get(view);
        if (targetEditPart instanceof GraphicalEditPart) {
            result = Options.newSome((Object)((GraphicalEditPart)targetEditPart));
        }
        return result;
    }

    public static List<Point> getPointsFromSource(ConnectionEditPart edgeEditPart) throws IllegalArgumentException {
        if (edgeEditPart.getModel() instanceof Edge && edgeEditPart.getFigure() instanceof Connection) {
            ArrayList<Point> result = new ArrayList<Point>();
            Edge gmfEdge = (Edge)edgeEditPart.getModel();
            Connection connectionFigure = (Connection)edgeEditPart.getFigure();
            Point srcAnchorLoc = connectionFigure.getSourceAnchor().getReferencePoint();
            connectionFigure.translateToRelative((Translatable)srcAnchorLoc);
            RelativeBendpoints bp = (RelativeBendpoints)gmfEdge.getBendpoints();
            int i = 0;
            while (i < bp.getPoints().size()) {
                RelativeBendpoint rbp = (RelativeBendpoint)bp.getPoints().get(i);
                Point fromSrc = srcAnchorLoc.getTranslated(rbp.getSourceX(), rbp.getSourceY());
                result.add(fromSrc);
                ++i;
            }
            return result;
        }
        throw new IllegalArgumentException(Messages.GMFHelper_invalidEdgeModelAndFigure);
    }

    public static List<Point> getPointsFromTarget(ConnectionEditPart edgeEditPart) throws IllegalArgumentException {
        if (edgeEditPart.getModel() instanceof Edge && edgeEditPart.getFigure() instanceof Connection) {
            ArrayList<Point> result = new ArrayList<Point>();
            Edge gmfEdge = (Edge)edgeEditPart.getModel();
            Connection connectionFigure = (Connection)edgeEditPart.getFigure();
            Point tgtAnchorLoc = connectionFigure.getTargetAnchor().getReferencePoint();
            connectionFigure.translateToRelative((Translatable)tgtAnchorLoc);
            RelativeBendpoints bp = (RelativeBendpoints)gmfEdge.getBendpoints();
            int i = 0;
            while (i < bp.getPoints().size()) {
                RelativeBendpoint rbp = (RelativeBendpoint)bp.getPoints().get(i);
                Point fromTgt = tgtAnchorLoc.getTranslated(rbp.getTargetX(), rbp.getTargetY());
                result.add(fromTgt);
                ++i;
            }
            return result;
        }
        throw new IllegalArgumentException(Messages.GMFHelper_invalidEdgeModelAndFigure);
    }

    public static Dimension getLabelDimension(Node node, Dimension defaultDimension) {
        Dimension labelSize = defaultDimension;
        ViewQuery viewQuery = new ViewQuery((View)node);
        EObject element = node.getElement();
        if (element instanceof DDiagramElement) {
            DDiagramElement dDiagramElement = (DDiagramElement)element;
            Style siriusStyle = dDiagramElement.getStyle();
            if (!new DDiagramElementQuery(dDiagramElement).isLabelHidden() && siriusStyle instanceof BasicLabelStyle) {
                BasicLabelStyle bls = (BasicLabelStyle)siriusStyle;
                Font defaultFont = VisualBindingManager.getDefault().getFontFromLabelStyle(bls, (String)viewQuery.getDefaultValue(NotationPackage.Literals.FONT_STYLE__FONT_NAME));
                try {
                    labelSize = FigureUtilities.getStringExtents((String)dDiagramElement.getName(), (Font)defaultFont);
                    if (bls.isShowIcon()) {
                        Dimension iconDimension = GMFHelper.getIconDimension((DSemanticDecorator)dDiagramElement, bls);
                        labelSize.setHeight(Math.max(labelSize.height(), iconDimension.height));
                        labelSize.setWidth(labelSize.width() + 3 + iconDimension.width);
                    }
                }
                catch (SWTException sWTException) {}
            }
        }
        return labelSize;
    }

    private static Dimension getIconDimension(DSemanticDecorator dSemanticDecorator, BasicLabelStyle bls) {
        IItemLabelProvider labelProvider;
        ImageDescriptor descriptor = null;
        EObject target = dSemanticDecorator.getTarget();
        if (!StringUtil.isEmpty((String)bls.getIconPath())) {
            String iconPath = bls.getIconPath();
            File imageFile = FileProvider.getDefault().getFile((IPath)new Path(iconPath));
            if (imageFile != null && imageFile.exists() && imageFile.canRead()) {
                try {
                    descriptor = DiagramUIPlugin.Implementation.findImageDescriptor(imageFile.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
            }
        } else if (target != null && (labelProvider = (IItemLabelProvider)DiagramUIPlugin.getPlugin().getItemProvidersAdapterFactory().adapt((Notifier)target, IItemLabelProvider.class)) != null) {
            descriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage((Object)target));
        }
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        Image icon = DiagramUIPlugin.getPlugin().getImage(descriptor);
        return new Dimension(icon.getBounds().width, icon.getBounds().height);
    }
}

