/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.manipulation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.manipulation.ChangeCorrectionProposalCore;
import org.eclipse.jdt.core.manipulation.ICUCorrectionProposal;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.ui.text.correction.proposals.EditAnnotator;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditVisitor;

public class CUCorrectionProposalCore
extends ChangeCorrectionProposalCore
implements ICUCorrectionProposal {
    private ICompilationUnit fCompilationUnit;
    private ICUCorrectionProposal fCUProposal;

    public CUCorrectionProposalCore(ICUCorrectionProposal proposal, String name, ICompilationUnit cu, TextChange change, int relevance) {
        super(name, (Change)change, relevance);
        if (cu == null) {
            throw new IllegalArgumentException("Compilation unit must not be null");
        }
        this.fCompilationUnit = cu;
        this.fCUProposal = proposal;
    }

    public CUCorrectionProposalCore(String name, ICompilationUnit cu, TextChange change, int relevance) {
        super(name, (Change)change, relevance);
        if (cu == null) {
            throw new IllegalArgumentException("Compilation unit must not be null");
        }
        this.fCompilationUnit = cu;
        this.fCUProposal = this;
    }

    protected CUCorrectionProposalCore(String name, ICompilationUnit cu, int relevance) {
        this(name, cu, null, relevance);
    }

    protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
    }

    @Override
    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        StringBuffer buf = new StringBuffer();
        try {
            TextChange change = this.fCUProposal.getTextChange();
            change.setKeepPreviewEdits(true);
            IDocument previewDocument = change.getPreviewDocument(monitor);
            TextEdit rootEdit = change.getPreviewEdit(change.getEdit());
            EditAnnotator ea = new EditAnnotator(buf, previewDocument);
            rootEdit.accept((TextEditVisitor)ea);
            ea.unchangedUntil(previewDocument.getLength());
        }
        catch (CoreException e) {
            JavaManipulationPlugin.log(e);
        }
        return buf.toString();
    }

    @Override
    public void apply() throws CoreException {
        this.performChange();
    }

    public TextChange getNewChange() {
        CompilationUnitChange change;
        ICompilationUnit cu = this.getCompilationUnit();
        String name = this.getName();
        if (!cu.getResource().exists()) {
            String source;
            try {
                source = cu.getSource();
            }
            catch (JavaModelException e) {
                JavaManipulationPlugin.log(e);
                source = "";
            }
            Document document = new Document(source);
            document.setInitialLineDelimiter(StubUtility.getLineDelimiterUsed((IJavaElement)cu));
            change = new DocumentChange(name, (IDocument)document);
        } else {
            CompilationUnitChange cuChange = new CompilationUnitChange(name, cu);
            cuChange.setSaveMode(4);
            change = cuChange;
        }
        MultiTextEdit rootEdit = new MultiTextEdit();
        change.setEdit((TextEdit)rootEdit);
        return change;
    }

    public TextChange createTextChange() throws CoreException {
        TextChange change = this.getNewChange();
        IDocument document = change.getCurrentDocument((IProgressMonitor)new NullProgressMonitor());
        this.addEdits(document, change.getEdit());
        return change;
    }

    @Override
    protected Change createChange() throws CoreException {
        return this.createTextChange();
    }

    @Override
    public final TextChange getTextChange() throws CoreException {
        return (TextChange)this.getChange();
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public String getPreviewContent() throws CoreException {
        return this.getTextChange().getPreviewContent((IProgressMonitor)new NullProgressMonitor());
    }

    public String toString() {
        try {
            return this.getPreviewContent();
        }
        catch (CoreException coreException) {
            return super.toString();
        }
    }
}

