/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import java.util.TreeSet;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.eclipse.pde.internal.core.util.VMUtil;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.LibraryPluginFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.NewLibraryPluginCreationUpdateRefPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewLibraryPluginCreationPage
extends WizardNewProjectCreationPage {
    private Label fEELabel;
    private Button fExeEnvButton;
    private Combo fEEChoice;
    private static final String NO_EXECUTION_ENVIRONMENT = PDEUIMessages.PluginContentPage_noEE;
    private LibraryPluginFieldData fData;
    protected NewLibraryPluginCreationPage fMainPage;
    protected IProjectProvider fProjectProvider;
    protected PropertiesListener fPropertiesListener = new PropertiesListener();
    protected Text fIdText;
    protected Text fNameText;
    protected Text fProviderText;
    protected Text fVersionText;
    private Button fEclipseButton;
    private Button fOSGIButton;
    private Combo fOSGiCombo;
    protected Button fJarredCheck;
    protected Button fFindDependencies;
    private Button fUpdateRefsCheck;
    private IStructuredSelection fSelection;

    public NewLibraryPluginCreationPage(String pageName, LibraryPluginFieldData data, IStructuredSelection selection) {
        super(pageName);
        this.fData = data;
        this.fSelection = selection;
        this.setTitle(PDEUIMessages.NewLibraryPluginCreationPage_title);
        this.setDescription(PDEUIMessages.NewLibraryPluginCreationPage_desc);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite control = (Composite)this.getControl();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        control.setLayout((Layout)layout);
        this.createPluginPropertiesGroup(control);
        this.createFormatGroup(control);
        this.createWorkingSetGroup(control, this.fSelection, new String[]{"org.eclipse.jdt.ui.JavaWorkingSetPage", "org.eclipse.pde.ui.pluginWorkingSet", "org.eclipse.ui.resourceWorkingSetPage"});
        this.updateRuntimeDependency();
        Dialog.applyDialogFont((Control)control);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)control, "org.eclipse.pde.doc.user.new_library_plugin_structure_page");
        this.setControl((Control)control);
    }

    private void createFormatGroup(Composite container) {
        Group group = new Group(container, 0);
        group.setText(PDEUIMessages.NewProjectCreationPage_target);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)group, 0);
        label.setText(PDEUIMessages.NewProjectCreationPage_ptarget);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fEclipseButton = this.createButton((Composite)group, 16, 2, 30);
        this.fEclipseButton.setText(PDEUIMessages.NewProjectCreationPage_pDependsOnRuntime);
        this.fEclipseButton.setSelection(this.fData.getOSGiFramework() == null);
        this.fEclipseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateRuntimeDependency()));
        this.fOSGIButton = this.createButton((Composite)group, 16, 1, 30);
        this.fOSGIButton.setText(PDEUIMessages.NewProjectCreationPage_pPureOSGi);
        this.fOSGIButton.setSelection(this.fData.getOSGiFramework() != null);
        this.fOSGiCombo = new Combo((Composite)group, 12);
        this.fOSGiCombo.setItems(new String[]{"Equinox", PDEUIMessages.NewProjectCreationPage_standard});
        this.fOSGiCombo.setText("Equinox");
        this.fJarredCheck = new Button((Composite)group, 32);
        this.fJarredCheck.setText(PDEUIMessages.NewLibraryPluginCreationPage_jarred);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fJarredCheck.setLayoutData((Object)gd);
        this.fJarredCheck.setSelection(true);
        this.fUpdateRefsCheck = new Button((Composite)group, 32);
        this.fUpdateRefsCheck.setText(PDEUIMessages.NewLibraryPluginCreationPage_UpdateReferences_button);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fUpdateRefsCheck.setLayoutData((Object)gd);
        this.fUpdateRefsCheck.setSelection(false);
        this.fUpdateRefsCheck.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.getNextPage() instanceof NewLibraryPluginCreationUpdateRefPage) {
                ((NewLibraryPluginCreationUpdateRefPage)this.getNextPage()).setEnable(this.fUpdateRefsCheck.getSelection());
            }
            this.getContainer().updateButtons();
        }));
    }

    private void createExecutionEnvironmentControls(Composite container) {
        this.fEELabel = new Label(container, 0);
        this.fEELabel.setText(PDEUIMessages.NewProjectCreationPage_executionEnvironments_label);
        this.fEEChoice = new Combo(container, 2060);
        this.fEEChoice.setLayoutData((Object)new GridData(768));
        IExecutionEnvironment[] exeEnvs = VMUtil.getExecutionEnvironments();
        TreeSet<String> availableEEs = new TreeSet<String>();
        IExecutionEnvironment[] iExecutionEnvironmentArray = exeEnvs;
        int n = exeEnvs.length;
        int n2 = 0;
        while (n2 < n) {
            IExecutionEnvironment exeEnv = iExecutionEnvironmentArray[n2];
            availableEEs.add(exeEnv.getId());
            ++n2;
        }
        availableEEs.add(NO_EXECUTION_ENVIRONMENT);
        this.fEEChoice.setItems(availableEEs.toArray(new String[availableEEs.size() - 1]));
        this.fEEChoice.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.validatePage();
        }));
        IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
        String[] EEChoices = this.fEEChoice.getItems();
        int i = 0;
        while (i < EEChoices.length) {
            if (!EEChoices[i].equals(NO_EXECUTION_ENVIRONMENT) && VMUtil.getExecutionEnvironment((String)EEChoices[i]).isStrictlyCompatible(defaultVM)) {
                this.fEEChoice.select(i);
                break;
            }
            ++i;
        }
        this.fExeEnvButton = new Button(container, 8);
        this.fExeEnvButton.setLayoutData((Object)new GridData());
        this.fExeEnvButton.setText(PDEUIMessages.NewProjectCreationPage_environmentsButton);
        this.fExeEnvButton.addListener(13, event -> {
            int n = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"org.eclipse.jdt.debug.ui.jreProfiles", (String[])new String[]{"org.eclipse.jdt.debug.ui.jreProfiles"}, null).open();
        });
    }

    private void createPluginPropertiesGroup(Composite container) {
        Group propertiesGroup = new Group(container, 0);
        propertiesGroup.setLayout((Layout)new GridLayout(3, false));
        propertiesGroup.setLayoutData((Object)new GridData(768));
        propertiesGroup.setText(PDEUIMessages.NewLibraryPluginCreationPage_pGroup);
        Label label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.NewLibraryPluginCreationPage_pid);
        this.fIdText = this.createText((Composite)propertiesGroup, this.fPropertiesListener, 2);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.NewLibraryPluginCreationPage_pversion);
        this.fVersionText = this.createText((Composite)propertiesGroup, this.fPropertiesListener, 2);
        this.fPropertiesListener.setBlocked(true);
        this.fVersionText.setText("1.0.0");
        this.fPropertiesListener.setBlocked(false);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.NewLibraryPluginCreationPage_pname);
        this.fNameText = this.createText((Composite)propertiesGroup, this.fPropertiesListener, 2);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.NewLibraryPluginCreationPage_pprovider);
        this.fProviderText = this.createText((Composite)propertiesGroup, this.fPropertiesListener, 2);
        this.fFindDependencies = new Button((Composite)propertiesGroup, 32);
        this.fFindDependencies.setText(PDEUIMessages.NewLibraryPluginCreationPage_pdependencies);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        this.fFindDependencies.setLayoutData((Object)data);
        this.createExecutionEnvironmentControls((Composite)propertiesGroup);
    }

    protected Text createText(Composite parent, ModifyListener listener, int horizSpan) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData(768);
        data.horizontalSpan = horizSpan;
        text.setLayoutData((Object)data);
        text.addModifyListener(listener);
        return text;
    }

    public IWizardPage getNextPage() {
        this.updateData();
        return super.getNextPage();
    }

    protected boolean isVersionValid(String version) {
        return VersionUtil.validateVersion((String)version).getSeverity() == 0;
    }

    public void updateData() {
        this.fData.setSimple(false);
        this.fData.setSourceFolderName(null);
        this.fData.setOutputFolderName(null);
        this.fData.setLegacy(false);
        this.fData.setTargetVersion("3.8");
        this.fData.setHasBundleStructure(true);
        this.fData.setId(this.fIdText.getText().trim());
        this.fData.setVersion(this.fVersionText.getText().trim());
        this.fData.setName(this.fNameText.getText().trim());
        this.fData.setProvider(this.fProviderText.getText().trim());
        this.fData.setLibraryName(null);
        this.fData.setOSGiFramework(this.fOSGIButton.getSelection() ? this.fOSGiCombo.getText() : null);
        this.fData.setUnzipLibraries(this.fJarredCheck.isEnabled() && this.fJarredCheck.getSelection());
        this.fData.setFindDependencies(this.fFindDependencies.getSelection());
        this.fData.setUpdateReferences(this.fUpdateRefsCheck.getSelection());
        this.fData.setWorkingSets(this.getSelectedWorkingSets());
        LibraryPluginFieldData data = this.fData;
        data.setClassname(null);
        data.setUIPlugin(false);
        data.setDoGenerateClass(false);
        data.setRCPApplicationPlugin(false);
        if (this.fEEChoice.isEnabled() && !this.fEEChoice.getText().equals(NO_EXECUTION_ENVIRONMENT)) {
            this.fData.setExecutionEnvironment(this.fEEChoice.getText().trim());
        } else {
            this.fData.setExecutionEnvironment(null);
        }
    }

    private String validateId() {
        String id = this.fIdText.getText().trim();
        if (id.length() == 0) {
            return PDEUIMessages.NewLibraryPluginCreationPage_noid;
        }
        if (!IdUtil.isValidCompositeID3_0((String)id)) {
            return PDEUIMessages.NewLibraryPluginCreationPage_invalidId;
        }
        return null;
    }

    protected boolean validatePage() {
        String id = IdUtil.getValidId((String)this.getProjectName());
        if (!this.fPropertiesListener.isChanged() && this.fIdText != null) {
            this.fPropertiesListener.setBlocked(true);
            this.fIdText.setText(id);
            this.fNameText.setText(IdUtil.getValidName((String)id));
            this.fPropertiesListener.setBlocked(false);
        }
        if (!super.validatePage()) {
            return false;
        }
        this.setMessage(null);
        String errorMessage = this.validateProperties();
        if (errorMessage == null) {
            IExecutionEnvironment ee;
            String eeid = this.fEEChoice.getText();
            if (this.fEEChoice.isEnabled() && (ee = VMUtil.getExecutionEnvironment((String)eeid)) != null && ee.getCompatibleVMs().length == 0) {
                errorMessage = PDEUIMessages.NewProjectCreationPage_invalidEE;
            }
        }
        this.setErrorMessage(errorMessage);
        return errorMessage == null;
    }

    protected String validateProperties() {
        String errorMessage = this.validateId();
        if (errorMessage != null) {
            return errorMessage;
        }
        if (this.fVersionText.getText().trim().length() == 0) {
            errorMessage = PDEUIMessages.NewLibraryPluginCreationPage_noversion;
        } else if (!this.isVersionValid(this.fVersionText.getText().trim())) {
            errorMessage = PDEUIMessages.ContentPage_badversion;
        } else if (this.fNameText.getText().trim().length() == 0) {
            errorMessage = PDEUIMessages.NewLibraryPluginCreationPage_noname;
        }
        if (errorMessage != null) {
            return errorMessage;
        }
        return errorMessage;
    }

    private void updateRuntimeDependency() {
        boolean depends = this.fEclipseButton.getSelection();
        this.fOSGiCombo.setEnabled(!depends);
    }

    private Button createButton(Composite container, int style, int span, int indent) {
        Button button = new Button(container, style);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        gd.horizontalIndent = indent;
        button.setLayoutData((Object)gd);
        return button;
    }

    public void addSelectionListener(SelectionListener listener) {
        if (this.fUpdateRefsCheck != null) {
            this.fUpdateRefsCheck.addSelectionListener(listener);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this.fUpdateRefsCheck != null) {
            this.fUpdateRefsCheck.removeSelectionListener(listener);
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && this.fUpdateRefsCheck.getSelection();
    }

    class PropertiesListener
    implements ModifyListener {
        private boolean fBlocked = false;
        private boolean fChanged = false;

        PropertiesListener() {
        }

        public boolean isChanged() {
            return this.fChanged;
        }

        public void modifyText(ModifyEvent e) {
            if (!this.fBlocked) {
                this.fChanged = true;
                NewLibraryPluginCreationPage.this.setPageComplete(NewLibraryPluginCreationPage.this.validatePage());
            }
        }

        public void setBlocked(boolean blocked) {
            this.fBlocked = blocked;
        }
    }
}

