/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.k3.al.annotationprocessor;

import com.google.common.base.Objects;
import fr.inria.diverse.k3.al.annotationprocessor.Helper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtend.lib.macro.CodeGenerationContext;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.CompilationUnit;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ProjectStaticDispatchBuilder {
    public static final String STATICDISPATCH_GENFOLDER = "staticdispatch-gen";
    public static final String INCREMENTALSTATICDISPATCH_FILEEXT = "isdp";
    private final Set<String> dispatchStaticInjection = CollectionLiterals.newHashSet();
    private final HashMap<String, HashMap<String, List<String>>> dispatchCodeForClass = new HashMap();

    public void writeTempStaticDispatchFile(CompilationUnit compilationUnit, @Extension CodeGenerationContext context) {
        boolean _not;
        Path fileRelativePath = compilationUnit.getFilePath().relativize(context.getSourceFolder(compilationUnit.getFilePath()));
        String destFileName = fileRelativePath.toString().replaceAll("/", ".");
        Path targetFilePath = context.getProjectFolder(compilationUnit.getFilePath()).append("/staticdispatch-gen/" + destFileName + "." + INCREMENTALSTATICDISPATCH_FILEEXT);
        boolean _isEmpty = this.dispatchStaticInjection.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            String contents = IterableExtensions.join(this.dispatchStaticInjection, (CharSequence)"\n");
            Helper.writeContentsIfNew(targetFilePath, contents, context);
        } else {
            boolean _exists = context.exists(targetFilePath);
            if (_exists) {
                context.delete(targetFilePath);
            }
        }
    }

    public void cleanDeprecatedDispatchFiles(CompilationUnit compilationUnit, @Extension CodeGenerationContext context) {
        Path folderPath = context.getProjectFolder(compilationUnit.getFilePath()).append("/staticdispatch-gen");
        Functions.Function1 _function = f -> f.getFileExtension() != null && Objects.equal((Object)f.getFileExtension(), (Object)INCREMENTALSTATICDISPATCH_FILEEXT);
        Iterable childWithCorrectExtension = IterableExtensions.filter((Iterable)context.getChildren(folderPath), (Functions.Function1)_function);
        Set sourceFolders = context.getProjectSourceFolders(compilationUnit.getCompilationUnit().getFilePath());
        Consumer<Path> _function_1 = f -> {
            String intermediate = f.getLastSegment().toString().replaceAll("\\.", "/");
            boolean _endsWith = intermediate.endsWith("/xtend/isdp");
            if (_endsWith) {
                boolean _not;
                String _substring = intermediate.substring(0, intermediate.lastIndexOf("/xtend/isdp"));
                String srcXtendFile = String.valueOf(_substring) + ".xtend";
                Functions.Function1 _function_2 = sfolder -> context.exists(sfolder.append(srcXtendFile));
                boolean _exists = IterableExtensions.exists((Iterable)sourceFolders, (Functions.Function1)_function_2);
                boolean bl = _not = !_exists;
                if (_not) {
                    context.delete(f);
                }
            }
        };
        childWithCorrectExtension.forEach(_function_1);
    }

    public boolean add(String dispatchInjectCodeForParent) {
        return this.dispatchStaticInjection.add(dispatchInjectCodeForParent);
    }

    public List<String> findExistingDispatchCalls(MutableMethodDeclaration methodDecl, @Extension TransformationContext context) {
        HashMap<String, List<String>> _get;
        boolean _tripleEquals;
        String targetClassQName = methodDecl.getDeclaringType().getQualifiedName();
        boolean _isEmpty = this.dispatchCodeForClass.isEmpty();
        if (_isEmpty) {
            Path folderPath = context.getProjectFolder(methodDecl.getCompilationUnit().getFilePath()).append("/staticdispatch-gen");
            Functions.Function1 _function = f -> f.getFileExtension() != null && Objects.equal((Object)f.getFileExtension(), (Object)INCREMENTALSTATICDISPATCH_FILEEXT);
            Iterable validChild = IterableExtensions.filter((Iterable)context.getChildren(folderPath), (Functions.Function1)_function);
            Consumer<Path> _function_1 = f -> this.parseAndCacheDispatchStaticInjection(context.getContents(f).toString());
            validChild.forEach(_function_1);
        }
        boolean bl = _tripleEquals = (_get = this.dispatchCodeForClass.get(targetClassQName)) == null;
        if (_tripleEquals) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        List<String> result = this.dispatchCodeForClass.get(targetClassQName).get(Helper.initialMethodSignature((MethodDeclaration)methodDecl));
        if (result != null) {
            return result;
        }
        return Collections.unmodifiableList(CollectionLiterals.newArrayList());
    }

    private void addDispatchCodeInCache(String targetClass, String targetMethod, String dispatchCode) {
        HashMap<String, List<String>> targetClassEntry;
        List<String> _get_1;
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        HashMap<String, List<String>> _get = this.dispatchCodeForClass.get(targetClass);
        boolean bl = _tripleEquals = _get == null;
        if (_tripleEquals) {
            HashMap _hashMap = new HashMap();
            this.dispatchCodeForClass.put(targetClass, _hashMap);
        }
        boolean bl2 = _tripleEquals_1 = (_get_1 = (targetClassEntry = this.dispatchCodeForClass.get(targetClass)).get(targetMethod)) == null;
        if (_tripleEquals_1) {
            ArrayList _arrayList = new ArrayList();
            targetClassEntry.put(targetMethod, _arrayList);
        }
        targetClassEntry.get(targetMethod).add(dispatchCode);
    }

    public void parseAndCacheDispatchStaticInjection(String content) {
        Scanner scanner = new Scanner(content);
        StringBuilder sb = new StringBuilder();
        String currentTargetMethod = "";
        String currentTargetClass = "";
        Pattern regexTargetAspectClass = Pattern.compile("// BeginInjectInto ([^#]+)*#");
        Pattern regexTargetMethod = Pattern.compile("#([^#].+\\))");
        while (scanner.hasNextLine()) {
            String currentLine = scanner.nextLine();
            boolean _contains = currentLine.contains("// BeginInjectInto");
            if (_contains) {
                Matcher tclassmatcher = regexTargetAspectClass.matcher(currentLine);
                boolean _find = tclassmatcher.find();
                if (_find) {
                    currentTargetClass = tclassmatcher.group(1);
                    Matcher tmethodmatcher = regexTargetMethod.matcher(currentLine);
                    boolean _find_1 = tmethodmatcher.find();
                    if (_find_1) {
                        currentTargetMethod = tmethodmatcher.group(1);
                    }
                }
                sb.append(currentLine);
                sb.append("\n");
                continue;
            }
            boolean _contains_1 = currentLine.contains("// EndInjectInto");
            if (_contains_1) {
                StringBuilder _stringBuilder;
                sb.append(currentLine);
                sb.append("\n");
                this.addDispatchCodeInCache(currentTargetClass, currentTargetMethod, sb.toString());
                sb = _stringBuilder = new StringBuilder();
                continue;
            }
            sb.append(currentLine);
            sb.append("\n");
        }
    }
}

