/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.serializer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.serializer.CustomSegmentSupport;
import org.eclipse.ocl.examples.xtext.serializer.SerializationBuilder;
import org.eclipse.ocl.examples.xtext.serializer.UserElementFormatter;
import org.eclipse.ocl.examples.xtext.serializer.UserElementSerializer;
import org.eclipse.ocl.pivot.Comment;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.utilities.Pivotable;

public class BaseCommentSegmentSupport
implements CustomSegmentSupport {
    protected @Nullable String prologue = "/**";
    protected @Nullable String indentation = " * ";
    protected @Nullable String epilogue = " */";
    private static final @NonNull String EMPTY_COMMENT = "/**/";

    protected void appendComment(@NonNull SerializationBuilder serializationBuilder, @NonNull String comment) {
        serializationBuilder.append(SerializationBuilder.HALF_NEW_LINE);
        if (comment == EMPTY_COMMENT) {
            serializationBuilder.append(EMPTY_COMMENT);
        } else {
            String line;
            int index;
            serializationBuilder.append(this.prologue);
            serializationBuilder.append(SerializationBuilder.PUSH_NEXT);
            serializationBuilder.append(this.indentation);
            boolean hasLeadingNewLine = false;
            int start = 0;
            while ((index = comment.indexOf(10, start)) >= 0) {
                if (!hasLeadingNewLine) {
                    hasLeadingNewLine = true;
                    serializationBuilder.append(SerializationBuilder.NEW_LINE);
                }
                line = comment.substring(start, index);
                assert (line != null);
                serializationBuilder.append(line);
                serializationBuilder.append(SerializationBuilder.NEW_LINE);
                start = index + 1;
            }
            if (!hasLeadingNewLine) {
                serializationBuilder.append(" ");
            }
            line = comment.substring(start, comment.length());
            assert (line != null);
            serializationBuilder.append(line);
            serializationBuilder.append(SerializationBuilder.POP);
            if (hasLeadingNewLine) {
                serializationBuilder.append(SerializationBuilder.NEW_LINE);
            }
            serializationBuilder.append(this.epilogue);
        }
        serializationBuilder.append(SerializationBuilder.NEW_LINE);
    }

    public void format(@NonNull UserElementFormatter fomatter, @NonNull SerializationBuilder serializationBuilder) {
        EObject eObject = fomatter.getElement();
        Iterable<@NonNull String> comments = this.getComments(eObject);
        if (comments != null) {
            for (String comment : comments) {
                this.appendComment(serializationBuilder, comment);
            }
        }
    }

    public @Nullable Iterable<@NonNull String> getComments(@NonNull EObject eObject) {
        List ownedComments;
        Element asElement;
        if (eObject instanceof Pivotable && (asElement = ((Pivotable)eObject).getPivot()) != null && !(ownedComments = asElement.getOwnedComments()).isEmpty()) {
            ArrayList<@NonNull String> comments = new ArrayList<String>();
            for (Comment asComment : ownedComments) {
                String body = asComment.getBody();
                comments.add(body != null ? body : EMPTY_COMMENT);
            }
            return comments;
        }
        return null;
    }

    public void serialize(int serializationStepIndex, @NonNull UserElementSerializer serializer, @NonNull SerializationBuilder serializationBuilder) {
        EObject eObject = serializer.getElement();
        Iterable<@NonNull String> comments = this.getComments(eObject);
        if (comments != null) {
            for (String comment : comments) {
                this.appendComment(serializationBuilder, comment);
            }
        }
    }
}

