/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ui.contentassist;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecoretools.ale.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.VarRef;
import org.eclipse.emf.ecoretools.ale.core.env.IBehaviors;
import org.eclipse.emf.ecoretools.ale.core.parser.ParsedFile;
import org.eclipse.emf.ecoretools.ale.implementation.Attribute;
import org.eclipse.emf.ecoretools.ale.implementation.BehavioredClass;
import org.eclipse.emf.ecoretools.ale.implementation.Block;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ui.contentassist.AbstractAleProposalProvider;
import org.eclipse.emf.ecoretools.ui.contentassist.TypeUtils;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.AbstractNode;
import org.eclipse.xtext.nodemodel.impl.CompositeNode;
import org.eclipse.xtext.nodemodel.impl.CompositeNodeWithSemanticElement;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class AleProposalProvider
extends AbstractAleProposalProvider {
    private final PrefixMatcher matchesCandidatesContainingTypedText = new PrefixMatcher(){

        public boolean isCandidateMatchingPrefix(String name, String prefix) {
            boolean _isEmpty = prefix.isEmpty();
            if (_isEmpty) {
                return true;
            }
            boolean _startsWith = name.startsWith(prefix);
            if (_startsWith) {
                return true;
            }
            boolean _contains = name.contains(prefix);
            return _contains;
        }
    };
    private final StyledString.Styler attributeNameStyler = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
        }
    };
    private final StyledString.Styler attributeTypeStyler = StyledString.QUALIFIER_STYLER;
    private final StyledString.Styler matchingCharactersStyler = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
        }
    };

    public void completeKeyword(Keyword keyword, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
    }

    public void completeRuleCall(RuleCall object, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    @Override
    public void completeExpression_Feature(EObject element, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String prefix = this.getOffsetPrefix(context);
        if (element instanceof VarRef) {
            String _xifexpression = null;
            boolean _contains = prefix.contains(".");
            if (_contains) {
                int _indexOf = prefix.indexOf(".");
                int _plus = _indexOf + 1;
                _xifexpression = prefix.substring(_plus);
            } else {
                _xifexpression = prefix;
            }
            String typed = _xifexpression;
            IBehaviors semantics = TypeUtils.getSemantics(element);
            EObject elementType = TypeUtils.findType((VarRef)element, semantics);
            if (elementType instanceof BehavioredClass) {
                this.createProposalsForBehavioredClass(acceptor, (BehavioredClass)elementType, element, semantics, typed, context);
            } else if (elementType instanceof ETypedElement) {
                this.createProposalsForETypedElement(acceptor, (ETypedElement)elementType, element, semantics, typed, context);
            }
        }
    }

    private void createProposalsForBehavioredClass(ICompletionProposalAcceptor acceptor, BehavioredClass clazz, EObject syntax, IBehaviors semantics, String typed, ContentAssistContext context) {
        Functions.Function1 _function = attribute -> this.matchesCandidatesContainingTypedText.isCandidateMatchingPrefix(attribute.getFeatureRef().getName(), typed);
        Consumer<Attribute> _function_1 = attribute -> this.createAttributeProposal(acceptor, attribute.getFeatureRef().getName(), TypeUtils.typeAsString((ETypedElement)attribute.getFeatureRef()), typed, context);
        IterableExtensions.filter((Iterable)clazz.getAttributes(), (Functions.Function1)_function).forEach(_function_1);
        if (clazz instanceof org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass) {
            org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass extendedClassInEcore = (org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass)clazz;
            Functions.Function1 _function_2 = ext -> {
                String _name = extendedClassInEcore.getName();
                String _name_1 = ext.getBaseClass().getName();
                return Objects.equal((Object)_name, (Object)_name_1);
            };
            org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass extendedClassInAleScript = (org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass)IterableExtensions.findFirst((Iterable)semantics.getOpenClasses(), (Functions.Function1)_function_2);
            Functions.Function1 _function_3 = feature -> this.matchesCandidatesContainingTypedText.isCandidateMatchingPrefix(feature.getName(), typed);
            Consumer<EStructuralFeature> _function_4 = feature -> this.createAttributeProposal(acceptor, feature.getName(), TypeUtils.typeAsString((ETypedElement)feature), typed, context);
            IterableExtensions.filter((Iterable)extendedClassInAleScript.getBaseClass().getEStructuralFeatures(), (Functions.Function1)_function_3).forEach(_function_4);
        }
    }

    private void createProposalsForETypedElement(ICompletionProposalAcceptor acceptor, ETypedElement clazz, EObject syntax, IBehaviors semantics, String typed, ContentAssistContext context) {
        if (!clazz.isMany() && clazz.getEType() instanceof EClass) {
            EClassifier _eType = clazz.getEType();
            this.createProposalsForEClass(acceptor, (EClass)_eType, syntax, semantics, typed, context);
        }
    }

    private void createProposalsForEClass(ICompletionProposalAcceptor acceptor, EClass clazz, EObject syntax, IBehaviors semantics, String typed, ContentAssistContext context) {
        Functions.Function1 _function = feature -> this.matchesCandidatesContainingTypedText.isCandidateMatchingPrefix(feature.getName(), typed);
        Consumer<EStructuralFeature> _function_1 = feature -> this.createAttributeProposal(acceptor, feature.getName(), TypeUtils.typeAsString((ETypedElement)feature), typed, context);
        IterableExtensions.filter((Iterable)clazz.getEStructuralFeatures(), (Functions.Function1)_function).forEach(_function_1);
        if (clazz instanceof ExtendedClass) {
            ExtendedClass extendedClassInEcore = (ExtendedClass)clazz;
            Functions.Function1 _function_2 = ext -> {
                String _name = extendedClassInEcore.getName();
                String _name_1 = ext.getBaseClass().getName();
                return Objects.equal((Object)_name, (Object)_name_1);
            };
            org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass extendedClassInAleScript = (org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass)IterableExtensions.findFirst((Iterable)semantics.getOpenClasses(), (Functions.Function1)_function_2);
            Functions.Function1 _function_3 = feature -> this.matchesCandidatesContainingTypedText.isCandidateMatchingPrefix(feature.getName(), typed);
            Consumer<EStructuralFeature> _function_4 = feature -> this.createAttributeProposal(acceptor, feature.getName(), TypeUtils.typeAsString((ETypedElement)feature), typed, context);
            IterableExtensions.filter((Iterable)extendedClassInAleScript.getBaseClass().getEStructuralFeatures(), (Functions.Function1)_function_3).forEach(_function_4);
        }
    }

    private void createAttributeProposal(ICompletionProposalAcceptor acceptor, String name, String type, String typed, ContentAssistContext context) {
        StyledString styledText = new StyledString(String.valueOf(name) + " : " + type);
        styledText.setStyle(0, name.length(), this.attributeNameStyler);
        int _length = styledText.length();
        int _length_1 = type.length();
        int _minus = _length - _length_1;
        styledText.setStyle(_minus, type.length(), this.attributeTypeStyler);
        int matchingCharactersIndex = name.indexOf(typed);
        styledText.setStyle(matchingCharactersIndex, typed.length(), this.matchingCharactersStyler);
        ConfigurableCompletionProposal completion = this.doCreateProposal(name, styledText, null, this.getPriorityHelper().getDefaultPriority(), context);
        if (completion instanceof ConfigurableCompletionProposal) {
            completion.setMatcher(this.matchesCandidatesContainingTypedText);
        }
        acceptor.accept((ICompletionProposal)completion);
    }

    @Override
    public void completeExpression_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    @Override
    public void complete_expression(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    private void addProposals(String expression, EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    private Expression getExpression(List<ParsedFile<ModelUnit>> parsedSemantics, int offset) {
        Functions.Function1 _function;
        ParsedFile unit;
        Iterable allExps;
        Expression candidate;
        boolean _not;
        Expression res = null;
        int start = 0;
        int end = 0;
        boolean _isEmpty = parsedSemantics.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not && (candidate = (Expression)IterableExtensions.findFirst((Iterable)(allExps = Iterables.filter((unit = (ParsedFile)IterableExtensions.head(parsedSemantics)).getStartPositions().keySet(), Expression.class)), (Functions.Function1)(_function = exp -> (Integer)unit.getStartPositions().get(exp) <= offset && (Integer)unit.getEndPositions().get(exp) >= offset))) != null) {
            res = candidate;
            start = (Integer)unit.getStartPositions().get(candidate);
            end = (Integer)unit.getEndPositions().get(candidate);
            while (res.eContainer() instanceof Expression) {
                EObject _eContainer = res.eContainer();
                res = (Expression)_eContainer;
            }
        }
        return res;
    }

    private Block getBlock(List<ParsedFile<ModelUnit>> parsedSemantics, int offset) {
        Functions.Function1 _function;
        ParsedFile unit;
        Iterable allExps;
        Block candidate;
        boolean _not;
        Block res = null;
        int start = 0;
        int end = 0;
        boolean _isEmpty = parsedSemantics.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not && (candidate = (Block)IterableExtensions.findFirst((Iterable)(allExps = Iterables.filter((unit = (ParsedFile)IterableExtensions.head(parsedSemantics)).getStartPositions().keySet(), Block.class)), (Functions.Function1)(_function = block -> (Integer)unit.getStartPositions().get(block) <= offset && (Integer)unit.getEndPositions().get(block) >= offset))) != null) {
            res = candidate;
            start = (Integer)unit.getStartPositions().get(candidate);
            end = (Integer)unit.getEndPositions().get(candidate);
            Iterable _drop = IterableExtensions.drop((Iterable)allExps, (int)1);
            for (Block block2 : _drop) {
                Integer _get_1;
                boolean _lessEqualsThan_1;
                boolean _lessEqualsThan;
                boolean _and = false;
                Integer _get = (Integer)unit.getStartPositions().get(block2);
                boolean bl2 = _lessEqualsThan = start <= _get;
                _and = !_lessEqualsThan ? false : (_lessEqualsThan_1 = (_get_1 = (Integer)unit.getEndPositions().get(block2)) <= end);
                start = (Integer)unit.getStartPositions().get(block2);
                end = (Integer)unit.getEndPositions().get(block2);
            }
        }
        return res;
    }

    private CompositeNode getBlockNode(INode node) {
        String debugDump = NodeModelUtils.compactDump((INode)node.getRootNode(), (boolean)true);
        INode current = node;
        while (!Objects.equal((Object)current, null)) {
            EObject _semanticElement;
            if (current instanceof CompositeNodeWithSemanticElement && (_semanticElement = ((CompositeNodeWithSemanticElement)current).getSemanticElement()) instanceof org.eclipse.emf.ecoretools.ale.Block) {
                return (CompositeNode)current;
            }
            current = current.getParent();
        }
        return null;
    }

    private AbstractNode findStatementNode(INode node, int offset) {
        boolean _notEquals;
        CompositeNode block = this.getBlockNode(node);
        boolean bl = _notEquals = !Objects.equal((Object)block, null);
        if (_notEquals) {
            Functions.Function1 _function = child -> child.getTextRegion().contains(offset);
            AbstractNode candidate = (AbstractNode)IterableExtensions.findFirst((Iterable)block.basicGetChildren(), (Functions.Function1)_function);
            return candidate;
        }
        return null;
    }

    private int findStart(String text, int offset) {
        int openIndex;
        int i = offset;
        while (i > 0) {
            String frame = text.substring(i - 1, i + 1);
            if (Objects.equal((Object)frame, (Object)":=") || Objects.equal((Object)frame, (Object)"+=") || Objects.equal((Object)frame, (Object)"-=") || Objects.equal((Object)frame, (Object)"in")) {
                if (i == offset) {
                    return offset;
                }
                return i + 1;
            }
            --i;
        }
        int whileIndex = text.indexOf("while");
        if (whileIndex != -1 && (openIndex = text.indexOf("(", whileIndex)) != -1) {
            return openIndex;
        }
        int ifIndex = text.indexOf("if");
        if (ifIndex != -1) {
            int openIndex_1 = text.indexOf("(", ifIndex);
            int thenIndex = text.indexOf("then", ifIndex);
            if (openIndex_1 != -1 && (thenIndex == -1 || openIndex_1 < thenIndex)) {
                return openIndex_1;
            }
        }
        return 0;
    }

    private String getOffsetPrefix(ContentAssistContext context) {
        try {
            INode _currentNode = context.getCurrentNode();
            int _offset = context.getOffset();
            int _minus = _offset - 1;
            AbstractNode stmtNode = this.findStatementNode(_currentNode, _minus);
            if (stmtNode != null) {
                String stmtText = context.getDocument().get(stmtNode.getOffset(), stmtNode.getLength());
                int _offset_1 = context.getOffset();
                int _minus_1 = _offset_1 - 1;
                int _offset_2 = stmtNode.getOffset();
                int _minus_2 = _minus_1 - _offset_2;
                int startIndex = this.findStart(stmtText, _minus_2);
                int _offset_3 = stmtNode.getOffset();
                int startOffset = _offset_3 + startIndex;
                IXtextDocument _document = context.getDocument();
                int _offset_4 = context.getOffset();
                int _minus_3 = _offset_4 - startOffset;
                return _document.get(startOffset, _minus_3);
            }
            return "";
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

