/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.ide.ui.launchconfig;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecoretools.ale.core.validation.QualifiedNames;
import org.eclipse.emf.ecoretools.ale.ide.ui.Activator;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.Method;

public class MethodRepresentation {
    private final Method method;
    private final EObject owner;
    private final EObject target;

    private MethodRepresentation(Method method, EObject owner, EObject target) {
        this.method = method;
        this.owner = owner;
        this.target = target;
    }

    public static MethodRepresentation of(Method method, EObject owner) {
        return MethodRepresentation.of(method, owner, null);
    }

    public static MethodRepresentation of(Method method, EObject owner, EObject target) {
        return new MethodRepresentation(method, owner, target);
    }

    public String toString() {
        EOperation operation = this.method.getOperationRef();
        String ownerName = MethodRepresentation.getQualifiedName(this.method.eContainer());
        String commaSeparatedParameters = MethodRepresentation.commaSeparated((List<EParameter>)operation.getEParameters());
        String representation = String.valueOf(ownerName) + "." + operation.getName() + "(" + commaSeparatedParameters + ")";
        if (this.owner != null) {
            representation = String.valueOf(representation) + " on " + MethodRepresentation.targetAsString(this.target, this.owner);
        }
        return representation;
    }

    private static String targetAsString(EObject target, EObject owner) {
        if (target == null) {
            return MethodRepresentation.getQualifiedName(owner);
        }
        return MethodRepresentation.getName(target, owner);
    }

    private static String getName(EObject target, EObject owner) {
        EStructuralFeature nameFeature = target.eClass().getEStructuralFeature("name");
        if (nameFeature != null) {
            String name = "" + target.eGet(nameFeature);
            return String.valueOf(name) + " (" + MethodRepresentation.getQualifiedName(owner) + ")";
        }
        return MethodRepresentation.getQualifiedName(owner);
    }

    private static String getQualifiedName(EObject element) {
        if (element instanceof ExtendedClass) {
            return QualifiedNames.getQualifiedName((EClassifier)((ExtendedClass)element).getBaseClass());
        }
        if (element instanceof EClassifier) {
            return QualifiedNames.getQualifiedName((EClassifier)((EClassifier)element));
        }
        Activator.warn("Cannot determine label for method owner: " + element, null);
        return "" + element;
    }

    private static String commaSeparated(List<EParameter> parameters) {
        return parameters.stream().map(ETypedElement::getEType).map(MethodRepresentation::getQualifiedName).collect(Collectors.joining(", "));
    }
}

