/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.sequential.javaxdsml.ide.ui.editor;

import fr.inria.diverse.k3.ui.wizards.NewK3ProjectWizard;
import fr.inria.diverse.k3.ui.wizards.pages.NewK3ProjectWizardFields;
import fr.inria.diverse.melange.metamodel.melange.Language;
import fr.inria.diverse.melange.metamodel.melange.ModelTypingSpace;
import fr.inria.diverse.melange.ui.contentassist.IProposal;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.gemoc.commons.eclipse.core.resources.NewProjectWorkspaceListener;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChanger;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.TemplateListSelectionPage;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.BaseProjectWizardFields;
import org.eclipse.gemoc.commons.eclipse.ui.WizardFinder;
import org.eclipse.gemoc.execution.sequential.javaxdsml.ide.ui.Activator;
import org.eclipse.gemoc.execution.sequential.javaxdsml.ide.ui.templates.SequentialSingleLanguageTemplate;
import org.eclipse.gemoc.xdsmlframework.ui.utils.XDSMLProjectHelper;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class CreateDSAProposal
implements IProposal {
    private IProject dsaProject;
    private String packageName = "packageName";
    private String languageName = "languageName";
    private IFile ecoreFile;

    public String getDisplayText() {
        return "-- Create a DSA Project --";
    }

    public String getReplacementText() {
        IWizardDescriptor descriptor = WizardFinder.findNewWizardDescriptor((String)"fr.inria.diverse.k3.ui.wizards.WizardNewProjectK3Plugin");
        if (descriptor != null) {
            NewProjectWorkspaceListener workspaceListener = new NewProjectWorkspaceListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)workspaceListener);
            try {
                IWorkbenchWizard wizard = descriptor.createWizard();
                NewK3ProjectWizard k3Wizard = (NewK3ProjectWizard)wizard;
                try {
                    String p = this.ecoreFile.getLocationURI().toString().replaceFirst("\\.ecore$", ".genmodel");
                    GenModel genmodel = this.loadGenmodel(p);
                    GenPackage root = (GenPackage)genmodel.getGenPackages().get(0);
                    String base = root.getBasePackage();
                    if (base == null) {
                        base = "";
                    }
                    k3Wizard.getContext().basePackage = base;
                }
                catch (Exception exception) {}
                k3Wizard.getContext().ecoreIFile = this.ecoreFile;
                WizardDialog wd = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                wd.create();
                k3Wizard.getPageProject().setProjectName(String.valueOf(this.packageName) + "." + this.languageName + ".k3dsa");
                k3Wizard.getPageProject().setProjectKind(NewK3ProjectWizardFields.KindsOfProject.PLUGIN);
                if (this.ecoreFile != null) {
                    TemplateListSelectionPage templatePage = k3Wizard.getTemplateListSelectionPage((BaseProjectWizardFields)k3Wizard.getContext());
                    templatePage.setUseTemplate(true);
                    templatePage.setInitialTemplateId("fr.inria.diverse.k3.ui.templates.projectContent.UserEcoreBasicAspect");
                    templatePage.selectTemplate("fr.inria.diverse.k3.ui.templates.projectContent.UserEcoreBasicAspect");
                }
                wd.setTitle("New Kermeta 3 project");
                int res = wd.open();
                if (res == 0) {
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceListener);
                    this.dsaProject = workspaceListener.getLastCreatedProject();
                    this.waitForAutoBuild();
                    Set<String> aspects = SequentialSingleLanguageTemplate.getAspectClassesList(this.dsaProject);
                    StringBuilder insertion = new StringBuilder();
                    for (String asp : aspects) {
                        insertion.append("\twith " + asp + "\n");
                    }
                    insertion.replace(0, 1, "");
                    String string = insertion.toString();
                    return string;
                }
            }
            catch (CoreException e) {
                Activator.error(e.getMessage(), e);
            }
            finally {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceListener);
            }
        }
        return "";
    }

    public void configureProject(IProject project) {
        ManifestChanger manifestChanger = new ManifestChanger(project);
        try {
            manifestChanger.addPluginDependency(this.dsaProject.getName());
            manifestChanger.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void configureProposal(EObject context) {
        if (context instanceof Language) {
            Language lang = (Language)context;
            this.packageName = ((ModelTypingSpace)lang.eContainer()).getName().toLowerCase();
            this.languageName = lang.getName().toLowerCase();
            this.ecoreFile = XDSMLProjectHelper.getFirstEcore((Language)lang);
        }
    }

    private void waitForAutoBuild() {
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                wasInterrupted = false;
            }
            catch (OperationCanceledException e) {
                e.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    private GenModel loadGenmodel(String path) {
        try {
            if (!EPackage.Registry.INSTANCE.containsKey((Object)"http://www.eclipse.org/emf/2002/GenModel")) {
                EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2002/GenModel", (Object)GenModelPackage.eINSTANCE);
            }
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("genmodel", new XMIResourceFactoryImpl());
            ResourceSetImpl rs = new ResourceSetImpl();
            URI uri = URI.createURI((String)path);
            Resource pkg = rs.getResource(uri, true);
            return (GenModel)pkg.getContents().get(0);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

