/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.templates;

import fr.inria.diverse.melange.ui.wizards.pages.NewMelangeProjectWizardFields;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.gemoc.commons.eclipse.core.resources.FileFinderVisitor;
import org.eclipse.gemoc.commons.eclipse.core.resources.IFolderUtils;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChanger;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.BaseProjectWizardFields;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.templates.AbstractStringWithButtonOption;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.templates.BaseOptionTemplateSection;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.templates.TemplateOption;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.Activator;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.templates.JavaxdsmlTemplateSection;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.templates.WizardTemplateMessages;
import org.eclipse.gemoc.xdsmlframework.commons.ui.k3.dialogs.SelectDSAIProjectDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.util.Strings;
import org.osgi.framework.BundleException;

public class ConcurrentTemplate
extends JavaxdsmlTemplateSection {
    public static final String KEY_DSL_FILE_NAME = "dslFileName";
    public static final String KEY_ASPECTCLASS_POSTFIX = "aspectClassPostfix";
    public static final String KEY_LANGUAGE_NAME = "languageName";
    public static final String METAMODEL_NAME = "MyLanguage";
    public static final String KEY_ECOREFILE_PATH = "ecoreFilePath";
    public static final String KEY_LANGUAGE_NAME_LCFIRST = "languageNameLCFirst";
    public static final String KEY_IS_SYNTAX_COMMENTED = "isSyntaxStatementCommented";
    public static final String KEY_ASPECTS = "listOfAspects";
    public static final String KEY_MOCCML_MAPPING_FILE_PATH = "moccmlMappingFilePath";
    protected static final List<String> FILE_ECL_EXTENSIONS = Arrays.asList("ecl");
    protected static final List<String> FILE_EXTENSIONS = Arrays.asList("ecore");
    NewMelangeProjectWizardFields _data;
    public IFile ecoreIFile;
    protected String ecoreProjectPath;
    protected String dsaProjectName;
    public IFile eclIFile;
    private TemplateOption dsaProjectLocationOption;

    public ConcurrentTemplate() {
        this.setPageCount(1);
        this.createOptions();
    }

    private void createOptions() {
        this.addOption("packageName", WizardTemplateMessages.ConcurrentLanguageTemplate_packageName, WizardTemplateMessages.ConcurrentLanguageTemplate_packageNameToolTip, null, 0);
        this.addOption(KEY_LANGUAGE_NAME, WizardTemplateMessages.ConcurrentLanguageTemplate_melangeMetamodelName, WizardTemplateMessages.ConcurrentLanguageTemplate_melangeMetamodelNameToolTip, METAMODEL_NAME, 0);
        this.addBlankField(0);
        this.addOption(KEY_DSL_FILE_NAME, WizardTemplateMessages.ConcurrentLanguageTemplate_melangeFileName, WizardTemplateMessages.ConcurrentLanguageTemplate_melangeFileNameTooltip, WizardTemplateMessages.ConcurrentLanguageTemplate_melangeDefaultFileName, 0);
        this.addBlankField(0);
        AbstractStringWithButtonOption ecoreLocationOption = new AbstractStringWithButtonOption((BaseOptionTemplateSection)this, KEY_ECOREFILE_PATH, WizardTemplateMessages.ConcurrentLanguageTemplate_ecoreFileLocation, WizardTemplateMessages.ConcurrentLanguageTemplate_ecoreFileLocationTooltip){

            public String doSelectButton() {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                Object selection = null;
                if (workbenchWindow.getSelectionService().getSelection() instanceof IStructuredSelection) {
                    selection = ((IStructuredSelection)workbenchWindow.getSelectionService().getSelection()).getFirstElement();
                }
                final IFile selectedEcoreFile = selection != null && selection instanceof IFile && FILE_EXTENSIONS.contains(((IFile)selection).getFileExtension()) ? (IFile)selection : null;
                ViewerFilter viewerFilter = new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        if (element instanceof IFile) {
                            IFile file = (IFile)element;
                            return FILE_EXTENSIONS.contains(file.getFileExtension()) && (selectedEcoreFile == null || !selectedEcoreFile.getFullPath().equals((Object)file.getFullPath()));
                        }
                        return true;
                    }
                };
                IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)workbenchWindow.getShell(), null, (String)"Select ecore", (boolean)true, null, Collections.singletonList(viewerFilter));
                if (files.length > 0) {
                    ConcurrentTemplate.this.ecoreIFile = files[0];
                    ConcurrentTemplate.this.ecoreProjectPath = files[0].getProject().getFullPath().toString();
                    String ecorePath = files[0].getFullPath().toString();
                    if (ecorePath.charAt(0) == '/') {
                        ecorePath = ecorePath.substring(1);
                    }
                    return ecorePath;
                }
                return null;
            }
        };
        ecoreLocationOption.setRequired(false);
        this.registerOption((TemplateOption)ecoreLocationOption, null, 0);
        this.dsaProjectLocationOption = new AbstractStringWithButtonOption((BaseOptionTemplateSection)this, KEY_ASPECTS, WizardTemplateMessages.ConcurrentLanguageTemplate_dsaProjectName, WizardTemplateMessages.ConcurrentLanguageTemplate_dsaProjectNameTooltip){

            public String doSelectButton() {
                SelectDSAIProjectDialog dialog = new SelectDSAIProjectDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                dialog.open();
                Object[] selection = dialog.getResult();
                if (selection != null && selection.length > 0) {
                    ConcurrentTemplate.this.dsaProjectName = ((IProject)selection[0]).getName();
                    return ConcurrentTemplate.this.dsaProjectName;
                }
                return null;
            }
        };
        this.dsaProjectLocationOption.setRequired(false);
        this.registerOption(this.dsaProjectLocationOption, null, 0);
        this.addBlankField(0);
        AbstractStringWithButtonOption eclLocationOption = new AbstractStringWithButtonOption((BaseOptionTemplateSection)this, KEY_MOCCML_MAPPING_FILE_PATH, WizardTemplateMessages.ConcurrentLanguageTemplate_eclFileLocation, WizardTemplateMessages.ConcurrentLanguageTemplate_eclFileLocationTooltip){

            public String doSelectButton() {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                Object selection = null;
                if (workbenchWindow.getSelectionService().getSelection() instanceof IStructuredSelection) {
                    selection = ((IStructuredSelection)workbenchWindow.getSelectionService().getSelection()).getFirstElement();
                }
                final IFile selectedEcoreFile = selection != null && selection instanceof IFile && FILE_ECL_EXTENSIONS.contains(((IFile)selection).getFileExtension()) ? (IFile)selection : null;
                ViewerFilter viewerFilter = new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        if (element instanceof IFile) {
                            IFile file = (IFile)element;
                            return FILE_ECL_EXTENSIONS.contains(file.getFileExtension()) && (selectedEcoreFile == null || !selectedEcoreFile.getFullPath().equals((Object)file.getFullPath()));
                        }
                        return true;
                    }
                };
                IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)workbenchWindow.getShell(), null, (String)"Select ecl file", (boolean)true, null, Collections.singletonList(viewerFilter));
                if (files.length > 0) {
                    ConcurrentTemplate.this.eclIFile = files[0];
                    String eclPath = files[0].getFullPath().toString();
                    if (eclPath.charAt(0) == '/') {
                        eclPath = eclPath.substring(1);
                    }
                    return eclPath;
                }
                return null;
            }
        };
        eclLocationOption.setRequired(false);
        this.registerOption((TemplateOption)eclLocationOption, null, 0);
    }

    public void addPages(Wizard wizard) {
        WizardPage page = this.createPage(0, "org.eclipse.pde.doc.user.template_concurrent_language");
        page.setTitle(WizardTemplateMessages.ConcurrentLanguageTemplate_title);
        page.setDescription(WizardTemplateMessages.ConcurrentLanguageTemplate_desc);
        wizard.addPage((IWizardPage)page);
        this.markPagesAdded();
    }

    public boolean isDependentOnParentWizard() {
        return true;
    }

    public void updateOptions(String packageName, String languageName, String fileName) {
        TemplateOption[] allOptions;
        TemplateOption[] templateOptionArray = allOptions = this.getOptions(0);
        int n = allOptions.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateOption option = templateOptionArray[n2];
            if (option.getName().equals("packageName") && packageName != null) {
                option.setValue((Object)packageName);
            } else if (option.getName().equals(KEY_LANGUAGE_NAME) && languageName != null) {
                option.setValue((Object)languageName);
            } else if (option.getName().equals(KEY_DSL_FILE_NAME) && fileName != null) {
                option.setValue((Object)fileName);
            }
            ++n2;
        }
    }

    protected void initializeFields(BaseProjectWizardFields data) {
        String projectName = ((NewMelangeProjectWizardFields)data).projectName;
        String packageName = this.inferPackageNameFromProjectName(projectName);
        this.initializeOption("packageName", packageName);
        this._data = (NewMelangeProjectWizardFields)data;
        String languageName = this.inferLanguageNameFromProjectName(projectName);
        this.updateOptions(packageName, languageName, languageName);
    }

    protected String inferPackageNameFromProjectName(String projectName) {
        String projectNameCandidate = projectName;
        projectNameCandidate = this.removePostFix(projectNameCandidate, ".xdsml");
        projectNameCandidate = this.removePostFix(projectNameCandidate, ".model");
        projectNameCandidate = this.removePostFix(projectNameCandidate, ".dsl");
        return this.getFormattedPackageName(projectNameCandidate);
    }

    protected String inferLanguageNameFromProjectName(String projectName) {
        String projectNameCandidate = projectName;
        projectNameCandidate = this.removePostFix(projectNameCandidate, ".xdsml");
        projectNameCandidate = this.removePostFix(projectNameCandidate, ".model");
        if ((projectNameCandidate = this.removePostFix(projectNameCandidate, ".dsl")).contains(".") && !projectNameCandidate.endsWith(".")) {
            projectNameCandidate = projectNameCandidate.substring(projectNameCandidate.lastIndexOf(".") + 1);
        }
        return Strings.toFirstUpper((String)projectNameCandidate);
    }

    protected String removePostFix(String baseString, String postFix) {
        if (baseString.endsWith(postFix)) {
            return baseString.substring(0, baseString.lastIndexOf(postFix));
        }
        return baseString;
    }

    public String getUsedExtensionPoint() {
        return "org.eclipse.ui.actionSets";
    }

    public String getSectionId() {
        return "ConcurrentLanguage";
    }

    @Override
    public URL getTemplateLocation() {
        try {
            String[] candidates = this.getDirectoryCandidates();
            int i = 0;
            while (i < candidates.length) {
                if (Activator.getDefault().getBundle().getEntry(candidates[i]) != null) {
                    URL candidate = new URL(this.getInstallURL(), candidates[i]);
                    return candidate;
                }
                ++i;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected URL getInstallURL() {
        return Activator.getDefault().getBundle().getEntry("/");
    }

    public static Set<String> getAspectClassesList(IProject k3IProject) {
        HashSet<String> aspectClasses = new HashSet<String>();
        FileFinderVisitor projectVisitor = new FileFinderVisitor("properties");
        try {
            k3IProject.accept((IResourceVisitor)projectVisitor);
            List possibleAspectMappingPropertiesFiles = projectVisitor.getFiles();
            for (IFile aspectMappingPropertiesFile : possibleAspectMappingPropertiesFiles) {
                if (!aspectMappingPropertiesFile.getName().endsWith("k3_aspect_mapping.properties")) continue;
                Properties properties = new Properties();
                if (!aspectMappingPropertiesFile.exists()) continue;
                try {
                    properties.load(aspectMappingPropertiesFile.getContents());
                    for (Object commaSeparatedPropvalues : properties.values()) {
                        String[] stringArray = ((String)commaSeparatedPropvalues).split(",");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String propVal = stringArray[n2];
                            aspectClasses.add(propVal);
                            ++n2;
                        }
                    }
                }
                catch (IOException e) {
                    Activator.error(e.getMessage(), e);
                }
                catch (CoreException e) {
                    Activator.error(e.getMessage(), e);
                }
            }
        }
        catch (CoreException e) {
            Activator.error(e.getMessage(), e);
        }
        return aspectClasses;
    }

    public void execute(IProject project, IProgressMonitor monitor) throws CoreException {
        this.addOption(KEY_LANGUAGE_NAME_LCFIRST, null, null, Strings.toFirstLower((String)this.getStringOption(KEY_LANGUAGE_NAME)), 0);
        this.addOption(KEY_IS_SYNTAX_COMMENTED, null, null, this.ecoreIFile == null ? "//" : "", 0);
        String DEFAULT_VALUE = "qualified.class.name";
        String selection = this.dsaProjectName;
        if (selection != null && !selection.isEmpty()) {
            IProject dsaProject = ResourcesPlugin.getWorkspace().getRoot().getProject(selection);
            ArrayList<String> aspects = new ArrayList<String>(ConcurrentTemplate.getAspectClassesList(dsaProject));
            Collections.sort(aspects);
            StringJoiner sj = new StringJoiner(",");
            StringBuilder templateWith = new StringBuilder();
            if (aspects.isEmpty()) {
                templateWith.append("qualified.class.name");
            } else {
                for (String aspect : aspects) {
                    sj.add(aspect);
                }
                templateWith.append(sj);
            }
            this.dsaProjectLocationOption.setValue((Object)templateWith.toString());
        } else {
            this.dsaProjectLocationOption.setValue((Object)"qualified.class.name");
        }
        super.execute(project, monitor);
    }

    @Override
    protected void generateFiles(IProgressMonitor monitor) throws CoreException {
        ManifestChanger manifestChanger;
        super.generateFiles(monitor);
        if (this.dsaProjectName != null && !this.dsaProjectName.isEmpty()) {
            try {
                manifestChanger = new ManifestChanger(this.project.getFile("META-INF/MANIFEST.MF"));
                manifestChanger.addPluginDependency(this.dsaProjectName, "0.0.0", false, true);
                manifestChanger.commit();
            }
            catch (IOException | BundleException throwable) {
                // empty catch block
            }
        }
        if (this.ecoreIFile != null) {
            try {
                manifestChanger = new ManifestChanger(this.project.getFile("META-INF/MANIFEST.MF"));
                manifestChanger.addPluginDependency(this.ecoreIFile.getProject().getName(), "0.0.0", false, true);
                manifestChanger.commit();
            }
            catch (IOException | BundleException throwable) {
                // empty catch block
            }
        }
        IFolderUtils.createFolder((String)"model-gen", (IProject)this.project, (IProgressMonitor)monitor);
    }

    public void validateOptions(TemplateOption source) {
        String langName;
        super.validateOptions(source);
        if (source.getName().contentEquals(KEY_LANGUAGE_NAME) && (langName = this.getStringOption(KEY_LANGUAGE_NAME)) != null && !langName.isEmpty() && !Character.isUpperCase(langName.charAt(0))) {
            this.flagErrorOnOption(source, WizardTemplateMessages.FirstCharUpperError);
        }
    }
}

