/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.vcdgenerator.manager;

import fr.inria.aoste.timesquare.backend.manager.datastructure.Entity;
import fr.inria.aoste.timesquare.backend.manager.datastructure.clock.ClockBehaviorEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorManager;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockBehavior;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.ConfigurationHelper;
import fr.inria.aoste.timesquare.backend.manager.visible.DeleteHelper;
import fr.inria.aoste.timesquare.backend.manager.visible.PersistentOptions;
import fr.inria.aoste.timesquare.backend.manager.visible.RelationBehavior;
import fr.inria.aoste.timesquare.backend.vcdgenerator.ScoreBoard;
import fr.inria.aoste.timesquare.backend.vcdgenerator.behaviors.AbstractVCDClockBehavior;
import fr.inria.aoste.timesquare.backend.vcdgenerator.behaviors.DurationClockBehavior;
import fr.inria.aoste.timesquare.backend.vcdgenerator.behaviors.GenericDurationClockBehavior;
import fr.inria.aoste.timesquare.backend.vcdgenerator.behaviors.TimerClockBehavior;
import fr.inria.aoste.timesquare.backend.vcdgenerator.behaviors.VCDGeneratorClockBehavior;
import fr.inria.aoste.timesquare.backend.vcdgenerator.manager.VCDBehaviorConfigurator;
import fr.inria.aoste.timesquare.backend.vcdgenerator.persistentoptions.DurationPersistentOptions;
import fr.inria.aoste.timesquare.backend.vcdgenerator.persistentoptions.GenericDurationPersistentOptions;
import fr.inria.aoste.timesquare.backend.vcdgenerator.persistentoptions.PlugInPersistentOptions;
import fr.inria.aoste.timesquare.backend.vcdgenerator.persistentoptions.TimerPersistentOptions;
import fr.inria.aoste.timesquare.backend.vcdgenerator.persistentoptions.VCDGeneratorPersistentOptions;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockConstraintSystem;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ConcreteEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.NamedElement;
import fr.inria.aoste.timesquare.duration.model.duration.CommunicationDuration;
import fr.inria.aoste.timesquare.duration.model.duration.Duration;
import fr.inria.aoste.timesquare.duration.model.duration.DurationModel;
import fr.inria.aoste.timesquare.duration.model.duration.GenericDuration;
import fr.inria.aoste.timesquare.duration.model.duration.Timer;
import fr.inria.aoste.timesquare.launcher.core.inter.ISolverForBackend;
import fr.inria.aoste.timesquare.trace.util.HelperFactory;
import fr.inria.aoste.timesquare.trace.util.ReferenceNameBuilder;
import fr.inria.aoste.timesquare.trace.util.TimeBase;
import fr.inria.aoste.timesquare.trace.util.adapter.AdapterRegistry;
import fr.inria.aoste.timesquare.utils.console.ErrorConsole;
import fr.inria.aoste.timesquare.utils.pluginhelpers.PluginHelpers;
import fr.inria.aoste.timesquare.vcd.antlr.editors.VcdMultiPageEditor;
import fr.inria.aoste.timesquare.vcd.antlr.view.ConstraintView;
import fr.inria.aoste.timesquare.vcd.menu.Mode;
import fr.inria.aoste.timesquare.vcd.model.ICommentCommand;
import fr.inria.aoste.timesquare.vcd.model.IDeclarationCommand;
import fr.inria.aoste.timesquare.vcd.model.VCDDefinitions;
import fr.inria.aoste.timesquare.vcd.model.command.DateCommand;
import fr.inria.aoste.timesquare.vcd.model.command.SimulationCommand;
import fr.inria.aoste.timesquare.vcd.model.command.TimeScaleCommand;
import fr.inria.aoste.timesquare.vcd.model.command.VersionCommand;
import fr.inria.aoste.timesquare.vcd.model.comment.ScaleCommand;
import fr.inria.aoste.timesquare.vcd.model.keyword.TimeUnit;
import fr.inria.aoste.timesquare.vcd.preferences.VcdColorPreferences;
import fr.inria.aoste.trace.LogicalStep;
import fr.inria.aoste.trace.ModelElementReference;
import fr.inria.aoste.trace.PhysicalBase;
import fr.inria.aoste.trace.Reference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.Display;

public class VCDGeneratorManager
extends BehaviorManager {
    private static final String PLUGIN_NAME = "VCD Generation";
    private static final String VERSION_NAME = "2.1.0";
    private Vector<AbstractVCDClockBehavior> _behaviorList;
    private ScoreBoard _scoreBoard;
    private VcdMultiPageEditor _vcdEditor;
    private IPath _outputFilePath;
    private String _outputFileName;
    private VcdColorPreferences _myColorAPI;
    private boolean _pulses = false;
    private boolean _ghosts = false;
    private int previousSize = 0;
    private boolean _launchVCDViewer = true;
    private int _currentStep = 0;
    private String _durationModelFilename;
    private ResourceSet _resourceSet;
    private Resource _resource;
    private DurationModel _durationModelRoot;
    private String discretize = null;
    HashMap<String, DurationClockBehavior> durationBehaviorsCache = new HashMap();
    private ScaleCommand scaleCommand;
    TimeScaleCommand tc;
    PhysicalBase pb = null;
    TimeBase physical = null;
    private HashMap<Integer, StepManager> hmism = new HashMap();
    private List<StepManager> lsstep = new ArrayList<StepManager>();

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    public String get_durationModelFilename() {
        return this._durationModelFilename;
    }

    public void set_durationModelFilename(String _durationModelFilename) {
        this._durationModelFilename = _durationModelFilename;
    }

    public void init(ConfigurationHelper helper) {
        super.init(helper);
        this._behaviorList = new Vector();
        this.clear();
    }

    public void addVCDGeneratorBehavior(ClockEntity clockEntity, boolean pulses, boolean ghosts, ClockEntity discretize) {
        for (AbstractVCDClockBehavior b : this._behaviorList) {
            if (!(b instanceof VCDGeneratorClockBehavior) || !((VCDGeneratorClockBehavior)b).getName().equals(clockEntity.getName())) continue;
            return;
        }
        this.addVCDGeneratorBehavior(new VCDGeneratorClockBehavior(pulses, ghosts, clockEntity.getName(), discretize != null ? AdapterRegistry.getAdapter((EObject)discretize.getModelElementReference()).getUID((EObject)discretize.getModelElementReference()) : ""), clockEntity, discretize);
    }

    private void addVCDGeneratorBehavior(VCDGeneratorClockBehavior behavior, ClockEntity clockEntity, ClockEntity discretize) {
        this.addVCDGeneratorBehavior(behavior);
        VCDGeneratorPersistentOptions options = new VCDGeneratorPersistentOptions(behavior.isPulses(), behavior.isGhosts(), behavior.getName(), discretize);
        if (this._helper != null) {
            this._helper.addBehavior(clockEntity, this._helper.getAlwaysState(), this.getPluginName(), (ClockBehavior)behavior, (PersistentOptions)options);
        }
    }

    private void addVCDGeneratorBehavior(VCDGeneratorClockBehavior behavior) {
        this._behaviorList.add(behavior);
        if (behavior.isPulses()) {
            this._pulses = true;
        }
        if (behavior.isGhosts()) {
            this._ghosts = true;
        }
        this.discretize = behavior.getDiscretize();
    }

    private ClockEntity findClockEntity(ConcreteEntity clock) {
        String separator = "::";
        String clockPath = this.buildPhysicalPath(clock, separator);
        for (ClockEntity ce : this._helper.getClocks()) {
            ModelElementReference mer = ce.getModelElementReference();
            String path = ReferenceNameBuilder.buildQualifiedName((ModelElementReference)mer, (String)separator);
            if (clockPath.compareTo(path) != 0) continue;
            return ce;
        }
        return null;
    }

    private String buildPhysicalPath(ConcreteEntity clock, String separator) {
        StringBuilder sb = new StringBuilder(clock.getName());
        EObject container = clock.eContainer();
        while (container != null) {
            if (container instanceof NamedElement && !(container instanceof ClockConstraintSystem)) {
                sb.insert(0, separator);
                sb.insert(0, ((NamedElement)container).getName());
            }
            container = container.eContainer();
        }
        return sb.toString();
    }

    private DurationClockBehavior getDurationBehaviorFromCache(String key) {
        return this.durationBehaviorsCache.get(key);
    }

    private DurationClockBehavior getDurationBehaviorFromCache(Duration duration) {
        String URIFragment = duration.eResource().getURIFragment((EObject)duration);
        String key = String.valueOf(this._durationModelFilename) + URIFragment;
        return this.getDurationBehaviorFromCache(key);
    }

    private void storeDurationBehaviorInCache(String key, DurationClockBehavior behavior) {
        this.durationBehaviorsCache.put(key, behavior);
    }

    private void storeDurationBehaviorInCache(Duration duration, DurationClockBehavior behavior) {
        String URIFragment = duration.eResource().getURIFragment((EObject)duration);
        String key = String.valueOf(this._durationModelFilename) + URIFragment;
        this.storeDurationBehaviorInCache(key, behavior);
    }

    public void createDurationBehaviors() {
        if (this._durationModelFilename == null || this._durationModelFilename.isEmpty()) {
            this.deleteDurationModel();
            ArrayList<AbstractVCDClockBehavior> toRemove = new ArrayList<AbstractVCDClockBehavior>();
            for (AbstractVCDClockBehavior behavior : this._behaviorList) {
                if (!(behavior instanceof DurationClockBehavior)) continue;
                toRemove.add(behavior);
            }
            this._behaviorList.removeAll(toRemove);
            for (AbstractVCDClockBehavior behavior : toRemove) {
                this.removeDurationBehavior((DurationClockBehavior)behavior);
            }
        } else if (this._durationModelRoot == null) {
            this.loadDurationModel();
        }
        if (this._durationModelRoot == null) {
            return;
        }
        for (Duration duration : this._durationModelRoot.getDurations()) {
            DurationClockBehavior behavior;
            DurationClockBehavior existing = this.getDurationBehaviorFromCache(duration);
            if (existing != null) continue;
            if (duration instanceof GenericDuration) {
                behavior = this.buildClockToClockBehaviour((GenericDuration)duration);
                if (behavior == null) continue;
                this.addClockToClockBehavior((GenericDurationClockBehavior)behavior, duration.eResource().getURIFragment((EObject)duration));
                this.storeDurationBehaviorInCache(duration, behavior);
                continue;
            }
            if (!(duration instanceof Timer) || (behavior = this.buildTimerClockBehavior((Timer)duration)) == null) continue;
            this.addTimerBehavior((TimerClockBehavior)behavior, duration.eResource().getURIFragment((EObject)duration));
            this.storeDurationBehaviorInCache(duration, behavior);
        }
    }

    private GenericDurationClockBehavior buildClockToClockBehaviour(GenericDuration duration) {
        boolean useRef;
        ConcreteEntity start = duration.getStart();
        ClockEntity startCE = this.findClockEntity(start);
        ConcreteEntity end = duration.getEnd();
        ClockEntity endCE = this.findClockEntity(end);
        if (startCE == null || endCE == null) {
            return null;
        }
        ConcreteEntity reference = duration.getRef();
        ClockEntity refCE = null;
        boolean bl = useRef = reference != null;
        if (useRef && (refCE = this.findClockEntity(reference)) == null) {
            return null;
        }
        boolean displayedOverlap = duration.isDisplayedOverlap();
        int mode = duration instanceof CommunicationDuration ? 1 : 0;
        GenericDurationClockBehavior behavior = null;
        behavior = useRef ? new GenericDurationClockBehavior(mode, startCE, endCE, refCE, displayedOverlap) : new GenericDurationClockBehavior(mode, startCE, endCE, displayedOverlap);
        return behavior;
    }

    private TimerClockBehavior buildTimerClockBehavior(Timer duration) {
        int delay = duration.getDelay();
        ConcreteEntity ref = duration.getRef();
        ConcreteEntity start = duration.getStart();
        ClockEntity startCE = this.findClockEntity(start);
        ClockEntity refCE = this.findClockEntity(ref);
        if (startCE == null || refCE == null) {
            return null;
        }
        TimerClockBehavior behavior = new TimerClockBehavior(startCE, refCE, delay);
        return behavior;
    }

    public void addClockToClockBehavior(GenericDurationClockBehavior behavior, String fragmentURI) {
        GenericDurationPersistentOptions options = new GenericDurationPersistentOptions(this._durationModelFilename, fragmentURI);
        this.addDurationBehavior(behavior, behavior.getStartClock(), options);
        this.addDurationBehavior(behavior, behavior.getEndClock(), options);
        if (behavior.getRefClock() != null) {
            this.addDurationBehavior(behavior, behavior.getRefClock(), options);
        }
    }

    public void addTimerBehavior(TimerClockBehavior behavior, String URIfragment) {
        TimerPersistentOptions options = new TimerPersistentOptions(this._durationModelFilename, URIfragment);
        this.addDurationBehavior(behavior, behavior.getStartClock(), options);
        this.addDurationBehavior(behavior, behavior.getRefClock(), options);
    }

    private void addDurationBehavior(DurationClockBehavior behavior, ClockEntity clockEntity, DurationPersistentOptions options) {
        this.addDurationBehavior(behavior);
        if (this._helper != null) {
            this._helper.addBehavior(clockEntity, this._helper.getAlwaysState(), this.getPluginName(), (ClockBehavior)behavior, (PersistentOptions)options);
        }
    }

    private void removeDurationBehavior(DurationClockBehavior behavior) {
        if (this._helper == null) {
            return;
        }
        if (behavior instanceof GenericDurationClockBehavior) {
            this._helper.removeBehavior(((GenericDurationClockBehavior)behavior).getStartClock(), this._helper.getAlwaysState(), (ClockBehavior)behavior);
            this._helper.removeBehavior(((GenericDurationClockBehavior)behavior).getEndClock(), this._helper.getAlwaysState(), (ClockBehavior)behavior);
            if (((GenericDurationClockBehavior)behavior).getRefClock() != null) {
                this._helper.removeBehavior(((GenericDurationClockBehavior)behavior).getRefClock(), this._helper.getAlwaysState(), (ClockBehavior)behavior);
            }
        } else if (behavior instanceof TimerClockBehavior) {
            this._helper.removeBehavior(((TimerClockBehavior)behavior).getStartClock(), this._helper.getAlwaysState(), (ClockBehavior)behavior);
            this._helper.removeBehavior(((TimerClockBehavior)behavior).getRefClock(), this._helper.getAlwaysState(), (ClockBehavior)behavior);
        }
    }

    private void addDurationBehavior(DurationClockBehavior behavior) {
        if (!this._behaviorList.contains(behavior)) {
            this._behaviorList.add(behavior);
        }
    }

    public void manageBehavior(ConfigurationHelper helper) {
    }

    public ClockBehavior redoClockBehavior(ConfigurationHelper helper, PersistentOptions persistentOptions) {
        if (persistentOptions instanceof VCDGeneratorPersistentOptions) {
            VCDGeneratorClockBehavior behavior = ((VCDGeneratorPersistentOptions)persistentOptions).buildClockBehavior();
            ClockEntity clockEntity = VCDGeneratorManager.getClock(helper, behavior);
            if (clockEntity == null) {
                return null;
            }
            behavior.setClock(clockEntity);
            this.addVCDGeneratorBehavior(behavior);
            return behavior;
        }
        if (persistentOptions instanceof GenericDurationPersistentOptions) {
            if (this._durationModelRoot == null) {
                return null;
            }
            String modelFilename = ((GenericDurationPersistentOptions)persistentOptions).getDurationModelFilename();
            String fragment = ((GenericDurationPersistentOptions)persistentOptions).getID();
            String key = String.valueOf(modelFilename) + fragment;
            if (modelFilename == null || modelFilename.isEmpty() || this._durationModelFilename == null || modelFilename.compareTo(this._durationModelFilename) != 0) {
                return null;
            }
            DurationClockBehavior cbehavior = this.getDurationBehaviorFromCache(key);
            if (cbehavior != null) {
                return cbehavior;
            }
            EObject dObject = this._resource.getEObject(fragment);
            if (dObject == null || !(dObject instanceof GenericDuration)) {
                return null;
            }
            GenericDuration duration = (GenericDuration)dObject;
            GenericDurationClockBehavior behavior = this.buildClockToClockBehaviour(duration);
            if (behavior == null) {
                return null;
            }
            this.addDurationBehavior(behavior);
            this.storeDurationBehaviorInCache(key, (DurationClockBehavior)behavior);
            return behavior;
        }
        if (persistentOptions instanceof TimerPersistentOptions) {
            if (this._durationModelRoot == null) {
                return null;
            }
            String modelFilename = ((TimerPersistentOptions)persistentOptions).getDurationModelFilename();
            String fragment = ((TimerPersistentOptions)persistentOptions).getID();
            String key = String.valueOf(modelFilename) + fragment;
            if (modelFilename == null || modelFilename.isEmpty() || this._durationModelFilename == null || modelFilename.compareTo(this._durationModelFilename) != 0) {
                return null;
            }
            DurationClockBehavior cbehavior = this.getDurationBehaviorFromCache(key);
            if (cbehavior != null) {
                return cbehavior;
            }
            EObject dObject = this._resource.getEObject(fragment);
            if (dObject == null || !(dObject instanceof Timer)) {
                return null;
            }
            Timer duration = (Timer)dObject;
            TimerClockBehavior behavior = this.buildTimerClockBehavior(duration);
            if (behavior == null) {
                return null;
            }
            this.addDurationBehavior(behavior);
            this.storeDurationBehaviorInCache(key, (DurationClockBehavior)behavior);
            return behavior;
        }
        return null;
    }

    public RelationBehavior redoRelationBehavior(ConfigurationHelper helper, PersistentOptions persistentOptions) {
        return null;
    }

    public ClockBehavior redoAssertBehavior(ConfigurationHelper helper, PersistentOptions persistentOptions) {
        return null;
    }

    public PersistentOptions getPluginOptions() {
        PlugInPersistentOptions options = new PlugInPersistentOptions(this._durationModelFilename, this._launchVCDViewer);
        return options;
    }

    private void loadDurationModel() {
        if (this._durationModelFilename == null || this._durationModelFilename.isEmpty()) {
            this._durationModelRoot = null;
            return;
        }
        if (this._resource == null) {
            this._resourceSet = new ResourceSetImpl();
            this._resource = this._resourceSet.createResource(URI.createPlatformResourceURI((String)this._durationModelFilename, (boolean)true));
        }
        try {
            this._resource.load(Collections.EMPTY_MAP);
            EcoreUtil.resolveAll((Resource)this._resource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this._resource.getErrors().isEmpty()) {
            this._durationModelRoot = (DurationModel)this._resource.getContents().get(0);
        }
    }

    public void receivePluginOptions(ConfigurationHelper helper, PersistentOptions persistentOptions) throws Throwable {
        if (!(persistentOptions instanceof PlugInPersistentOptions)) {
            return;
        }
        PlugInPersistentOptions options = (PlugInPersistentOptions)persistentOptions;
        String modelFilename = options.get_pathToDurationModel();
        if (modelFilename != null && !modelFilename.isEmpty()) {
            this.set_durationModelFilename(modelFilename);
            this.loadDurationModel();
        }
        this._launchVCDViewer = options.is_launchVCDViewer();
    }

    private static ClockEntity getClock(ConfigurationHelper helper, VCDGeneratorClockBehavior behavior) {
        for (ClockEntity clock : helper.getClocks()) {
            if (clock.getName().compareTo(behavior.getName()) != 0) continue;
            return clock;
        }
        return null;
    }

    public void clear() {
        this._behaviorList.clear();
        this.deleteDurationModel();
        this.durationBehaviorsCache.clear();
    }

    private void deleteDurationModel() {
        if (this._resourceSet != null) {
            for (Resource resource : this._resourceSet.getResources()) {
                resource.unload();
            }
        }
        this._resource = null;
        this._resourceSet = null;
        this._durationModelRoot = null;
        this.set_durationModelFilename(null);
    }

    public void deleteEntity(Entity entity, DeleteHelper deletehelper) {
        if (entity.getPersistentOptions() instanceof DurationPersistentOptions) {
            for (ClockBehaviorEntity cbe : deletehelper.getClockBehaviorEntity()) {
                if (cbe.getBehavior() != entity.getBehavior()) continue;
                deletehelper.deleteEntity(cbe);
            }
        }
        this._behaviorList.remove(entity.getBehavior());
    }

    public void beforeExecution(ConfigurationHelper helper, IPath folderin, String namefilein, ISolverForBackend solver) {
        this.setOutputFile(folderin, namefilein);
        this._myColorAPI = VcdColorPreferences.createColor();
        this._scoreBoard = ScoreBoard.getScoreboard(this._outputFileName, this._myColorAPI);
        this.fileHeader();
        int i = 0;
        for (AbstractVCDClockBehavior behavior : this._behaviorList) {
            if (behavior instanceof VCDGeneratorClockBehavior) {
                ((VCDGeneratorClockBehavior)behavior).setClock(VCDGeneratorManager.getClock(helper, (VCDGeneratorClockBehavior)behavior));
                ((VCDGeneratorClockBehavior)behavior).setPulses(this._pulses);
                ((VCDGeneratorClockBehavior)behavior).setGhosts(this._ghosts);
            }
            behavior.setScoreBoard(this._scoreBoard);
            if (behavior.getPCode() == null) {
                behavior.setPCode("!" + ++i);
            }
            if (behavior.isInitialized()) continue;
            behavior.initialize();
        }
        for (PhysicalBase lpb : helper.getPhysicalBases()) {
            EObject eo;
            String s;
            Reference r = lpb.getRelatedDenseClock();
            if (!(r instanceof ModelElementReference) || (s = AdapterRegistry.getAdapter((EObject)(eo = (EObject)((ModelElementReference)r).getElementRef().get(0))).getUID(eo)) == null || !s.equals(this.discretize)) continue;
            this.pb = lpb;
            try {
                TimeBase tb;
                this.physical = tb = (TimeBase)AdapterRegistry.getAdapter((EObject)eo).getDiscretyzeByValue(eo).get(0);
            }
            catch (Exception e) {
                this.physical = new TimeBase(1.0);
            }
        }
        this.scaleCommand = this.pb == null ? new ScaleCommand(0.1) : new ScaleCommand(this.physical.getBase(), this.physical.getUnitname());
        this._scoreBoard.getVcdModel().addDefinition((IDeclarationCommand)this.scaleCommand);
        this.createFileCreationThread();
        this.createRelationConstraint(namefilein);
    }

    public void end(ConfigurationHelper helper) {
        ++this._currentStep;
        int instant = this._currentStep * 10;
        SimulationCommand sc = this._scoreBoard.tick(instant);
        for (AbstractVCDClockBehavior behavior : this._behaviorList) {
            behavior.end();
        }
        StepManager sm = new StepManager();
        sm.simCommand = sc;
        sm.fixed = false;
        if (this.hmism != null) {
            this.hmism.put(this._currentStep, sm);
        }
        this.lsstep.add(sm);
        if (this.pb != null) {
            this.updateDate(this.pb);
        }
        this.createEndThread();
        this._resourceSet = null;
        this._myColorAPI = null;
        this._scoreBoard = null;
        for (AbstractVCDClockBehavior b : this._behaviorList) {
            b.setScoreBoard(null);
        }
        this._behaviorList.clear();
        this._behaviorList = null;
        this.hmism.clear();
        this.lsstep.clear();
        this.hmism = null;
        this.lsstep = null;
        this._vcdEditor = null;
    }

    public void aNewStep(int step) {
        SimulationCommand sc;
        if (this._scoreBoard == null) {
            return;
        }
        int date = step;
        this._currentStep = step;
        int instant = step * 10;
        StepManager sm = new StepManager();
        sm.simCommand = sc = this._scoreBoard.tick(instant);
        sm.fixed = this.pb == null ? false : HelperFactory.isFixed((PhysicalBase)this.pb, (LogicalStep)this.getCurrentStep());
        this.hmism.put(date, sm);
        this.lsstep.add(sm);
    }

    public void aPostNewStep(int step) {
        this.createVCDUpdateThread();
    }

    private void setOutputFile(IPath path, String name) {
        this._outputFilePath = path;
        this._outputFileName = name;
    }

    private void fileHeader() {
        this._scoreBoard.getVcdModel().addDefinition((IDeclarationCommand)new DateCommand(new Date().toString()));
        this._scoreBoard.getVcdModel().addDefinition((IDeclarationCommand)new VersionCommand(PLUGIN_NAME, VERSION_NAME));
        this.tc = new TimeScaleCommand();
        this.tc.set(1, TimeUnit.tick);
        this._scoreBoard.getVcdModel().addDefinition((IDeclarationCommand)this.tc);
    }

    private void createRelationConstraint(String namefilein) {
        ICommentCommand icc = this._scoreBoard.getVcdModel().createComment("relation");
        if (icc == null) {
            ErrorConsole.printlnError((String)"Warning : Relation Model for Vcd requires : \"fr.inria.aoste.timesquare.vcd.instantrelation\" ");
            return;
        }
        icc.setString(1, String.valueOf(namefilein) + ".ccslrelationmodel");
        for (EObject relation : this._helper.getRelationConstraint()) {
            icc.newData((Object)relation);
        }
        ConstraintView.getCurrentConstraintView().constraintViewRefresh();
    }

    private void createFileCreationThread() {
        try {
            FileCreationThread thread = new FileCreationThread();
            Display.getDefault().syncExec((Runnable)thread);
            thread.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createVCDUpdateThread() {
        if (this._scoreBoard != null) {
            try {
                UpdateThread thread = new UpdateThread();
                Display.getDefault().syncExec((Runnable)thread);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void createEndThread() {
        try {
            EndThread thread = new EndThread();
            Display.getDefault().syncExec((Runnable)thread);
            thread.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        if (this._scoreBoard != null) {
            ScoreBoard.removeScoreboard(this._scoreBoard);
        }
        super.finalize();
    }

    public int updateDate(PhysicalBase pb) {
        try {
            int intervalLenght;
            this.scaleCommand.setBase(this.physical.getBase() / 100.0);
            Boolean firstSimulationFixed = this.lsstep.get((int)0).fixed;
            int intervalLenghtRef = intervalLenght = HelperFactory.getMaxInterval((PhysicalBase)pb) + 1;
            if (intervalLenght % 10 != 0) {
                intervalLenght = intervalLenght / 10 + 10;
            }
            int scaleUnit = 0;
            scaleUnit = intervalLenghtRef < 6 ? intervalLenght / 5 : intervalLenght / 10;
            int currentSimulationTime = -1;
            int currentIntervalUnit = 0;
            for (StepManager sm : this.lsstep) {
                if (sm == null) continue;
                if (firstSimulationFixed.booleanValue()) {
                    if (currentSimulationTime == -1) {
                        ++currentSimulationTime;
                        sm.simCommand.setTime(0);
                        continue;
                    }
                    if (sm.fixed) {
                        currentSimulationTime = currentIntervalUnit += intervalLenght;
                        sm.simCommand.setTime(currentSimulationTime * 10);
                        continue;
                    }
                    sm.simCommand.setTime((currentSimulationTime += scaleUnit) * 10);
                    continue;
                }
                if (currentSimulationTime == -1) {
                    ++currentSimulationTime;
                    sm.simCommand.setTime(0);
                    continue;
                }
                if (sm.fixed) {
                    currentSimulationTime = currentIntervalUnit += intervalLenght;
                    sm.simCommand.setTime(currentSimulationTime * 10);
                    continue;
                }
                sm.simCommand.setTime((currentSimulationTime += scaleUnit) * 10);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return 0;
    }

    public VCDBehaviorConfigurator getConfigurator(ConfigurationHelper configurationHelper) {
        return new VCDBehaviorConfigurator(configurationHelper, this);
    }

    public boolean is_launchVCDViewer() {
        return this._launchVCDViewer;
    }

    public void set_launchVCDViewer(boolean _launchVCDViewer) {
        this._launchVCDViewer = _launchVCDViewer;
    }

    private class EndThread
    extends Thread {
        protected EndThread() {
            super("End VCD Thread");
        }

        @Override
        public void run() {
            try {
                if (VCDGeneratorManager.this._vcdEditor != null) {
                    VCDGeneratorManager.this._vcdEditor.setSimulationProgress(6);
                    VCDGeneratorManager.this._vcdEditor.syncModel2Text();
                    VCDGeneratorManager.this._vcdEditor.setFocus();
                    int currentSize = VCDGeneratorManager.this._scoreBoard.getSize();
                    VCDGeneratorManager.this._vcdEditor.update2(VCDGeneratorManager.this.previousSize, currentSize, true);
                    if (VCDGeneratorManager.this._vcdEditor.getTraceCollector() != null) {
                        VCDGeneratorManager.this._vcdEditor.getTraceCollector().setPartial(false);
                    }
                    VCDGeneratorManager.this._vcdEditor.setSimulation(false);
                    VCDGeneratorManager.this._vcdEditor.doSave(null);
                    VCDGeneratorManager.this._vcdEditor.vcdMultiPageEditorRefresh();
                }
                ScoreBoard.removeScoreboard(VCDGeneratorManager.this._scoreBoard);
                VCDGeneratorManager.this._scoreBoard = null;
                VCDGeneratorManager.this._myColorAPI = null;
                if (VCDGeneratorManager.this._vcdEditor != null) {
                    VCDGeneratorManager.this._vcdEditor.setActiveVCDPage();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            VCDGeneratorManager.this._scoreBoard = null;
            VCDGeneratorManager.this._myColorAPI = null;
        }
    }

    private class FileCreationThread
    extends Thread {
        protected FileCreationThread() {
            super("File Creation Thread");
        }

        @Override
        public void run() {
            IFile file = PluginHelpers.touchFile((IPath)VCDGeneratorManager.this._outputFilePath, (String)(String.valueOf(VCDGeneratorManager.this._outputFileName) + ".vcd"));
            VCDGeneratorManager.this._vcdEditor = VcdMultiPageEditor.createNewVcdMultiPageEditor((VCDDefinitions)VCDGeneratorManager.this._scoreBoard.getVcdModel(), (IFile)file, (VcdColorPreferences)VCDGeneratorManager.this._myColorAPI);
            if (VCDGeneratorManager.this._vcdEditor != null) {
                VCDGeneratorManager.this._vcdEditor.setSimulation(true);
                VCDGeneratorManager.this._vcdEditor.getTraceCollector().setPartial(true);
                VCDGeneratorManager.this._vcdEditor.setGhostMode(Mode.bool2Mode((boolean)VCDGeneratorManager.this._ghosts));
                VCDGeneratorManager.this._vcdEditor.setSimulationProgress(2);
            }
        }
    }

    private static class StepManager {
        SimulationCommand simCommand;
        boolean fixed;

        private StepManager() {
        }
    }

    private class UpdateThread
    extends Thread {
        protected UpdateThread() {
            super("Update VCD Thread");
        }

        @Override
        public void run() {
            if (VCDGeneratorManager.this._scoreBoard != null) {
                int currentSize = VCDGeneratorManager.this._scoreBoard.getSize();
                try {
                    if (VCDGeneratorManager.this._vcdEditor != null) {
                        VCDGeneratorManager.this._vcdEditor.update2(VCDGeneratorManager.this.previousSize, currentSize, false);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                VCDGeneratorManager.this.previousSize = currentSize;
            }
        }
    }
}

