/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.ui.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public abstract class SideBySideImageDecorator
extends LabelProvider
implements ILabelDecorator {
    protected final int gap;

    public SideBySideImageDecorator(int gap) {
        this.gap = gap;
    }

    public Image composeImages(Image image, Object image2) {
        if (image == null) {
            return ExtendedImageRegistry.INSTANCE.getImage(image2);
        }
        ArrayList<Object> images = new ArrayList<Object>(2);
        images.add(image2);
        images.add(image);
        SideBySideImages composedImage = new SideBySideImages(this.gap, images);
        return ExtendedImageRegistry.INSTANCE.getImage((Object)composedImage);
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    protected static class SideBySideImages
    extends ComposedImage {
        protected final int gap;

        protected SideBySideImages(int gap, Collection<?> images) {
            super(images);
            this.gap = gap;
        }

        public boolean equals(Object that) {
            return that instanceof SideBySideImages && ((SideBySideImages)((Object)that)).gap == this.gap && ((SideBySideImages)((Object)that)).getImages().equals(this.images);
        }

        public int hashCode() {
            return super.hashCode() + this.gap + ((Object)((Object)this)).getClass().hashCode();
        }

        public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
            ComposedImage.Size size0 = (ComposedImage.Size)this.imageSizes.get(0);
            ComposedImage.Size size1 = (ComposedImage.Size)this.imageSizes.get(1);
            int height = Math.max(size0.height, size1.height);
            ArrayList<ComposedImage.Point> result = new ArrayList<ComposedImage.Point>();
            ComposedImage.Point overlay0 = new ComposedImage.Point();
            overlay0.y = Math.min(height - size0.height, height / 2);
            result.add(overlay0);
            ComposedImage.Point overlay1 = new ComposedImage.Point();
            overlay1.x = size0.width + this.gap;
            overlay1.y = Math.min(height - size1.height, height / 2);
            result.add(overlay1);
            return result;
        }

        public ComposedImage.Size getSize(Collection<? extends ComposedImage.Size> imageSizes) {
            this.imageSizes = new ArrayList<ComposedImage.Size>(imageSizes);
            ComposedImage.Size size0 = (ComposedImage.Size)this.imageSizes.get(0);
            ComposedImage.Size size1 = (ComposedImage.Size)this.imageSizes.get(1);
            ComposedImage.Size result = new ComposedImage.Size();
            result.width = size0.width + this.gap + size1.width;
            result.height = Math.max(size0.height, size1.height);
            return result;
        }
    }
}

