/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.util;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.util.ClassFormatException;
import org.aspectj.org.eclipse.jdt.core.util.IConstantPool;
import org.aspectj.org.eclipse.jdt.core.util.IConstantPoolEntry;
import org.aspectj.org.eclipse.jdt.core.util.IConstantPoolEntry3;
import org.aspectj.org.eclipse.jdt.core.util.IPackageVisibilityInfo;
import org.aspectj.org.eclipse.jdt.internal.core.util.ClassFileStruct;

public class PackageVisibilityInfo
extends ClassFileStruct
implements IPackageVisibilityInfo {
    private int index;
    private char[] packageName;
    private int flags;
    private int targetsCount;
    private int[] targetModuleIndices;
    private char[][] targetModuleNames;

    public PackageVisibilityInfo(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        int readOffset = 0;
        this.index = this.u2At(classFileBytes, readOffset, offset);
        readOffset += 2;
        IConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.index);
        if (constantPoolEntry.getKind() != 20) {
            throw new ClassFormatException(3);
        }
        char[] tmp = ((IConstantPoolEntry3)constantPoolEntry).getPackageName();
        this.packageName = tmp != null ? tmp : CharOperation.NO_CHAR;
        this.flags = this.u2At(classFileBytes, readOffset, offset);
        this.targetsCount = this.u2At(classFileBytes, readOffset += 2, offset);
        readOffset += 2;
        if (this.targetsCount != 0) {
            this.targetModuleIndices = new int[this.targetsCount];
            this.targetModuleNames = new char[this.targetsCount][];
            int i = 0;
            while (i < this.targetsCount) {
                this.targetModuleIndices[i] = this.u2At(classFileBytes, readOffset, offset);
                readOffset += 2;
                constantPoolEntry = constantPool.decodeEntry(this.targetModuleIndices[i]);
                if (constantPoolEntry.getKind() != 19) {
                    throw new ClassFormatException(3);
                }
                tmp = ((IConstantPoolEntry3)constantPoolEntry).getModuleName();
                this.targetModuleNames[i] = tmp != null ? tmp : CharOperation.NO_CHAR;
                ++i;
            }
        } else {
            this.targetModuleIndices = new int[0];
            this.targetModuleNames = CharOperation.NO_CHAR_CHAR;
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public char[] getPackageName() {
        return this.packageName;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public int getTargetsCount() {
        return this.targetsCount;
    }

    @Override
    public int[] getTargetModuleIndices() {
        return this.targetModuleIndices;
    }

    @Override
    public char[][] getTargetModuleNames() {
        return this.targetModuleNames;
    }
}

