/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search.indexing;

import org.aspectj.org.eclipse.jdt.core.compiler.InvalidInputException;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.core.runtime.IPath;

public abstract class BinaryContainer
extends IndexRequest {
    Scanner scanner;

    public BinaryContainer(IPath containerPath, IndexManager manager) {
        super(containerPath, manager);
    }

    private boolean isIdentifier() throws InvalidInputException {
        switch (this.scanner.scanIdentifier()) {
            case 2: 
            case 76: 
            case 79: {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isValidPackageNameForClassOrisModule(String className) {
        if (className.substring(0, className.length() - SuffixConstants.SUFFIX_CLASS.length).equals(new String(IIndexConstants.MODULE_INFO))) {
            return true;
        }
        char[] classNameArray = className.toCharArray();
        if (this.scanner == null) {
            this.scanner = new Scanner(false, true, false, 0x330000L, null, null, true);
        }
        this.scanner.setSource(classNameArray);
        this.scanner.eofPosition = classNameArray.length - SuffixConstants.SUFFIX_CLASS.length;
        try {
            if (!this.isIdentifier()) return false;
            do {
                if (this.scanner.eofPosition <= this.scanner.currentPosition) {
                    return true;
                }
                if (this.scanner.getNextChar() == 47 && this.scanner.eofPosition > this.scanner.currentPosition) continue;
                return false;
            } while (this.isIdentifier());
            return false;
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return false;
    }
}

