/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import java.io.File;
import java.io.IOException;
import org.aspectj.org.eclipse.jdt.core.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IJavaProject;
import org.aspectj.org.eclipse.jdt.core.IModularClassFile;
import org.aspectj.org.eclipse.jdt.core.IPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class BasicCompilationUnit
implements org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit {
    protected char[] contents;
    protected char[] fileName;
    protected char[][] packageName;
    protected char[] mainTypeName;
    protected char[] moduleName;
    protected String encoding;

    private BasicCompilationUnit(char[] contents, char[][] packageName, String fileName) {
        this.contents = contents;
        this.fileName = fileName.toCharArray();
        this.packageName = packageName;
    }

    @Deprecated
    public BasicCompilationUnit(char[] contents, char[][] packageName, String fileName, String encoding) {
        this(contents, packageName, fileName);
        this.encoding = encoding;
    }

    public BasicCompilationUnit(char[] contents, char[][] packageName, String fileName, IJavaElement javaElement) {
        this(contents, packageName, fileName);
        this.initAttributes(javaElement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initAttributes(IJavaElement javaElement) {
        if (javaElement == null) {
            this.encoding = null;
            return;
        }
        try {
            IJavaElement module = null;
            block8: while (javaElement != null) {
                switch (javaElement.getElementType()) {
                    case 2: {
                        module = ((IJavaProject)javaElement).getModuleDescription();
                        break block8;
                    }
                    case 3: {
                        module = ((IPackageFragmentRoot)javaElement).getModuleDescription();
                        break block8;
                    }
                    case 6: {
                        if (!(javaElement instanceof IModularClassFile)) break;
                        module = ((IModularClassFile)javaElement).getModule();
                        break block8;
                    }
                    case 5: {
                        IFile file = (IFile)javaElement.getResource();
                        if (file != null) {
                            this.encoding = file.getCharset();
                        }
                        if ((module = ((ICompilationUnit)javaElement).getModule()) != null) break block8;
                    }
                }
                javaElement = javaElement.getParent();
            }
            if (module != null) {
                this.moduleName = module.getElementName().toCharArray();
            }
            if (this.encoding != null) return;
            IProject project = javaElement.getJavaProject().getProject();
            if (project == null) return;
            this.encoding = project.getDefaultCharset();
            return;
        }
        catch (CoreException e1) {
            this.encoding = null;
            return;
        }
    }

    @Override
    public char[] getContents() {
        if (this.contents != null) {
            return this.contents;
        }
        try {
            return Util.getFileCharContent(new File(new String(this.fileName)), this.encoding);
        }
        catch (IOException iOException) {
            return CharOperation.NO_CHAR;
        }
    }

    @Override
    public char[] getFileName() {
        return this.fileName;
    }

    @Override
    public char[] getMainTypeName() {
        if (this.mainTypeName == null) {
            int end;
            int separator;
            int start = CharOperation.lastIndexOf('/', this.fileName) + 1;
            if (start == 0 || start < CharOperation.lastIndexOf('\\', this.fileName)) {
                start = CharOperation.lastIndexOf('\\', this.fileName) + 1;
            }
            if ((separator = CharOperation.lastIndexOf('|', this.fileName) + 1) > start) {
                start = separator;
            }
            if (!((end = CharOperation.lastIndexOf('$', this.fileName)) != -1 && Util.isClassFileName(this.fileName) || (end = CharOperation.lastIndexOf('.', this.fileName)) != -1)) {
                end = this.fileName.length;
            }
            this.mainTypeName = CharOperation.subarray(this.fileName, start, end);
        }
        return this.mainTypeName;
    }

    @Override
    public char[][] getPackageName() {
        return this.packageName;
    }

    @Override
    public boolean ignoreOptionalProblems() {
        return false;
    }

    public String toString() {
        return "CompilationUnit: " + new String(this.fileName);
    }

    @Override
    public char[] getModuleName() {
        return this.moduleName;
    }
}

