/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.sirius;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.diffmerge.generic.api.config.IConfigurablePolicy;
import org.eclipse.emf.diffmerge.generic.api.scopes.ITreeDataScope;
import org.eclipse.emf.diffmerge.gmf.GMFMatchPolicy;
import org.eclipse.emf.diffmerge.impl.policies.ConfigurableMatchPolicy;
import org.eclipse.emf.diffmerge.sirius.SiriusScope;
import org.eclipse.emf.diffmerge.structures.common.comparable.ComparableTreeMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.AnnotationEntry;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.style.StylePackage;

public class SiriusMatchPolicy
extends GMFMatchPolicy {
    protected static final String SEMANTIC_ID_SOURCE_PROPERTY = "SEMANTIC_ID_SOURCE_PROPERTY";
    protected static final String SEMANTIC_ID_TARGET_PROPERTY = "SEMANTIC_ID_TARGET_PROPERTY";
    protected static final String SEMANTIC_ID_INDEX_PROPERTY = "SEMANTIC_ID_INDEX_PROPERTY";
    protected static final Collection<String> NON_SEMANTIC_SIRIUS_VIEWTYPES = Arrays.asList("Description", "DiagramName");
    protected static final Collection<? extends EPackage> SIRIUS_DESCRIPTION_PACKAGES = Arrays.asList(org.eclipse.sirius.viewpoint.description.DescriptionPackage.eINSTANCE, StylePackage.eINSTANCE, org.eclipse.sirius.diagram.description.style.StylePackage.eINSTANCE, DescriptionPackage.eINSTANCE);

    public SiriusMatchPolicy() {
    }

    public SiriusMatchPolicy(SiriusMatchPolicy policy_p) {
        this();
        this.update((IConfigurablePolicy)policy_p);
    }

    public SiriusMatchPolicy clone() throws CloneNotSupportedException {
        return new SiriusMatchPolicy(this);
    }

    protected String getAnnotationEntrySemanticID(AnnotationEntry element_p, ITreeDataScope<EObject> scope_p) {
        String result = null;
        if (element_p.getSource() != null) {
            result = this.getContainerRelativeID((EObject)element_p, scope_p, element_p.getSource(), null);
        }
        return result;
    }

    public List<ConfigurableMatchPolicy.FineGrainedMatchCriterion> getAvailableFineGrainedCriteria() {
        List result = super.getAvailableFineGrainedCriteria();
        result.add(0, CRITERION_SEMANTICS_DEFAULTCONTENTS);
        return result;
    }

    protected String getDAnnotationSemanticID(DAnnotation annotation_p, ITreeDataScope<EObject> scope_p) {
        String result = null;
        if (annotation_p.getSource() != null) {
            result = this.getContainerRelativeID((EObject)annotation_p, scope_p, annotation_p.getSource(), null);
        }
        return result;
    }

    protected String getDViewSemanticID(DView element_p, ITreeDataScope<EObject> scope_p) {
        String result = null;
        if (this.useFineGrainedCriterion(CRITERION_SEMANTICS_DEFAULTCONTENTS)) {
            String vpName;
            Viewpoint vp = element_p.getViewpoint();
            String string = vpName = vp == null ? null : vp.getName();
            if (vpName != null) {
                result = this.getContainerRelativeID((EObject)element_p, scope_p, vpName, null);
            }
        }
        return result;
    }

    protected String getName(EObject element_p, ITreeDataScope<EObject> scope_p) {
        AnnotationEntry annotation;
        String result = null;
        if (element_p instanceof DView) {
            Viewpoint viewpoint = ((DView)element_p).getViewpoint();
            if (viewpoint != null) {
                result = viewpoint.getName();
            }
        } else if (element_p instanceof DRepresentationDescriptor) {
            result = ((DRepresentationDescriptor)element_p).getName();
        } else if (element_p instanceof DRepresentation && scope_p instanceof SiriusScope) {
            SiriusScope scope = (SiriusScope)scope_p;
            DRepresentationDescriptor descriptor = scope.getRepresentationDescriptor((DRepresentation)element_p);
            if (descriptor != null) {
                result = descriptor.getName();
            }
        } else if (element_p instanceof AnnotationEntry && (annotation = (AnnotationEntry)element_p).getSource() != null) {
            result = "ANNOTATION_" + annotation.getSource();
        }
        if (result == null) {
            result = super.getName(element_p, scope_p);
        }
        return result;
    }

    protected int getNoteAttachmentIndex(Connector noteAttachment_p, EObject container_p, ITreeDataScope<EObject> scope_p) {
        int noteIndex = -1;
        String type = noteAttachment_p.getType();
        for (EObject child : this.getContents(container_p, scope_p)) {
            Connector connector;
            if (!(child instanceof Connector) || (connector = (Connector)child).getType() != type || connector.getSource() != noteAttachment_p.getSource() || connector.getTarget() != noteAttachment_p.getTarget()) continue;
            ++noteIndex;
            if (child == noteAttachment_p) break;
        }
        return noteIndex;
    }

    protected String getNoteAttachmentSemanticID(Connector noteAttachment_p, ITreeDataScope<EObject> scope_p) {
        int noteIndex;
        String containerID;
        ComparableTreeMap map = new ComparableTreeMap();
        EObject container = this.getContainer((EObject)noteAttachment_p, scope_p);
        if (container != null && (containerID = this.getMatchID(container, scope_p)) != null && (noteIndex = this.getNoteAttachmentIndex(noteAttachment_p, container, scope_p)) != -1) {
            map.put(SEMANTIC_ID_INDEX_PROPERTY, Integer.toString(noteIndex));
        }
        if (noteAttachment_p.getSource() != null) {
            map.put(SEMANTIC_ID_SOURCE_PROPERTY, this.getSemanticID((EObject)noteAttachment_p.getSource(), scope_p));
        }
        if (noteAttachment_p.getTarget() != null) {
            map.put(SEMANTIC_ID_TARGET_PROPERTY, this.getSemanticID((EObject)noteAttachment_p.getTarget(), scope_p));
        }
        return map.toString();
    }

    protected String getNoteElementSemanticID(Node noteElement_p, ITreeDataScope<EObject> scope_p) {
        String result = null;
        String viewType = noteElement_p.getType();
        if (viewType != null) {
            result = this.getContainerRelativeID((EObject)noteElement_p, scope_p, viewType, null);
        }
        return result;
    }

    protected int getNoteIndex(View note_p, EObject container_p, ITreeDataScope<EObject> scope_p) {
        int noteIndex = -1;
        String type = note_p.getType();
        for (EObject child : this.getContents(container_p, scope_p)) {
            if (!(child instanceof View) || !type.equals(((View)child).getType())) continue;
            ++noteIndex;
            if (child == note_p) break;
        }
        return noteIndex;
    }

    protected String getNoteSemanticID(Node note_p, ITreeDataScope<EObject> scope_p) {
        int noteIndex;
        String containerID;
        String result = null;
        EObject container = this.getContainer((EObject)note_p, scope_p);
        if (container != null && (containerID = this.getMatchID(container, scope_p)) != null && (noteIndex = this.getNoteIndex((View)note_p, container, scope_p)) != -1) {
            ComparableTreeMap map = new ComparableTreeMap();
            map.put("SEMANTIC_ID_CONTAINER", containerID);
            map.put("SEMANTIC_TYPE", note_p.getType());
            map.put(SEMANTIC_ID_INDEX_PROPERTY, Integer.toString(noteIndex));
            result = map.toString();
        }
        return result;
    }

    protected String getSemanticID(EObject element_p, ITreeDataScope<EObject> scope_p) {
        String result = null;
        if (element_p instanceof DView) {
            result = this.getDViewSemanticID((DView)element_p, scope_p);
        } else if (element_p instanceof AnnotationEntry) {
            result = this.getAnnotationEntrySemanticID((AnnotationEntry)element_p, scope_p);
        } else if (element_p instanceof DAnnotation) {
            result = this.getDAnnotationSemanticID((DAnnotation)element_p, scope_p);
        } else if (this.isViewpointElement(element_p)) {
            result = this.getViewpointElementSemanticID(element_p, scope_p);
        } else if (this.useFineGrainedCriterion(CRITERION_SEMANTICS_DIAGRAMS_VIEWBYTYPE)) {
            if (element_p instanceof Node && this.isNote((Node)element_p)) {
                result = this.getNoteSemanticID((Node)element_p, scope_p);
            } else if (element_p instanceof Connector && this.isNoteAttachment((Connector)element_p)) {
                result = this.getNoteAttachmentSemanticID((Connector)element_p, scope_p);
            } else if (element_p instanceof Node && this.isNoteElement((Node)element_p)) {
                result = this.getNoteElementSemanticID((Node)element_p, scope_p);
            }
        }
        if (result == null) {
            result = super.getSemanticID(element_p, scope_p);
        }
        return result;
    }

    protected int getSiblingIndex(EObject element_p, ITreeDataScope<EObject> scope_p) {
        List elements = this.getSiblings(element_p, scope_p);
        return elements.indexOf(element_p);
    }

    protected String getViewpointElementSemanticID(EObject element_p, ITreeDataScope<EObject> scope_p) {
        int noteIndex;
        String containerID;
        String result = null;
        EObject container = this.getContainer(element_p, scope_p);
        if (container != null && (containerID = this.getMatchID(container, scope_p)) != null && (noteIndex = this.getSiblingIndex(element_p, scope_p)) != -1) {
            ComparableTreeMap map = new ComparableTreeMap();
            map.put("SEMANTIC_ID_CONTAINER", containerID);
            map.put("SEMANTIC_CONTAINING_FEATURE", element_p.eContainingFeature().getName());
            map.put(SEMANTIC_ID_INDEX_PROPERTY, Integer.toString(noteIndex));
            result = map.toString();
        }
        return result;
    }

    protected boolean hasNoSemantics(View view_p) {
        return NON_SEMANTIC_VIEWTYPES.contains(view_p.getType()) || NON_SEMANTIC_SIRIUS_VIEWTYPES.contains(view_p.getType());
    }

    protected boolean isDiscriminatingContainment(EObject element_p, EReference containment_p) {
        return super.isDiscriminatingContainment(element_p, containment_p) || containment_p == DiagramPackage.eINSTANCE.getDDiagramElement_GraphicalFilters();
    }

    protected boolean isNoteElement(Node node_p) {
        return NON_SEMANTIC_SIRIUS_VIEWTYPES.contains(node_p.getType());
    }

    protected boolean isViewpointElement(EObject element_p) {
        boolean result = false;
        EClass clazz = element_p.eClass();
        if (clazz != null) {
            EPackage pkg = clazz.getEPackage();
            result = SIRIUS_DESCRIPTION_PACKAGES.contains(pkg);
        }
        return result;
    }
}

