/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.common.graph;

import fr.kairos.timesquare.ccsl.graph.IGraph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class MyGraph
implements IGraph {
    private Set<Integer>[] edges;
    private String[] nodeNames;
    private HashMap<String, Integer> namesToIndex = new HashMap();
    private int nodeNumber = 0;

    public MyGraph(int countNodes) {
        if (countNodes < 0) {
            throw new IllegalArgumentException("Le nombre de noeud doit \u00eatre positif");
        }
        this.edges = new Set[countNodes];
        this.nodeNames = new String[countNodes];
    }

    @Override
    public void addNode(String name) {
        if (this.namesToIndex.containsKey(name)) {
            System.err.println("Already has a node with that name ");
            return;
        }
        this.node(name);
    }

    private int node(String name) {
        if (this.namesToIndex.containsKey(name)) {
            return this.namesToIndex.get(name);
        }
        if (this.nodeNumber == this.nodeNames.length) {
            throw new RuntimeException("cannot have more than " + this.nodeNames.length + " nodes");
        }
        this.nodeNames[this.nodeNumber] = name;
        this.namesToIndex.put(name, this.nodeNumber);
        this.edges[this.nodeNumber] = new HashSet<Integer>();
        ++this.nodeNumber;
        return this.nodeNumber - 1;
    }

    @Override
    public void addEdge(String tail, String head, Object ... param) {
        int tailNum = this.node(tail);
        int headNum = this.node(head);
        this.edges[tailNum].add(headNum);
    }

    public Iterable<Integer> neighbours(int node) {
        return this.edges[node];
    }

    public int getNodeNumber() {
        return this.nodeNumber;
    }

    public int nameToIndex(String name) {
        return this.namesToIndex.get(name);
    }
}

