/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.fsm.editor;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.etrice.core.fsm.fSM.FSMFactory;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.RefinedState;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.etrice.core.fsm.validation.FSMValidationUtil;
import org.eclipse.etrice.ui.behavior.fsm.editor.AbstractFSMDiagramBehavior;
import org.eclipse.etrice.ui.behavior.fsm.editor.DiagnosingModelObserver;
import org.eclipse.etrice.ui.behavior.fsm.support.ContextSwitcher;
import org.eclipse.etrice.ui.behavior.fsm.support.util.FSMSupportUtil;
import org.eclipse.etrice.ui.common.base.editor.DiagramEditorBase;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractFSMEditor
extends DiagramEditorBase {
    protected DiagnosingModelObserver diagnosingModelObserver;

    public AbstractFSMEditor(Object textEditorClass) {
        super(textEditorClass);
    }

    public DiagnosingModelObserver getDiagnosingModelObserver() {
        return this.diagnosingModelObserver;
    }

    public void attachDiagnosingModelObserver() {
        DiagnosingModelObserver dmObserver = this.getDiagnosingModelObserver();
        if (dmObserver != null) {
            dmObserver.removeObserver();
            dmObserver.observeModel(this.getModel());
        }
    }

    public void detachDiagnosingModelObserver() {
        DiagnosingModelObserver dmObserver = this.getDiagnosingModelObserver();
        if (dmObserver != null) {
            dmObserver.removeObserver();
        }
    }

    public void initializeGraphicalViewer() {
        this.diagnosingModelObserver = new DiagnosingModelObserver();
        this.diagnosingModelObserver.observeModel(this.getModel());
        super.initializeGraphicalViewer();
        RecordingCommand cmd = new RecordingCommand(this.getEditingDomain()){

            protected void doExecute() {
                ContextSwitcher.switchTop(AbstractFSMEditor.this.getDiagramTypeProvider().getDiagram());
            }
        };
        this.getEditingDomain().getCommandStack().execute((Command)cmd);
        this.getEditingDomain().getCommandStack().flush();
    }

    public boolean showStateGraph(StateGraph sg) {
        URI boUri = EcoreUtil.getURI((EObject)sg);
        final StateGraph mySG = (StateGraph)this.getEditingDomain().getResourceSet().getEObject(boUri, true);
        if (mySG == null) {
            return false;
        }
        RecordingCommand cmd = new RecordingCommand(this.getEditingDomain()){

            protected void doExecute() {
                ContextSwitcher.switchTo(AbstractFSMEditor.this.getDiagramTypeProvider().getDiagram(), mySG);
            }
        };
        this.getEditingDomain().getCommandStack().execute((Command)cmd);
        this.getEditingDomain().getCommandStack().flush();
        return true;
    }

    public void dispose() {
        if (this.diagnosingModelObserver != null) {
            this.diagnosingModelObserver.removeObserver();
        }
        super.dispose();
    }

    protected DiagramBehavior createDiagramBehavior() {
        return new AbstractFSMDiagramBehavior(this);
    }

    public void doSave(IProgressMonitor monitor) {
        FSMValidationUtil fsmValidationUtil = FSMSupportUtil.getInstance().getFSMValidationUtil();
        Diagram diagram = this.getDiagramTypeProvider().getDiagram();
        ModelComponent mc = FSMSupportUtil.getInstance().getModelComponent(diagram);
        if (mc.getStateMachine() != null) {
            for (State s : mc.getStateMachine().getStates()) {
                if (!(s instanceof RefinedState) || !fsmValidationUtil.isRefinedStateEmpty((RefinedState)s)) continue;
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Check of Refined State", (String)"A Refined State with empty action codes must have a non-empty sub state graph.");
                return;
            }
        }
        this.getEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.getEditingDomain()){

            protected void doExecute() {
                AbstractFSMEditor.this.cleanupBeforeSave();
            }
        });
        super.doSave(monitor);
    }

    protected void cleanupBeforeSave() {
        this.removeEmptySubgraphs();
        this.rebaseRefinedStates();
        this.removeUnusedRefinedStates();
    }

    protected void removeUnusedRefinedStates() {
        Diagram diagram = this.getDiagramTypeProvider().getDiagram();
        ModelComponent mc = FSMSupportUtil.getInstance().getModelComponent(diagram);
        if (mc.getStateMachine() != null) {
            ArrayList<RefinedState> toBeRemoved = new ArrayList<RefinedState>();
            for (State s : mc.getStateMachine().getStates()) {
                if (!(s instanceof RefinedState) || !this.isUnused((RefinedState)s)) continue;
                toBeRemoved.add((RefinedState)s);
            }
            mc.getStateMachine().getStates().removeAll(toBeRemoved);
        }
    }

    private boolean isUnused(RefinedState s) {
        FSMHelpers fsmHelpers = FSMSupportUtil.getInstance().getFSMHelpers();
        if (fsmHelpers.hasDirectSubStructure((State)s)) {
            return false;
        }
        if (fsmHelpers.hasDetailCode(s.getEntryCode())) {
            return false;
        }
        return !fsmHelpers.hasDetailCode(s.getExitCode());
    }

    protected void removeEmptySubgraphs() {
        State s;
        Diagram diagram = this.getDiagramTypeProvider().getDiagram();
        FSMHelpers fsmHelpers = FSMSupportUtil.getInstance().getFSMHelpers();
        StateGraph current = ContextSwitcher.getCurrentStateGraph(diagram);
        if (current != null && current.eContainer() instanceof State && !fsmHelpers.hasDirectSubStructure(s = (State)current.eContainer())) {
            ContextSwitcher.goUp(diagram, current);
        }
        ArrayList<Shape> toBeRemoved = new ArrayList<Shape>();
        for (Shape ctxShape : diagram.getChildren()) {
            State s2;
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)ctxShape);
            if (bo.eIsProxy()) {
                toBeRemoved.add(ctxShape);
                continue;
            }
            assert (bo instanceof StateGraph) : "expected state graph";
            StateGraph sg = (StateGraph)bo;
            if (!(sg.eContainer() instanceof State) || fsmHelpers.hasDirectSubStructure(s2 = (State)sg.eContainer())) continue;
            EcoreUtil.delete((EObject)sg);
            toBeRemoved.add(ctxShape);
        }
        for (Shape shape : toBeRemoved) {
            EcoreUtil.delete((EObject)shape, (boolean)true);
        }
    }

    protected void rebaseRefinedStates() {
        ModelComponent mc = this.getModelComponent();
        if (mc.getStateMachine() == null) {
            return;
        }
        Function nameProvider = FSMSupportUtil.getInstance().getFSMNameProvider().getRefinedStateNameProvider();
        Map rs2parent = FSMSupportUtil.getInstance().getFSMHelpers().getRefinedStatesToRelocate(mc, nameProvider);
        for (RefinedState rs : rs2parent.keySet()) {
            RefinedState parent = (RefinedState)rs2parent.get(rs);
            if (parent.getSubgraph() == null) {
                parent.setSubgraph(FSMFactory.eINSTANCE.createStateGraph());
            }
            parent.getSubgraph().getStates().add((Object)rs);
        }
    }

    protected void superClassChanged() {
        IDiagramTypeProvider diagramTypeProvider = this.getDiagramTypeProvider();
        Diagram diagram = diagramTypeProvider.getDiagram();
        IFeatureProvider featureProvider = diagramTypeProvider.getFeatureProvider();
        UpdateContext updateCtx = new UpdateContext((PictogramElement)diagram);
        featureProvider.updateIfPossible((IUpdateContext)updateCtx);
        diagramTypeProvider.getDiagramBehavior().refresh();
    }
}

