/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base.io;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.naming.QualifiedName;

public interface IModelPath {
    public static final IModelPath EMPTY = new EmptyModelPath();

    public Stream<ModelFile> getFiles(QualifiedName var1);

    public Stream<ModelFile> getAllFiles();

    public Optional<QualifiedName> getQualifiedName(URI var1);

    public boolean isEmpty();

    public static class EmptyModelPath
    implements IModelPath {
        @Override
        public Stream<ModelFile> getFiles(QualifiedName name) {
            return Stream.empty();
        }

        @Override
        public Stream<ModelFile> getAllFiles() {
            return Stream.empty();
        }

        @Override
        public Optional<QualifiedName> getQualifiedName(URI uri) {
            return Optional.empty();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }

    public static final class ModelFile {
        public final URI uri;
        public final QualifiedName name;
        public final String extension;

        public ModelFile(URI uri, QualifiedName name, String extension) {
            this.uri = uri;
            this.name = name;
            this.extension = extension;
        }
    }
}

