/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.expressions.detailcode;

import java.util.LinkedList;
import java.util.Objects;
import org.eclipse.etrice.expressions.detailcode.IDetailExpressionProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@FinalFieldsConstructor
public class DetailExpressionAssistParser {
    private final IDocument document;
    private final int invocationOffset;
    private final IDetailExpressionProvider provider;
    private final IWordDetector anyIdScanner = new IWordDetector(){

        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }

        public boolean isWordStart(char c) {
            return Character.isJavaIdentifierStart(c);
        }
    };

    public String computeIdentifierPrefix(int offset) throws BadLocationException {
        int start = offset - 1;
        while (start >= 0 && this.anyIdScanner.isWordPart(this.document.getChar(start))) {
            --start;
        }
        return this.document.get(++start, offset - start);
    }

    public IDetailExpressionProvider.ExpressionFeature computeExpressionFeature(int offset) throws BadLocationException {
        String idResult;
        IDetailExpressionProvider.ExpressionPostfix postfixResult;
        block16: {
            boolean bl;
            char closingChar;
            char openingChar;
            block19: {
                block17: {
                    postfixResult = null;
                    openingChar = '\u0000';
                    closingChar = '\u0000';
                    String string = Character.valueOf(this.document.getChar(offset - 1)).toString();
                    if (string == null) break block17;
                    switch (string) {
                        case ")": {
                            postfixResult = IDetailExpressionProvider.ExpressionPostfix.PARENTHESES;
                            openingChar = '(';
                            closingChar = ')';
                            break;
                        }
                        case "]": {
                            postfixResult = IDetailExpressionProvider.ExpressionPostfix.BRACKETS;
                            openingChar = '[';
                            closingChar = ']';
                            break;
                        }
                        default: {
                            postfixResult = IDetailExpressionProvider.ExpressionPostfix.NONE;
                            break;
                        }
                    }
                    break block19;
                }
                postfixResult = IDetailExpressionProvider.ExpressionPostfix.NONE;
            }
            int start = offset;
            boolean bl2 = bl = !com.google.common.base.Objects.equal((Object)((Object)postfixResult), (Object)((Object)IDetailExpressionProvider.ExpressionPostfix.NONE));
            if (bl) {
                --start;
                int counter = 1;
                while (start > 0 && counter > 0) {
                    char c = this.document.getChar(--start);
                    boolean bl3 = false;
                    if (Objects.equals(Character.valueOf(c), Character.valueOf(openingChar))) {
                        bl3 = true;
                        --counter;
                    }
                    if (bl3 || !Objects.equals(Character.valueOf(c), Character.valueOf(closingChar))) continue;
                    bl3 = true;
                    ++counter;
                }
                if (counter > 0) {
                    postfixResult = null;
                }
            }
            idResult = null;
            try {
                idResult = this.computeIdentifierPrefix(start);
            }
            catch (Throwable throwable) {
                if (throwable instanceof BadLocationException) break block16;
                throw Exceptions.sneakyThrow((Throwable)throwable);
            }
        }
        return new IDetailExpressionProvider.ExpressionFeature(idResult, postfixResult);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public IDetailExpressionProvider.ExpressionFeature resolveLatestCompleted() {
        LinkedList parsedFeatures;
        block9: {
            int n;
            int lastSeparatorPos;
            block8: {
                lastSeparatorPos = this.invocationOffset - 1;
                try {
                    String invocationPrefix = this.computeIdentifierPrefix(this.invocationOffset);
                    int n2 = lastSeparatorPos;
                    n = invocationPrefix.length();
                    lastSeparatorPos = n2 - n;
                }
                catch (Throwable invocationPrefix) {
                    if (invocationPrefix instanceof BadLocationException) break block8;
                    throw Exceptions.sneakyThrow((Throwable)invocationPrefix);
                }
            }
            parsedFeatures = CollectionLiterals.newLinkedList();
            try {
                while (this.document.getChar(lastSeparatorPos) == '.') {
                    boolean bl;
                    IDetailExpressionProvider.ExpressionFeature parseResult = this.computeExpressionFeature(lastSeparatorPos);
                    n = this.isValid(parseResult) ? 1 : 0;
                    boolean bl2 = bl = n == 0;
                    if (bl) {
                        return null;
                    }
                    parsedFeatures.push(parseResult);
                    int n3 = lastSeparatorPos;
                    int n4 = parseResult.getId().length();
                    int n5 = n4 + 1;
                    lastSeparatorPos = n3 - n5;
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof BadLocationException) break block9;
                throw Exceptions.sneakyThrow((Throwable)throwable);
            }
        }
        boolean bl = parsedFeatures.isEmpty();
        if (bl) {
            return null;
        }
        IDetailExpressionProvider.ExpressionFeature firstParseResult = (IDetailExpressionProvider.ExpressionFeature)parsedFeatures.pop();
        Functions.Function1 function1 = it -> this.matches((IDetailExpressionProvider.ExpressionFeature)it, firstParseResult);
        IDetailExpressionProvider.ExpressionFeature lastMatch = (IDetailExpressionProvider.ExpressionFeature)IterableExtensions.findFirst(this.provider.getInitialFeatures(), (Functions.Function1)function1);
        while (lastMatch != null && !parsedFeatures.isEmpty()) {
            IDetailExpressionProvider.ExpressionFeature nextParseResult = (IDetailExpressionProvider.ExpressionFeature)parsedFeatures.pop();
            Functions.Function1 function12 = it -> this.matches((IDetailExpressionProvider.ExpressionFeature)it, nextParseResult);
            lastMatch = (IDetailExpressionProvider.ExpressionFeature)IterableExtensions.findFirst(this.provider.getContextFeatures(lastMatch), (Functions.Function1)function12);
        }
        return lastMatch;
    }

    public boolean isContextExpression() {
        boolean bl = false;
        try {
            bl = this.document.getChar(this.invocationOffset - 1) == '.' || this.anyIdScanner.isWordPart(this.document.getChar(this.invocationOffset - 1));
        }
        catch (Throwable throwable) {
            if (throwable instanceof BadLocationException) {
                bl = false;
            }
            throw Exceptions.sneakyThrow((Throwable)throwable);
        }
        return bl;
    }

    public boolean isInitialExpression() {
        boolean bl = false;
        try {
            bl = this.document.getChar(this.invocationOffset - 1) != '.' && !com.google.common.base.Objects.equal((Object)this.document.get(this.invocationOffset - 2, 2), (Object)"->");
        }
        catch (Throwable throwable) {
            if (throwable instanceof BadLocationException) {
                bl = true;
            }
            throw Exceptions.sneakyThrow((Throwable)throwable);
        }
        return bl;
    }

    private boolean isValid(IDetailExpressionProvider.ExpressionFeature feature) {
        return !Strings.isEmpty((String)feature.getId()) && feature.getPostfix() != null;
    }

    private boolean matches(IDetailExpressionProvider.ExpressionFeature f1, IDetailExpressionProvider.ExpressionFeature f2) {
        return com.google.common.base.Objects.equal((Object)f1.getId(), (Object)f2.getId()) && com.google.common.base.Objects.equal((Object)((Object)f1.getPostfix()), (Object)((Object)f2.getPostfix()));
    }

    public DetailExpressionAssistParser(IDocument document, int invocationOffset, IDetailExpressionProvider provider) {
        this.document = document;
        this.invocationOffset = invocationOffset;
        this.provider = provider;
    }
}

