/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.util.test;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.junit.internal.AbstractSatTestCase;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.sat.junit.util.ValueHolder;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class LogUtilityTestCase
extends AbstractSatTestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.util.test.LogUtilityTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public LogUtilityTestCase(String name) {
        super(name);
    }

    private LogService createLogService(final ValueHolder holder) {
        return new LogService(){

            public void log(int level, String message) {
                this.logged();
            }

            public void log(int level, String message, Throwable exception) {
                this.logged();
            }

            public void log(ServiceReference sr, int level, String message) {
                this.logged();
            }

            public void log(ServiceReference sr, int level, String message, Throwable exception) {
                this.logged();
            }

            private void logged() {
                holder.setTrue();
            }
        };
    }

    public void test_getLog() {
        LogUtility utility = LogUtility.getInstance();
        LogService logService = utility.getLog();
        Assert.assertNotNull((Object)logService);
    }

    public void test_setLog() {
        LogUtility utility = LogUtility.getInstance();
        LogService currentLogService = utility.getLog();
        utility.setLog(null);
        LogService log = utility.getLog();
        Assert.assertNotNull((Object)log);
        utility.setLog(currentLogService);
        LogService expected = currentLogService;
        LogService actual = utility.getLog();
        Assert.assertSame((Object)expected, (Object)actual);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_setLoggingLevel() {
        int currentLoggingLevel = LogUtility.getLoggingLevel();
        try {
            LogUtility utility = LogUtility.getInstance();
            ValueHolder holder = ValueHolder.falseValue();
            LogService logService = this.createLogService(holder);
            utility.setLog(logService);
            Assert.assertTrue((boolean)holder.isFalse());
            String message = "message";
            try {
                LogUtility.setLoggingLevel((int)-1);
                Assert.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Assert.assertTrue((boolean)true);
            }
            LogUtility.setLoggingLevel((int)0);
            int expectedLevel = 0;
            int actualLevel = LogUtility.getLoggingLevel();
            Assert.assertEquals((int)expectedLevel, (int)actualLevel);
            LogUtility.logError((String)message);
            boolean state = holder.isFalse();
            Assert.assertTrue((boolean)state);
            LogUtility.logWarning((String)message);
            state = holder.isFalse();
            Assert.assertTrue((boolean)state);
            LogUtility.logInfo((String)message);
            state = holder.isFalse();
            Assert.assertTrue((boolean)state);
            LogUtility.logDebug((String)message);
            state = holder.isFalse();
            Assert.assertTrue((boolean)state);
            LogUtility.setLoggingLevel((int)1);
            expectedLevel = 1;
            actualLevel = LogUtility.getLoggingLevel();
            Assert.assertEquals((int)expectedLevel, (int)actualLevel);
            boolean isLogging = LogUtility.isLoggingError();
            Assert.assertTrue((boolean)isLogging);
            holder.setFalse();
            LogUtility.logDebug((String)message);
            state = holder.isFalse();
            Assert.assertTrue((boolean)state);
            LogUtility.logInfo((String)message);
            state = holder.isFalse();
            Assert.assertTrue((boolean)state);
            LogUtility.logWarning((String)message);
            state = holder.isFalse();
            Assert.assertTrue((boolean)state);
            LogUtility.logError((String)message);
            state = holder.isTrue();
            Assert.assertTrue((boolean)state);
            LogUtility.setLoggingLevel((int)2);
            expectedLevel = 2;
            actualLevel = LogUtility.getLoggingLevel();
            Assert.assertEquals((int)expectedLevel, (int)actualLevel);
            isLogging = LogUtility.isLoggingWarning();
            Assert.assertTrue((boolean)isLogging);
            holder.setFalse();
            LogUtility.logDebug((String)message);
            state = holder.isFalse();
            Assert.assertTrue((boolean)state);
            LogUtility.logInfo((String)message);
            state = holder.isFalse();
            Assert.assertTrue((boolean)state);
            LogUtility.logWarning((String)message);
            state = holder.isTrue();
            Assert.assertTrue((boolean)state);
            holder.setFalse();
            LogUtility.logError((String)message);
            state = holder.isTrue();
            Assert.assertTrue((boolean)state);
            LogUtility.setLoggingLevel((int)3);
            expectedLevel = 3;
            actualLevel = LogUtility.getLoggingLevel();
            Assert.assertEquals((int)expectedLevel, (int)actualLevel);
            isLogging = LogUtility.isLoggingInfo();
            Assert.assertTrue((boolean)isLogging);
            holder.setFalse();
            LogUtility.logDebug((String)message);
            state = holder.isFalse();
            Assert.assertTrue((boolean)state);
            LogUtility.logInfo((String)message);
            state = holder.isTrue();
            Assert.assertTrue((boolean)state);
            holder.setFalse();
            LogUtility.logWarning((String)message);
            state = holder.isTrue();
            Assert.assertTrue((boolean)state);
            holder.setFalse();
            LogUtility.logError((String)message);
            state = holder.isTrue();
            Assert.assertTrue((boolean)state);
            LogUtility.setLoggingLevel((int)4);
            expectedLevel = 4;
            actualLevel = LogUtility.getLoggingLevel();
            Assert.assertEquals((int)expectedLevel, (int)actualLevel);
            isLogging = LogUtility.isLoggingDebug();
            Assert.assertTrue((boolean)isLogging);
            holder.setFalse();
            LogUtility.logDebug((String)message);
            state = holder.isTrue();
            Assert.assertTrue((boolean)state);
            holder.setFalse();
            LogUtility.logInfo((String)message);
            state = holder.isTrue();
            Assert.assertTrue((boolean)state);
            holder.setFalse();
            LogUtility.logWarning((String)message);
            state = holder.isTrue();
            Assert.assertTrue((boolean)state);
            holder.setFalse();
            LogUtility.logError((String)message);
            state = holder.isTrue();
            Assert.assertTrue((boolean)state);
            try {
                LogUtility.setLoggingLevel((int)5);
                Assert.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Assert.assertTrue((boolean)true);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            LogUtility.setLoggingLevel((int)currentLoggingLevel);
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        LogUtility.setLoggingLevel((int)currentLoggingLevel);
    }
}

