/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.spreadsheet;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.spreadsheet.Column;
import com.google.gdata.util.ParseException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExtensionDescription.Default(nsAlias="gs", nsUri="http://schemas.google.com/spreadsheets/2006", localName="data")
public class Data
extends ExtensionPoint {
    static final String XML_NAME = "data";
    private static final String INSERTIONMODE = "insertionMode";
    private static final String NUMROWS = "numRows";
    private static final String STARTROW = "startRow";
    private static final AttributeHelper.EnumToAttributeValue<InsertionMode> INSERTIONMODE_ENUM_TO_ATTRIBUTE_VALUE = new AttributeHelper.LowerCaseEnumToAttributeValue<InsertionMode>();
    private InsertionMode insertionMode = null;
    private Integer numberOfRows = null;
    private Integer startIndex = null;

    public Data() {
    }

    public Data(InsertionMode insertionMode, Integer numberOfRows, Integer startIndex) {
        this.setInsertionMode(insertionMode);
        this.setNumberOfRows(numberOfRows);
        this.setStartIndex(startIndex);
        this.setImmutable(true);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(Data.class)) {
            return;
        }
        extProfile.declare(Data.class, Column.getDefaultDescription(false, true));
    }

    public List<Column> getColumns() {
        return this.getRepeatingExtension(Column.class);
    }

    public void addColumn(Column column) {
        this.getColumns().add(column);
    }

    public boolean hasColumns() {
        return this.hasRepeatingExtension(Column.class);
    }

    public InsertionMode getInsertionMode() {
        return this.insertionMode;
    }

    public void setInsertionMode(InsertionMode insertionMode) {
        this.throwExceptionIfImmutable();
        this.insertionMode = insertionMode;
    }

    public boolean hasInsertionMode() {
        return this.getInsertionMode() != null;
    }

    public Integer getNumberOfRows() {
        return this.numberOfRows;
    }

    public void setNumberOfRows(Integer numberOfRows) {
        this.throwExceptionIfImmutable();
        this.numberOfRows = numberOfRows;
    }

    public boolean hasNumberOfRows() {
        return this.getNumberOfRows() != null;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.throwExceptionIfImmutable();
        this.startIndex = startIndex;
    }

    public boolean hasStartIndex() {
        return this.getStartIndex() != null;
    }

    @Override
    protected void validate() {
        if (this.startIndex == null) {
            Data.throwExceptionForMissingAttribute(STARTROW);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(Data.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    @Override
    protected void putAttributes(AttributeGenerator generator) {
        generator.put(INSERTIONMODE, this.insertionMode, INSERTIONMODE_ENUM_TO_ATTRIBUTE_VALUE);
        generator.put(NUMROWS, this.numberOfRows);
        generator.put(STARTROW, this.startIndex);
    }

    @Override
    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.insertionMode = helper.consumeEnum(INSERTIONMODE, false, InsertionMode.class, null, INSERTIONMODE_ENUM_TO_ATTRIBUTE_VALUE);
        this.numberOfRows = helper.consumeInteger(NUMROWS, false);
        this.startIndex = helper.consumeInteger(STARTROW, true);
    }

    public String toString() {
        return "{Data insertionMode=" + (Object)((Object)this.insertionMode) + " numberOfRows=" + this.numberOfRows + " startIndex=" + this.startIndex + "}";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InsertionMode {
        INSERT,
        OVERWRITE;

    }
}

