/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.introspection;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.Category;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Categories
extends ExtensionPoint {
    private XmlNamespace atomPubNs = Namespaces.getAtomPubNs();
    private Boolean fixed;
    private String defaultScheme;
    private String href;
    private List<Category> categories;

    public Categories() {
    }

    public Categories(boolean fixed, String defaultScheme, Category ... categories) {
        this.fixed = fixed;
        this.defaultScheme = defaultScheme;
        if (categories.length != 0) {
            this.categories = Arrays.asList(categories);
        }
    }

    public Categories(String href) {
        this.href = href;
    }

    public boolean isFixed() {
        return this.fixed != null && this.fixed != false;
    }

    public String getDefaultScheme() {
        return this.defaultScheme;
    }

    public String getHref() {
        return this.href;
    }

    public List<Category> getCategoryList() {
        return this.categories;
    }

    public void addCategory(Category category) {
        if (this.categories == null) {
            this.categories = new ArrayList<Category>();
        }
        this.categories.add(category);
    }

    @Override
    public XmlParser.ElementHandler getHandler(ExtensionProfile p, String namespace, String localName, Attributes attrs) {
        return new Handler(p, attrs);
    }

    @Override
    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.href = helper.consume("href", false);
        this.defaultScheme = helper.consume("scheme", false);
        String fixedValue = helper.consume("fixed", false);
        if (fixedValue != null) {
            if ("yes".equals(fixedValue)) {
                this.fixed = true;
            } else if ("no".equals(fixedValue)) {
                this.fixed = false;
            } else {
                ParseException pe = new ParseException(CoreErrorDomain.ERR.invalidFixedAttribute);
                pe.setInternalReason("Invalid value for fixed attribute:" + fixedValue);
                throw pe;
            }
        }
    }

    @Override
    public void validate() throws IllegalStateException {
        if (this.href != null && (this.fixed != null || this.defaultScheme != null || this.categories != null)) {
            throw new IllegalStateException("The href attribute cannot be used with other attributes or nested category elements");
        }
    }

    public void parseAtom(ExtensionProfile extProfile, XmlParser parser) throws IOException, ParseException {
        Handler handler = new Handler(extProfile, null);
        parser.parse(handler, this.atomPubNs.getUri(), "categories");
    }

    @Override
    public void generate(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>();
        if (this.fixed != null) {
            attrs.add(new XmlWriter.Attribute("fixed", this.fixed != false ? "yes" : "no"));
        }
        if (this.defaultScheme != null) {
            attrs.add(new XmlWriter.Attribute("scheme", this.defaultScheme));
        }
        if (this.href != null) {
            attrs.add(new XmlWriter.Attribute("href", this.href));
        }
        w.startElement(this.atomPubNs, "categories", attrs, null);
        if (this.categories != null) {
            w.startRepeatingElement();
            for (Category category : this.categories) {
                category.generateAtom(w);
            }
            w.endRepeatingElement();
        }
        this.generateExtensions(w, extProfile);
        w.endElement(this.atomPubNs, "categories");
    }

    public class Handler
    extends ExtensionPoint.ExtensionHandler {
        public Handler(ExtensionProfile extProfile, Attributes attrs) {
            super(Categories.this, extProfile, Categories.class, attrs);
        }

        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
            if (namespace.equals("http://www.w3.org/2005/Atom") && localName.equals("category")) {
                Category category = new Category();
                Categories.this.addCategory(category);
                return category.new Category.AtomHandler();
            }
            return super.getChildHandler(namespace, localName, attrs);
        }
    }
}

