/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.aggregate;

import java.util.Objects;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.expr.aggregate.AccumulatorExpr;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.expr.aggregate.AggregatorBase;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.writers.WriterExpr;
import org.apache.jena.sparql.util.ExprUtils;

public class AggGroupConcat
extends AggregatorBase {
    static final String SeparatorDefault = " ";
    private final String separator;
    private final String effectiveSeparator;

    public AggGroupConcat(Expr expr, String separator) {
        this(expr, separator != null ? separator : SeparatorDefault, separator);
    }

    private AggGroupConcat(Expr expr, String effectiveSeparator, String separatorSeen) {
        super("GROUP_CONCAT", false, expr);
        this.separator = separatorSeen;
        this.effectiveSeparator = effectiveSeparator;
    }

    @Override
    public Aggregator copy(ExprList expr) {
        return new AggGroupConcat(expr.get(0), this.effectiveSeparator, this.separator);
    }

    @Override
    public String toPrefixString() {
        return AggGroupConcat.prefixGroupConcatString(this.isDistinct, this.separator, this.getExprList());
    }

    @Override
    public String asSparqlExpr(SerializationContext sCxt) {
        return AggGroupConcat.asSparqlExpr(this.isDistinct, this.separator, this.exprList, sCxt);
    }

    protected static String asSparqlExpr(boolean isDistinct, String separator, ExprList exprs, SerializationContext sCxt) {
        IndentedLineBuffer x = new IndentedLineBuffer();
        x.append("GROUP_CONCAT(", new Object[0]);
        if (isDistinct) {
            x.append("DISTINCT ", new Object[0]);
        }
        ExprUtils.fmtSPARQL((IndentedWriter)x, exprs, sCxt);
        if (separator != null) {
            x.append(" ; separator=", new Object[0]);
            String y = StrUtils.escapeString(separator);
            x.append("'", new Object[0]);
            x.append(y, new Object[0]);
            x.append("'", new Object[0]);
        }
        x.append(")", new Object[0]);
        return x.asString();
    }

    protected static String prefixGroupConcatString(boolean isDistinct, String separator, ExprList exprs) {
        IndentedLineBuffer x = new IndentedLineBuffer();
        x.append("(", new Object[0]);
        x.append("group_concat", new Object[0]);
        if (isDistinct) {
            x.append(" distinct", new Object[0]);
        }
        if (separator != null) {
            String y = StrUtils.escapeString(separator);
            x.append("(separator '", new Object[0]);
            x.append(y, new Object[0]);
            x.append("')", new Object[0]);
        }
        x.incIndent();
        for (Expr e2 : exprs) {
            x.append(SeparatorDefault, new Object[0]);
            WriterExpr.output((IndentedWriter)x, e2, null);
        }
        x.decIndent();
        x.append(")", new Object[0]);
        return x.asString();
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccGroupConcat(this.getExpr(), this.effectiveSeparator);
    }

    public String getSeparator() {
        return this.separator;
    }

    @Override
    public Node getValueEmpty() {
        return NodeConst.emptyString;
    }

    @Override
    public int hashCode() {
        return 0x174 ^ this.exprList.hashCode();
    }

    @Override
    public boolean equals(Aggregator other, boolean bySyntax) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggGroupConcat)) {
            return false;
        }
        AggGroupConcat agg = (AggGroupConcat)other;
        return Objects.equals(agg.getSeparator(), this.getSeparator()) && agg.getExpr().equals(this.getExpr(), bySyntax);
    }

    private static class AccGroupConcat
    extends AccumulatorExpr {
        private StringBuilder stringSoFar = new StringBuilder();
        private boolean first = true;
        private final String separator;

        public AccGroupConcat(Expr expr, String sep) {
            super(expr, false);
            this.separator = sep;
        }

        @Override
        protected void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            String str2 = nv.asString();
            if (!this.first) {
                this.stringSoFar.append(this.separator);
            }
            this.stringSoFar.append(str2);
            this.first = false;
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        @Override
        public NodeValue getAccValue() {
            return NodeValue.makeString(this.stringSoFar.toString());
        }
    }
}

