/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.main.solver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.Abortable;
import org.apache.jena.sparql.engine.iterator.QueryIterAbortable;
import org.apache.jena.sparql.engine.main.solver.SolverLib;
import org.apache.jena.sparql.engine.main.solver.SolverRX3;
import org.apache.jena.sparql.engine.main.solver.SolverRX4;

public class PatternMatchData {
    public static QueryIterator execute(Graph graph, BasicPattern pattern, QueryIterator input, Predicate<Triple> filter, ExecutionContext execCxt) {
        List<Triple> triples = pattern.getList();
        Iterator<Binding> chain = input;
        ArrayList<Abortable> killList = new ArrayList<Abortable>();
        for (Triple triple : triples) {
            chain = SolverRX3.rdfStarTriple(chain, triple, execCxt);
            chain = SolverLib.makeAbortable(chain, killList);
        }
        return new QueryIterAbortable(chain, killList, input, execCxt);
    }

    public static QueryIterator execute(DatasetGraph dsg, Node graphNode, BasicPattern pattern, QueryIterator input, Predicate<Quad> filter, ExecutionContext execCxt) {
        if (Quad.isUnionGraph(graphNode)) {
            graphNode = Node.ANY;
        }
        if (Quad.isDefaultGraph(graphNode)) {
            graphNode = null;
        }
        List<Triple> triples = pattern.getList();
        boolean isDefaultGraph = graphNode == null;
        boolean anyGraph = isDefaultGraph ? false : Node.ANY.equals(graphNode);
        Iterator<Binding> chain = input;
        ArrayList<Abortable> killList = new ArrayList<Abortable>();
        for (Triple triple : triples) {
            chain = SolverRX4.rdfStarQuad(chain, graphNode, triple, execCxt);
            chain = SolverLib.makeAbortable(chain, killList);
        }
        return new QueryIterAbortable(chain, killList, input, execCxt);
    }
}

