/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.common.observer;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.emfstore.common.ESObserver;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPointException;
import org.eclipse.emf.emfstore.internal.common.observer.ESPrioritizedObserver;
import org.eclipse.emf.emfstore.internal.common.observer.ObserverCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObserverBus {
    private static final String EXTENSION_POINT_ID = "org.eclipse.emf.emfstore.common.observerBusExtensionPointRegistration";
    private final transient Map<Class<? extends ESObserver>, List<ESObserver>> observerMap = new LinkedHashMap<Class<? extends ESObserver>, List<ESObserver>>();

    public ObserverBus() {
        this.collectionExtensionPoints();
    }

    public <T extends ESObserver> T notify(Class<T> clazz) {
        return this.notify(clazz, false);
    }

    public <T extends ESObserver> T notify(Class<T> clazz, boolean prioritized) {
        if (clazz == null) {
            return null;
        }
        return this.createProxy(clazz, false);
    }

    public void register(ESObserver observer) {
        this.register(observer, this.getObserverInterfaces(observer));
    }

    public void register(ESObserver observer, Class<? extends ESObserver> ... classes) {
        Class<? extends ESObserver>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends ESObserver> iface = classArray[n2];
            if (iface.isInstance(observer)) {
                this.addObserver(observer, iface);
            }
            ++n2;
        }
    }

    public void unregister(ESObserver observer) {
        this.unregister(observer, this.getObserverInterfaces(observer));
    }

    public void unregister(ESObserver observer, Class<? extends ESObserver> ... classes) {
        Class<? extends ESObserver>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends ESObserver> iface = classArray[n2];
            if (iface.isInstance(observer)) {
                this.removeObserver(observer, iface);
            }
            ++n2;
        }
    }

    private void addObserver(ESObserver observer, Class<? extends ESObserver> iface) {
        List<ESObserver> observers = this.initObserverList(iface);
        observers.add(observer);
    }

    private void removeObserver(ESObserver observer, Class<? extends ESObserver> iface) {
        List<ESObserver> observers = this.initObserverList(iface);
        observers.remove(observer);
    }

    private List<ESObserver> initObserverList(Class<? extends ESObserver> iface) {
        List<ESObserver> list = this.observerMap.get(iface);
        if (list == null) {
            list = new ArrayList<ESObserver>();
            this.observerMap.put(iface, list);
        }
        return list;
    }

    private List<ESObserver> getObserverByClass(Class<? extends ESObserver> clazz) {
        List<ESObserver> list = this.observerMap.get(clazz);
        if (list == null) {
            list = Collections.emptyList();
        }
        return new ArrayList<ESObserver>(list);
    }

    private boolean isPrioritizedObserver(Class<?> clazz, Method method) {
        if (!clazz.equals(method.getDeclaringClass())) {
            return false;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaceClass = classArray[n2];
            if (ESPrioritizedObserver.class.equals(interfaceClass)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private <T extends ESObserver> T createProxy(Class<T> clazz, boolean prioritized) {
        ProxyHandler handler = new ProxyHandler(clazz, prioritized);
        return (T)((ESObserver)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, ObserverCall.class}, (InvocationHandler)handler));
    }

    private void sortObservers(List<ESObserver> observers) {
        Collections.sort(observers, new Comparator<ESObserver>(){

            @Override
            public int compare(ESObserver observer1, ESObserver observer2) {
                int prio2;
                int prio1 = ((ESPrioritizedObserver)observer1).getPriority();
                if (prio1 == (prio2 = ((ESPrioritizedObserver)observer2).getPriority())) {
                    return 0;
                }
                return prio1 > prio2 ? 1 : -1;
            }
        });
    }

    private Class<? extends ESObserver>[] getObserverInterfaces(ESObserver observer) {
        LinkedHashSet<Class<? extends ESObserver>> observerIFacesFound = new LinkedHashSet<Class<? extends ESObserver>>();
        this.getClasses(observer.getClass(), observerIFacesFound);
        return observerIFacesFound.toArray(new Class[observerIFacesFound.size()]);
    }

    private boolean getClasses(Class<?> clazz, Set<Class<? extends ESObserver>> result) {
        for (Class<?> iface : this.getAllInterfaces(clazz, new LinkedHashSet())) {
            if (iface.equals(ESObserver.class) && clazz.isInterface()) {
                result.add(clazz);
                return true;
            }
            if (!this.getClasses(iface, result) || !clazz.isInterface()) continue;
            result.add(clazz);
        }
        return false;
    }

    private Set<Class<?>> getAllInterfaces(Class<?> clazz, Set<Class<?>> interfacesFound) {
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            interfacesFound.add(iface);
            ++n2;
        }
        if (clazz.getSuperclass() == null) {
            return interfacesFound;
        }
        return this.getAllInterfaces(clazz.getSuperclass(), interfacesFound);
    }

    public void collectionExtensionPoints() {
        for (ESExtensionElement outer : new ESExtensionPoint(EXTENSION_POINT_ID, true).getExtensionElements()) {
            try {
                for (ESExtensionElement inner : new ESExtensionPoint(outer.getAttribute("extensionPointName"), true).getExtensionElements()) {
                    this.register(inner.getClass(outer.getAttribute("observerAttributeName"), ESObserver.class));
                }
            }
            catch (ESExtensionPointException eSExtensionPointException) {}
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ProxyHandler
    implements InvocationHandler,
    ObserverCall {
        private final Class<ESObserver> clazz;
        private final boolean prioritized;
        private List<ObserverCall.Result> lastResults;

        public ProxyHandler(Class<ESObserver> clazz, boolean prioritized) {
            this.clazz = clazz;
            this.prioritized = prioritized;
            this.lastResults = new ArrayList<ObserverCall.Result>();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
            if (ObserverCall.class.equals(method.getDeclaringClass())) {
                return this.accessObserverCall(method, args);
            }
            List observers = ObserverBus.this.getObserverByClass(this.clazz);
            if (this.prioritized && ObserverBus.this.isPrioritizedObserver(this.clazz, method)) {
                ObserverBus.this.sortObservers(observers);
            }
            if (observers.size() == 0) {
                this.lastResults = new ArrayList<ObserverCall.Result>();
                return ObserverCall.Result.getDefaultValue(method);
            }
            this.lastResults = this.notifiyObservers(observers, method, args);
            return this.lastResults.get(0).getResultOrDefaultValue();
        }

        private Object accessObserverCall(Method method, Object[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return method.invoke((Object)this, args);
        }

        private List<ObserverCall.Result> notifiyObservers(List<ESObserver> observers, Method method, Object[] args) {
            ArrayList<ObserverCall.Result> results = new ArrayList<ObserverCall.Result>(observers.size());
            for (ESObserver observer : observers) {
                try {
                    results.add(new ObserverCall.Result(observer, method, method.invoke((Object)observer, args)));
                }
                catch (Exception exceptin) {
                    results.add(new ObserverCall.Result(observer, method, exceptin));
                }
            }
            return results;
        }

        @Override
        public List<ObserverCall.Result> getObserverCallResults() {
            return this.lastResults;
        }
    }
}

