/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.common.observer;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.emfstore.common.observer.IObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ObserverCall {
    public List<Result> getObserverCallResults();

    public static class Result {
        private final IObserver observer;
        private final Method method;
        private final Object result;
        private final Throwable exception;
        private static final Map<String, Object> DEFAULTPRIMITIVEVALUES = new HashMap<String, Object>();

        static {
            DEFAULTPRIMITIVEVALUES.put("int", new Integer(0));
            DEFAULTPRIMITIVEVALUES.put("boolean", new Boolean(false));
            DEFAULTPRIMITIVEVALUES.put("long", new Long(0L));
            DEFAULTPRIMITIVEVALUES.put("float", new Float(0.0f));
            DEFAULTPRIMITIVEVALUES.put("double", new Double(0.0));
            DEFAULTPRIMITIVEVALUES.put("byte", (byte)-128);
            DEFAULTPRIMITIVEVALUES.put("short", (short)Short.MIN_VALUE);
        }

        public Result(IObserver observer, Method method, Object result) {
            this.observer = observer;
            this.method = method;
            this.result = result;
            this.exception = null;
        }

        public Result(IObserver observer, Throwable e, Method method) {
            this.observer = observer;
            this.exception = e;
            this.method = method;
            this.result = null;
        }

        public boolean exceptionOccurred() {
            return this.exception != null;
        }

        public Throwable getException() {
            return this.exception;
        }

        public IObserver getObserver() {
            return this.observer;
        }

        public Object getResult() {
            return this.result;
        }

        public Object getResultOrDefaultValue() {
            Object result = this.getResult();
            if (result == null) {
                result = Result.getDefaultValue(this.method);
            }
            return result;
        }

        public static Object getDefaultValue(Method m) {
            if (m.getReturnType().isPrimitive()) {
                return DEFAULTPRIMITIVEVALUES.get(m.getReturnType().getSimpleName());
            }
            return null;
        }
    }
}

