/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.controller;

import java.io.File;
import java.io.IOException;
import org.eclipse.emf.emfstore.client.model.importexport.ExportImportControllerExecutor;
import org.eclipse.emf.emfstore.client.model.importexport.IExportImportController;
import org.eclipse.emf.emfstore.client.model.util.EMFStoreCommand;
import org.eclipse.emf.emfstore.client.ui.handlers.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.client.ui.util.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.client.ui.util.EMFStorePreferenceHelper;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class UIGenericExportImportController
extends AbstractEMFStoreUIController {
    public UIGenericExportImportController(Shell shell) {
        super(shell);
    }

    protected void execute(final IExportImportController controller) {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), controller.isExport() ? 8192 : 4096);
        dialog.setFilterNames(controller.getFilteredNames());
        dialog.setFilterExtensions(controller.getFilteredExtensions());
        dialog.setOverwrite(true);
        if (controller.getParentFolderPropertyKey() != null) {
            String initialPath = EMFStorePreferenceHelper.getPreference(controller.getParentFolderPropertyKey(), System.getProperty("user.home"));
            dialog.setFilterPath(initialPath);
        }
        dialog.setFileName(controller.getFilename());
        String fn = dialog.open();
        if (fn == null) {
            return;
        }
        final File file = new File(dialog.getFilterPath(), dialog.getFileName());
        EMFStorePreferenceHelper.setPreference(controller.getParentFolderPropertyKey(), file.getParent());
        final ProgressMonitorDialog progress = this.openProgress();
        new EMFStoreCommand(){

            protected void doRun() {
                try {
                    try {
                        progress.open();
                        progress.getProgressMonitor().beginTask("Import " + controller.getLabel() + " ...", 100);
                        progress.getProgressMonitor().worked(10);
                        new ExportImportControllerExecutor(file, UIGenericExportImportController.this.getProgressMonitor()).execute(controller);
                    }
                    catch (IOException e) {
                        EMFStoreMessageDialog.showExceptionDialog(e);
                        progress.getProgressMonitor().done();
                        progress.close();
                    }
                }
                finally {
                    progress.getProgressMonitor().done();
                    progress.close();
                }
            }
        }.run();
    }
}

