/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.controller;

import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.emfstore.client.model.Configuration;
import org.eclipse.emf.emfstore.client.model.Usersession;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.client.model.observers.LoginObserver;
import org.eclipse.emf.emfstore.client.model.observers.ShareObserver;
import org.eclipse.emf.emfstore.common.observer.IObserver;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.server.model.versioning.VersioningFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShareController
extends ServerCall<Void> {
    public ShareController(ProjectSpaceBase projectSpaceImpl, Usersession session, IProgressMonitor monitor) {
        super(projectSpaceImpl);
        this.setUsersession(session);
        this.setProgressMonitor(monitor);
    }

    @Override
    protected Void run() throws EmfStoreException {
        this.doRun();
        return null;
    }

    private void doRun() throws EmfStoreException {
        this.getProgressMonitor().beginTask("Sharing Project", 100);
        this.getProgressMonitor().worked(1);
        this.getProgressMonitor().subTask("Preparing project for sharing");
        LogMessage logMessage = VersioningFactory.eINSTANCE.createLogMessage();
        logMessage.setAuthor(this.getUsersession().getUsername());
        logMessage.setClientDate(new Date());
        logMessage.setMessage("Initial commit");
        this.getProjectSpace().stopChangeRecording();
        Configuration.setAutoSave(false);
        this.getProgressMonitor().worked(10);
        if (this.getProgressMonitor().isCanceled()) {
            Configuration.setAutoSave(true);
            this.getProjectSpace().getStatePersister().saveDirtyResources(true);
            this.getProjectSpace().startChangeRecording();
            this.getProgressMonitor().done();
        }
        this.getProgressMonitor().subTask("Sharing project with server");
        ProjectInfo createdProject = WorkspaceManager.getInstance().getConnectionManager().createProject(this.getUsersession().getSessionId(), this.getProjectSpace().getProjectName(), this.getProjectSpace().getProjectDescription(), logMessage, this.getProjectSpace().getProject());
        this.getProgressMonitor().worked(70);
        this.getProgressMonitor().subTask("Finalizing share");
        this.setUsersession(this.getUsersession());
        WorkspaceManager.getObserverBus().register((IObserver)this.getProjectSpace(), new Class[]{LoginObserver.class});
        Configuration.setAutoSave(true);
        this.getProjectSpace().getStatePersister().saveDirtyResources(true);
        this.getProjectSpace().startChangeRecording();
        this.getProjectSpace().setBaseVersion(createdProject.getVersion());
        this.getProjectSpace().setLastUpdated(new Date());
        this.getProjectSpace().setProjectId(createdProject.getProjectId());
        this.getProjectSpace().setUsersession(this.getUsersession());
        this.getProjectSpace().saveProjectSpaceOnly();
        this.getProjectSpace().getFileTransferManager().uploadQueuedFiles((IProgressMonitor)new NullProgressMonitor());
        this.getProjectSpace().getOperations().clear();
        this.getProjectSpace().updateDirtyState();
        this.getProgressMonitor().done();
        ((ShareObserver)WorkspaceManager.getObserverBus().notify(ShareObserver.class)).shareDone(this.getProjectSpace());
    }
}

