/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.emfstore.client.model.ModelFactory;
import org.eclipse.emf.emfstore.client.model.ServerInfo;
import org.eclipse.emf.emfstore.client.model.Usersession;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.model.util.ConfigurationProvider;
import org.eclipse.emf.emfstore.client.model.util.DefaultWorkspaceLocationProvider;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionPointException;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.LocationProvider;
import org.eclipse.emf.emfstore.server.model.ClientVersionInfo;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Configuration {
    private static final int XML_RPC_CONNECTION_TIMEOUT = 600000;
    private static final int XML_RPC_REPLY_TIMEOUT = 600000;
    private static final String CLIENT_NAME = "emfstore eclipse client";
    private static final String MODEL_VERSION_FILENAME = "modelReleaseNumber";
    private static final String UPS = ".ups";
    private static final String UOC = ".uoc";
    private static final String PROJECT_FOLDER = "project";
    private static final String PS = "ps-";
    private static final String UPF = ".upf";
    private static final String PLUGIN_BASEDIR = "pluginData";
    private static boolean testing;
    private static LocationProvider locationProvider;
    private static EditingDomain editingDomain;
    private static int xmlRPCConnectionTimeout;
    private static int xmlRPCReplyTimeout;
    private static Boolean resourceSplitting;
    private static boolean autoSave;

    static {
        xmlRPCConnectionTimeout = 600000;
        xmlRPCReplyTimeout = 600000;
    }

    private Configuration() {
    }

    public static String getWorkspaceDirectory() {
        String workspaceDirectory = Configuration.getLocationProvider().getWorkspaceDirectory();
        File workspace = new File(workspaceDirectory);
        if (!workspace.exists()) {
            workspace.mkdirs();
        }
        if (!workspaceDirectory.endsWith(File.separator)) {
            return String.valueOf(workspaceDirectory) + File.separatorChar;
        }
        return workspaceDirectory;
    }

    public static LocationProvider getLocationProvider() {
        if (locationProvider == null) {
            try {
                locationProvider = (LocationProvider)new ExtensionPoint("org.eclipse.emf.emfstore.client.workspaceLocationProvider").setThrowException(true).getClass("providerClass", LocationProvider.class);
            }
            catch (ExtensionPointException e) {
                String message = "Error while instantiating location provider or none configured, switching to default location!";
                ModelUtil.logInfo((String)message);
            }
            if (locationProvider == null) {
                locationProvider = new DefaultWorkspaceLocationProvider();
            }
        }
        return locationProvider;
    }

    public static String getWorkspacePath() {
        return String.valueOf(Configuration.getWorkspaceDirectory()) + "workspace.ucw";
    }

    public static int getXMLRPCConnectionTimeout() {
        return xmlRPCConnectionTimeout;
    }

    public static int getXMLRPCReplyTimeout() {
        return xmlRPCReplyTimeout;
    }

    public static Map<Object, Object> getResourceSaveOptions() {
        return null;
    }

    public static List<ServerInfo> getDefaultServerInfos() {
        List<ServerInfo> defaultServerInfos;
        ConfigurationProvider provider = (ConfigurationProvider)new ExtensionPoint("org.eclipse.emf.emfstore.client.defaultConfigurationProvider").getClass("providerClass", ConfigurationProvider.class);
        if (provider != null && (defaultServerInfos = provider.getDefaultServerInfos()) != null) {
            return defaultServerInfos;
        }
        ArrayList<ServerInfo> result = new ArrayList<ServerInfo>();
        result.add(Configuration.getLocalhostServerInfo());
        return result;
    }

    private static ServerInfo getLocalhostServerInfo() {
        ServerInfo serverInfo = ModelFactory.eINSTANCE.createServerInfo();
        serverInfo.setName("Localhost Server");
        serverInfo.setPort(8080);
        serverInfo.setUrl("localhost");
        serverInfo.setCertificateAlias("emfstore test certificate (do not use in production!)");
        Usersession superUsersession = ModelFactory.eINSTANCE.createUsersession();
        superUsersession.setServerInfo(serverInfo);
        superUsersession.setPassword("super");
        superUsersession.setSavePassword(true);
        superUsersession.setUsername("super");
        serverInfo.setLastUsersession(superUsersession);
        return serverInfo;
    }

    public static int getMaxMECountPerResource() {
        return 1000;
    }

    public static int getMaxResourceFileSizeOnExpand() {
        return 100000;
    }

    public static ClientVersionInfo getClientVersion() {
        ClientVersionInfo clientVersionInfo = org.eclipse.emf.emfstore.server.model.ModelFactory.eINSTANCE.createClientVersionInfo();
        clientVersionInfo.setName(CLIENT_NAME);
        Bundle emfStoreBundle = Platform.getBundle((String)"org.eclipse.emf.emfstore.client");
        String emfStoreVersionString = (String)emfStoreBundle.getHeaders().get("Bundle-Version");
        clientVersionInfo.setVersion(emfStoreVersionString);
        return clientVersionInfo;
    }

    public static boolean isReleaseVersion() {
        return !Configuration.isInternalReleaseVersion() && !Configuration.getClientVersion().getVersion().endsWith("qualifier");
    }

    public static boolean isInternalReleaseVersion() {
        return Configuration.getClientVersion().getVersion().endsWith("internal");
    }

    public static boolean isDeveloperVersion() {
        return !Configuration.isReleaseVersion() && !Configuration.isInternalReleaseVersion();
    }

    public static String getProjectSpaceFileExtension() {
        return UPS;
    }

    public static String getOperationCompositeFileExtension() {
        return UOC;
    }

    public static String getProjectFolderName() {
        return PROJECT_FOLDER;
    }

    public static String getProjectSpaceDirectoryPrefix() {
        return PS;
    }

    public static String getProjectFragmentFileExtension() {
        return UPF;
    }

    public static String getModelReleaseNumberFileName() {
        return String.valueOf(Configuration.getWorkspaceDirectory()) + MODEL_VERSION_FILENAME;
    }

    public static void setTesting(boolean testing) {
        Configuration.testing = testing;
    }

    public static boolean isTesting() {
        return testing;
    }

    public static String getPluginDataBaseDirectory() {
        return String.valueOf(Configuration.getWorkspaceDirectory()) + PLUGIN_BASEDIR + File.separatorChar;
    }

    public static EditingDomain getEditingDomain() {
        if (editingDomain == null) {
            WorkspaceManager.getInstance();
        }
        return editingDomain;
    }

    public static void setEditingDomain(EditingDomain editingDomain) {
        Configuration.editingDomain = editingDomain;
    }

    public static boolean isResourceSplittingEnabled() {
        if (resourceSplitting != null) {
            return resourceSplitting;
        }
        try {
            resourceSplitting = new ExtensionPoint("org.eclipse.emf.emfstore.client.persistence.options").setThrowException(true).getBoolean("enabled");
        }
        catch (ExtensionPointException e) {
            resourceSplitting = false;
        }
        return resourceSplitting;
    }

    public static void setAutoSave(boolean enabled) {
        autoSave = enabled;
    }

    public static boolean isAutoSaveEnabled() {
        return autoSave;
    }
}

