/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.Activator;
import org.eclipse.emf.ecp.common.commands.ECPCommand;
import org.eclipse.emf.ecp.common.model.ECPModelelementContext;
import org.eclipse.emf.ecp.common.util.OverlayImageDescriptor;
import org.eclipse.emf.ecp.editor.MESuggestedSelectionDialog;
import org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.ReferenceAction;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class AddReferenceAction
extends ReferenceAction {
    private static final String DIALOG_MESSAGE = "Enter model element name prefix or pattern (e.g. *Trun?)";
    private final ECPModelelementContext context;

    public AddReferenceAction(EObject modelElement, EReference eReference, IItemPropertyDescriptor descriptor, ECPModelelementContext context) {
        this.modelElement = modelElement;
        this.eReference = eReference;
        this.context = context;
        EObject obj = null;
        if (!eReference.getEReferenceType().isAbstract()) {
            obj = eReference.getEReferenceType().getEPackage().getEFactoryInstance().create(eReference.getEReferenceType());
        }
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        Image image = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory).getImage((Object)obj);
        adapterFactory.dispose();
        String overlayString = "icons/link_overlay.png";
        if (eReference.isContainment()) {
            overlayString = "icons/containment_overlay.png";
        }
        ImageDescriptor addOverlay = Activator.getImageDescriptor((String)overlayString);
        OverlayImageDescriptor imageDescriptor = new OverlayImageDescriptor(image, addOverlay, 2);
        this.setImageDescriptor((ImageDescriptor)imageDescriptor);
        String attribute = descriptor.getDisplayName((Object)eReference);
        if (attribute.endsWith("ies")) {
            attribute = String.valueOf(attribute.substring(0, attribute.length() - 3)) + "y";
        } else if (attribute.endsWith("s")) {
            attribute = attribute.substring(0, attribute.length() - 1);
        }
        this.setToolTipText("Link " + attribute);
    }

    public void run() {
        new AddReferenceCommand(this.modelElement).run(true);
    }

    private final class AddReferenceCommand
    extends ECPCommand {
        public AddReferenceCommand(EObject eObject) {
            super(eObject);
        }

        protected void doRun() {
            MESuggestedSelectionDialog dlg;
            if (!AddReferenceAction.this.checkMultiplicity(false)) {
                return;
            }
            EClass clazz = AddReferenceAction.this.eReference.getEReferenceType();
            Collection allElements = AddReferenceAction.this.context.getAllModelElementsbyClass(clazz, true);
            allElements.remove(AddReferenceAction.this.modelElement);
            Object object = AddReferenceAction.this.modelElement.eGet((EStructuralFeature)AddReferenceAction.this.eReference);
            EList eList = null;
            EObject eObject = null;
            if (AddReferenceAction.this.eReference.isMany() && object instanceof EList) {
                eList = (EList)object;
                for (EObject ref : eList) {
                    allElements.remove(ref);
                }
            } else if (!AddReferenceAction.this.eReference.isMany() && object instanceof EObject) {
                eObject = (EObject)object;
                allElements.remove(eObject);
            }
            if (AddReferenceAction.this.eReference.isContainer()) {
                allElements.removeAll((Collection<?>)AddReferenceAction.this.modelElement.eContents());
            }
            if (AddReferenceAction.this.eReference.isContainment()) {
                Iterator iter = allElements.iterator();
                while (iter.hasNext()) {
                    EObject me = (EObject)iter.next();
                    if (!EcoreUtil.isAncestor((EObject)me, (EObject)AddReferenceAction.this.modelElement)) continue;
                    iter.remove();
                }
            }
            if ((dlg = new MESuggestedSelectionDialog("Select Elements", AddReferenceAction.DIALOG_MESSAGE, true, AddReferenceAction.this.modelElement, AddReferenceAction.this.eReference, allElements)).open() == 0) {
                if (AddReferenceAction.this.eReference.isMany()) {
                    Object[] results = dlg.getResult();
                    ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                    progressDialog.open();
                    progressDialog.getProgressMonitor().beginTask("Adding references...", results.length * 10);
                    ArrayList<EObject> list = new ArrayList<EObject>();
                    Object[] objectArray = results;
                    int n = results.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object result = objectArray[n2];
                        if (result instanceof EObject) {
                            list.add((EObject)result);
                            progressDialog.getProgressMonitor().worked(10);
                        }
                        ++n2;
                    }
                    eList.addAll(list);
                    progressDialog.getProgressMonitor().done();
                    progressDialog.close();
                } else {
                    Object result = dlg.getFirstResult();
                    if (result instanceof EObject) {
                        AddReferenceAction.this.modelElement.eSet((EStructuralFeature)AddReferenceAction.this.eReference, result);
                    }
                }
            }
        }
    }
}

