/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.packs.core.data.cmsis;

import org.eclipse.embedcdt.packs.core.data.cmsis.PdscTreeParser;
import org.eclipse.embedcdt.packs.core.data.cmsis.PdscUtils;
import org.eclipse.embedcdt.packs.core.tree.Leaf;
import org.eclipse.embedcdt.packs.core.tree.Node;

public class PdscTreeParserForBuild
extends PdscTreeParser {
    private int fCount;
    private String fVendorName;
    private String fPackName;
    private String fVersion;

    public int parseDevices(Node node, Node parent) {
        if (!this.checkValid(node)) {
            return 0;
        }
        this.fCount = 0;
        this.fVendorName = "";
        this.fPackName = "";
        this.fVersion = "";
        Leaf packageNode = node.getFirstChild();
        if (!packageNode.isType("package")) {
            return 0;
        }
        this.fVendorName = packageNode.getProperty("vendor");
        this.fPackName = packageNode.getProperty("name");
        if (packageNode.hasChildren()) {
            for (Leaf child : ((Node)packageNode).getChildren()) {
                if (child.isType("devices") && child.hasChildren()) {
                    for (Leaf grandchild : ((Node)child).getChildren()) {
                        if (!grandchild.isType("family")) continue;
                        this.processFamilyNode(grandchild, parent);
                    }
                    continue;
                }
                if (!child.isType("releases") || !child.hasChildren()) continue;
                Leaf versionNode = ((Node)child).getFirstChild();
                this.fVersion = versionNode.getProperty("version");
            }
        }
        return this.fCount;
    }

    public int parseBoards(Node node, Node parent) {
        if (!this.checkValid(node)) {
            return 0;
        }
        this.fCount = 0;
        this.fVendorName = "";
        this.fPackName = "";
        this.fVersion = "";
        Leaf packageNode = node.getFirstChild();
        if (!packageNode.isType("package")) {
            return 0;
        }
        this.fVendorName = packageNode.getProperty("vendor");
        this.fPackName = packageNode.getProperty("name");
        if (packageNode.hasChildren()) {
            for (Leaf child : ((Node)packageNode).getChildren()) {
                if (child.isType("boards") && child.hasChildren()) {
                    for (Leaf grandchild : ((Node)child).getChildren()) {
                        if (!grandchild.isType("board")) continue;
                        this.processBoardNode(grandchild, parent);
                    }
                    continue;
                }
                if (!child.isType("releases") || !child.hasChildren()) continue;
                Leaf versionNode = ((Node)child).getFirstChild();
                this.fVersion = versionNode.getProperty("version");
            }
        }
        return this.fCount;
    }

    private void processFamilyNode(Leaf node, Node parent) {
        String familyName = node.getProperty("Dfamily");
        String familyVendor = node.getProperty("Dvendor");
        String[] va = familyVendor.split("[:]");
        Node vendorNode = this.addUniqueVendor(parent, va[0], va[1]);
        Node familyNode = Node.addUniqueChild(vendorNode, "family", familyName);
        familyNode.putProperty("vendor.name", va[0]);
        familyNode.putProperty("vendor.id", va[1]);
        familyNode.putProperty("pack.vendor", this.fVendorName);
        familyNode.putProperty("pack.name", this.fPackName);
        familyNode.putProperty("pack.version", this.fVersion);
        if (node.hasChildren()) {
            for (Leaf child : ((Node)node).getChildren()) {
                if (child.isType("subFamily")) {
                    this.processSubFamilyNode(child, familyNode);
                    continue;
                }
                if (child.isType("device")) {
                    this.processDeviceNode(child, familyNode);
                    continue;
                }
                this.processDevicePropertiesGroup(child, familyNode);
            }
        }
    }

    private void processSubFamilyNode(Leaf node, Node parent) {
        String subFamilyName = node.getProperty("DsubFamily");
        Node subFamilyNode = Node.addUniqueChild(parent, "subfamily", subFamilyName);
        if (node.hasChildren()) {
            for (Leaf child : ((Node)node).getChildren()) {
                if (child.isType("device")) {
                    this.processDeviceNode(child, subFamilyNode);
                    continue;
                }
                this.processDevicePropertiesGroup(child, subFamilyNode);
            }
        }
    }

    private void processDeviceNode(Leaf node, Node parent) {
        String deviceName = node.getProperty("Dname");
        Node deviceNode = Node.addUniqueChild(parent, "device", deviceName);
        int saveCount = this.fCount;
        if (node.hasChildren()) {
            for (Leaf child : ((Node)node).getChildren()) {
                this.processDevicePropertiesGroup(child, deviceNode);
            }
        }
        if (this.fCount == saveCount) {
            ++this.fCount;
        }
    }

    private void processDevicePropertiesGroup(Leaf node, Node parent) {
        if (node.isType("processor")) {
            this.processProcessorNode(node, parent);
        } else if (node.isType("memory")) {
            this.processMemoryNode(node, parent);
        } else if (node.isType("compile")) {
            this.processCompileNode(node, parent);
        } else if (node.isType("book")) {
            this.processBookNode(node, parent);
        } else if (node.isType("debug")) {
            this.processDebugNode(node, parent);
        }
    }

    private void processProcessorNode(Leaf node, Node parent) {
        String Dcore = node.getProperty("Dcore");
        String DcoreVersion = node.getProperty("DcoreVersion");
        String Dfpu = node.getProperty("Dfpu");
        String Dmpu = node.getProperty("Dmpu");
        String Dendian = node.getProperty("Dendian");
        String Dclock = node.getProperty("Dclock");
        parent.putNonEmptyProperty("core", Dcore);
        parent.putNonEmptyProperty("core.version", DcoreVersion);
        parent.putNonEmptyProperty("fpu", Dfpu);
        parent.putNonEmptyProperty("mpu", Dmpu);
        parent.putNonEmptyProperty("endian", Dendian);
        parent.putNonEmptyProperty("clock", Dclock);
    }

    private void processMemoryNode(Leaf node, Node parent) {
        String id = node.getProperty("id");
        String nm = node.getProperty("name", id);
        String access = node.getProperty("access");
        String alias = node.getProperty("alias");
        String start = node.getProperty("start");
        String size = node.getProperty("size");
        String Pname = node.getProperty("Pname");
        String startup = node.getProperty("startup");
        Leaf memoryNode = Leaf.addUniqueChild(parent, "memory", nm);
        memoryNode.putProperty("start", start);
        memoryNode.putProperty("size", size);
        memoryNode.putNonEmptyProperty("pname", Pname);
        memoryNode.putNonEmptyProperty("startup", startup);
        memoryNode.putProperty("access", access);
        memoryNode.putProperty("alias", alias);
    }

    private void processCompileNode(Leaf node, Node parent) {
        String define = node.getProperty("define");
        parent.putNonEmptyProperty("define", define);
    }

    private void processDebugNode(Leaf node, Node parent) {
        String svd = node.getProperty("svd");
        String posixSvd = PdscUtils.updatePosixSeparators(svd);
        parent.putProperty("svd.file", posixSvd);
    }

    private void processBookNode(Leaf node, Node parent) {
        String bookName = node.getProperty("name");
        String title = node.getProperty("title");
        String category = node.getProperty("category");
        Leaf bookNode = Leaf.addNewChild(parent, "book");
        bookNode.setName(title);
        String posixName = this.updatePosixSeparators(bookName);
        if (bookName.startsWith("http://") || bookName.startsWith("https://") || bookName.startsWith("ftp://")) {
            bookNode.putNonEmptyProperty("url", bookName);
        } else {
            bookNode.putNonEmptyProperty("file", posixName);
        }
        bookNode.putNonEmptyProperty("category", category);
    }

    private void processBoardNode(Leaf node, Node parent) {
        String clock;
        String boardVendor = node.getProperty("vendor");
        String boardName = node.getProperty("name");
        String boardRevision = node.getProperty("revision");
        Node vendorNode = Node.addUniqueChild(parent, "vendor", boardVendor);
        Node boardNode = Node.addNewChild(vendorNode, "board");
        boardNode.setName(boardName);
        boardNode.putNonEmptyProperty("board.revision", boardRevision);
        boardNode.putNonEmptyProperty("vendor.name", boardVendor);
        boardNode.putProperty("pack.vendor", this.fVendorName);
        boardNode.putProperty("pack.name", this.fPackName);
        boardNode.putProperty("pack.version", this.fVersion);
        ++this.fCount;
        if (node.hasChildren()) {
            for (Leaf child : ((Node)node).getChildren()) {
                if (child.isType("mountedDevice")) {
                    String Dvendor = child.getProperty("Dvendor");
                    String Dname = child.getProperty("Dname");
                    if (Dname.length() <= 0) continue;
                    Node deviceNode = Node.addNewChild(boardNode, "device");
                    deviceNode.setName(Dname);
                    String[] va = Dvendor.split(":");
                    deviceNode.putProperty("vendor.name", va[0]);
                    deviceNode.putProperty("vendor.id", va[1]);
                    continue;
                }
                if (child.isType("feature")) {
                    this.processFeatureNode(child, boardNode);
                    continue;
                }
                if (!child.isType("book")) continue;
                this.processBookNode(child, boardNode);
            }
        }
        if ((clock = boardNode.getProperty("clock")).length() > 0) {
            boardNode.putProperty("clock", clock);
        }
    }

    private void processFeatureNode(Leaf node, Node parent) {
        String featureType = node.getProperty("type");
        String featureN = node.getProperty("n");
        if ("XTAL".equals(featureType)) {
            parent.putNonEmptyProperty("clock", featureN);
        }
    }
}

