/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.jlink.ui;

import java.io.File;
import org.eclipse.cdt.debug.gdbjtag.ui.GDBJtagImages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.debug.gdbjtag.core.data.CProjectAttributes;
import org.eclipse.embedcdt.debug.gdbjtag.jlink.core.Configuration;
import org.eclipse.embedcdt.debug.gdbjtag.jlink.core.preferences.DefaultPreferences;
import org.eclipse.embedcdt.debug.gdbjtag.jlink.core.preferences.PersistentPreferences;
import org.eclipse.embedcdt.debug.gdbjtag.jlink.ui.TabStartup;
import org.eclipse.embedcdt.internal.debug.gdbjtag.jlink.ui.Activator;
import org.eclipse.embedcdt.internal.debug.gdbjtag.jlink.ui.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class TabDebugger
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "Debugger";
    private static final String TAB_ID = "org.eclipse.embedcdt.debug.gdbjtag.jlink.ui.ui.debuggertab";
    private static int COLUMN_WIDTH = 70;
    private ILaunchConfiguration fConfiguration;
    private Text fGdbClientExecutable;
    private Text fGdbClientOtherOptions;
    private Text fGdbClientPathLabel;
    private Text fGdbClientOtherCommands;
    private Button fDoStartGdbServer;
    private Text fGdbServerPathLabel;
    private Link fLink;
    private Text fTargetIpAddress;
    private Text fTargetPortNumber;
    private Text fGdbFlashDeviceName;
    private Button fGdbEndiannessLittle;
    private Button fGdbEndiannessBig;
    private Button fGdbInterfaceJtag;
    private Button fGdbInterfaceSwd;
    private Button fGdbServerConnectionUsb;
    private Button fGdbServerConnectionIp;
    private Text fGdbServerConnectionAddress;
    private Button fGdbServerSpeedAuto;
    private Button fGdbServerSpeedAdaptive;
    private Button fGdbServerSpeedFixed;
    private Text fGdbServerSpeedFixedValue;
    private Button fDoConnectToRunning;
    private Text fGdbServerGdbPort;
    private Text fGdbServerSwoPort;
    private Text fGdbServerTelnetPort;
    private Text fGdbServerExecutable;
    private Button fGdbServerBrowseButton;
    private Button fGdbServerVariablesButton;
    private Button fDoGdbServerVerifyDownload;
    private Button fDoGdbServerInitRegs;
    private Button fDoGdbServerLocalOnly;
    private Button fDoGdbServerSilent;
    private Text fGdbServerLog;
    private Button fGdbServerLogBrowse;
    private Text fGdbServerOtherOptions;
    private Button fDoGdbServerAllocateConsole;
    private Button fDoGdbServerAllocateSemihostingConsole;
    protected Button fUpdateThreadlistOnSuspend;
    protected String fSavedCmsisDeviceName;
    private TabStartup fTabStartup;
    private DefaultPreferences fDefaultPreferences;
    private PersistentPreferences fPersistentPreferences;

    protected TabDebugger(TabStartup tabStartup) {
        this.fTabStartup = tabStartup;
        this.fSavedCmsisDeviceName = "";
        this.fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
        this.fPersistentPreferences = Activator.getInstance().getPersistentPreferences();
    }

    public String getName() {
        return TAB_NAME;
    }

    public Image getImage() {
        return GDBJtagImages.getDebuggerTabImage();
    }

    public void createControl(Composite parent) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.TabDebugger.createControl() ");
        }
        if (EclipseUtils.isLinux()) {
            COLUMN_WIDTH = 85;
        }
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        this.createGdbServerGroup(comp);
        this.createGdbClientControls(comp);
        this.createRemoteControl(comp);
        this.fUpdateThreadlistOnSuspend = new Button(comp, 32);
        this.fUpdateThreadlistOnSuspend.setText(Messages.getString("DebuggerTab.update_thread_list_on_suspend_Text"));
        this.fUpdateThreadlistOnSuspend.setToolTipText(Messages.getString("DebuggerTab.update_thread_list_on_suspend_ToolTipText"));
        Link restoreDefaults = new Link(comp, 0);
        restoreDefaults.setText(Messages.getString("DebuggerTab.restoreDefaults_Link"));
        restoreDefaults.setToolTipText(Messages.getString("DebuggerTab.restoreDefaults_ToolTipText"));
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 131072;
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        restoreDefaults.setLayoutData((Object)gd);
        this.fUpdateThreadlistOnSuspend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        restoreDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabDebugger.this.initializeFromDefaults();
                TabDebugger.this.scheduleUpdateJob();
            }
        });
    }

    private void browseButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    private void browseSaveButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    private void variablesButtonSelected(Text text) {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            text.insert(dialog.getVariableExpression());
        }
    }

    private void createGdbServerGroup(final Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText(Messages.getString("DebuggerTab.gdbServerGroup_Text"));
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 5;
        layout2.marginHeight = 0;
        comp.setLayout((Layout)layout2);
        GridData gd2 = new GridData(768);
        comp.setLayoutData((Object)gd2);
        Composite local = new Composite(comp, 0);
        GridLayout layout3 = new GridLayout();
        layout3.numColumns = 2;
        layout3.marginHeight = 0;
        layout3.marginWidth = 0;
        local.setLayout((Layout)layout3);
        GridData gd3 = new GridData(768);
        gd3.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        local.setLayoutData((Object)gd3);
        this.fDoStartGdbServer = new Button(local, 32);
        this.fDoStartGdbServer.setText(Messages.getString("DebuggerTab.doStartGdbServer_Text"));
        this.fDoStartGdbServer.setToolTipText(Messages.getString("DebuggerTab.doStartGdbServer_ToolTipText"));
        gd3 = new GridData(768);
        this.fDoStartGdbServer.setLayoutData((Object)gd3);
        this.fDoConnectToRunning = new Button(local, 32);
        this.fDoConnectToRunning.setText(Messages.getString("DebuggerTab.noReset_Text"));
        this.fDoConnectToRunning.setToolTipText(Messages.getString("DebuggerTab.noReset_ToolTipText"));
        gd3 = new GridData(768);
        this.fDoConnectToRunning.setLayoutData((Object)gd3);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbServerExecutable_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbServerExecutable_ToolTipText"));
        Composite local2 = new Composite(comp, 0);
        GridLayout layout4 = new GridLayout();
        layout4.numColumns = 3;
        layout4.marginHeight = 0;
        layout4.marginWidth = 0;
        local2.setLayout((Layout)layout4);
        GridData gd4 = new GridData(768);
        gd4.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        local2.setLayoutData((Object)gd4);
        this.fGdbServerExecutable = new Text(local2, 2052);
        gd4 = new GridData(768);
        this.fGdbServerExecutable.setLayoutData((Object)gd4);
        this.fGdbServerBrowseButton = new Button(local2, 0);
        this.fGdbServerBrowseButton.setText(Messages.getString("DebuggerTab.gdbServerExecutableBrowse"));
        this.fGdbServerVariablesButton = new Button(local2, 0);
        this.fGdbServerVariablesButton.setText(Messages.getString("DebuggerTab.gdbServerExecutableVariable"));
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbServerActualPath_Label"));
        this.fGdbServerPathLabel = new Text(comp, 2052);
        gd2 = new GridData(4, 0, true, false);
        gd2.horizontalSpan = 4;
        this.fGdbServerPathLabel.setLayoutData((Object)gd2);
        this.fGdbServerPathLabel.setEnabled(true);
        this.fGdbServerPathLabel.setEditable(false);
        label = new Label(comp, 0);
        label.setText("");
        this.fLink = new Link(comp, 0);
        this.fLink.setText(Messages.getString("DebuggerTab.gdbServerActualPath_link"));
        gd2 = new GridData();
        gd2.horizontalSpan = 4;
        this.fLink.setLayoutData((Object)gd2);
        Label label2 = new Label(comp, 0);
        label2.setText(Messages.getString("DebuggerTab.deviceName_Label"));
        label2.setToolTipText(Messages.getString("DebuggerTab.deviceName_ToolTipText"));
        Composite local3 = new Composite(comp, 0);
        GridLayout layout5 = new GridLayout();
        layout5.numColumns = 3;
        layout5.marginHeight = 0;
        layout5.marginWidth = 0;
        local3.setLayout((Layout)layout5);
        GridData gd5 = new GridData(768);
        gd5.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        local3.setLayoutData((Object)gd5);
        this.fGdbFlashDeviceName = new Text(local3, 2048);
        gd5 = new GridData();
        gd5.widthHint = 180;
        this.fGdbFlashDeviceName.setLayoutData((Object)gd5);
        Composite empty = new Composite(local3, 0);
        layout5 = new GridLayout();
        layout5.numColumns = 1;
        layout5.marginHeight = 0;
        layout5.marginWidth = 0;
        empty.setLayout((Layout)layout5);
        gd5 = new GridData(768);
        empty.setLayoutData((Object)gd5);
        Link link = new Link(local3, 0);
        link.setText(Messages.getString("DebuggerTab.deviceName_Link"));
        gd5 = new GridData(131072);
        link.setLayoutData((Object)gd5);
        label2 = new Label(comp, 0);
        label2.setText(Messages.getString("DebuggerTab.endianness_Label"));
        label2.setToolTipText(Messages.getString("DebuggerTab.endianness_ToolTipText"));
        Composite radio = new Composite(comp, 0);
        layout5 = new GridLayout();
        layout5.numColumns = 2;
        layout5.marginHeight = 0;
        radio.setLayout((Layout)layout5);
        gd5 = new GridData(768);
        gd5.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        radio.setLayoutData((Object)gd5);
        this.fGdbEndiannessLittle = new Button(radio, 16);
        this.fGdbEndiannessLittle.setText(Messages.getString("DebuggerTab.endiannesslittle_Text"));
        gd5 = new GridData();
        gd5.widthHint = COLUMN_WIDTH;
        this.fGdbEndiannessLittle.setLayoutData((Object)gd5);
        this.fGdbEndiannessBig = new Button(radio, 16);
        this.fGdbEndiannessBig.setText(Messages.getString("DebuggerTab.endiannessBig_Text"));
        gd5 = new GridData();
        gd5.widthHint = COLUMN_WIDTH;
        this.fGdbEndiannessBig.setLayoutData((Object)gd5);
        label2 = new Label(comp, 0);
        label2.setText(Messages.getString("DebuggerTab.gdbServerConnection_Label"));
        label2.setToolTipText(Messages.getString("DebuggerTab.gdbServerConnection_ToolTipText"));
        local3 = new Composite(comp, 0);
        layout5 = new GridLayout();
        layout5.numColumns = 4;
        layout5.marginHeight = 0;
        local3.setLayout((Layout)layout5);
        gd5 = new GridData(768);
        gd5.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        local3.setLayoutData((Object)gd5);
        this.fGdbServerConnectionUsb = new Button(local3, 16);
        this.fGdbServerConnectionUsb.setText(Messages.getString("DebuggerTab.connectionUsb_Text"));
        gd5 = new GridData();
        gd5.widthHint = COLUMN_WIDTH;
        this.fGdbServerConnectionUsb.setLayoutData((Object)gd5);
        this.fGdbServerConnectionIp = new Button(local3, 16);
        this.fGdbServerConnectionIp.setText(Messages.getString("DebuggerTab.connectionTcp_Text"));
        gd5 = new GridData();
        gd5.widthHint = COLUMN_WIDTH;
        this.fGdbServerConnectionIp.setLayoutData((Object)gd5);
        this.fGdbServerConnectionAddress = new Text(local3, 2048);
        gd5 = new GridData();
        gd5.widthHint = 145;
        this.fGdbServerConnectionAddress.setLayoutData((Object)gd5);
        label2 = new Label(local3, 0);
        label2.setText(Messages.getString("DebuggerTab.connectionAfter_Text"));
        label2 = new Label(comp, 0);
        label2.setText(Messages.getString("DebuggerTab.interface_Label"));
        label2.setToolTipText(Messages.getString("DebuggerTab.interface_ToolTipText"));
        local3 = new Composite(comp, 0);
        layout5 = new GridLayout();
        layout5.numColumns = 2;
        layout5.marginHeight = 0;
        local3.setLayout((Layout)layout5);
        gd5 = new GridData(768);
        gd5.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        local3.setLayoutData((Object)gd5);
        this.fGdbInterfaceSwd = new Button(local3, 16);
        this.fGdbInterfaceSwd.setText(Messages.getString("DebuggerTab.interfaceSWD_Text"));
        gd5 = new GridData();
        gd5.widthHint = COLUMN_WIDTH;
        this.fGdbInterfaceSwd.setLayoutData((Object)gd5);
        this.fGdbInterfaceJtag = new Button(local3, 16);
        this.fGdbInterfaceJtag.setText(Messages.getString("DebuggerTab.interfaceJtag_Text"));
        gd5 = new GridData();
        gd5.widthHint = COLUMN_WIDTH;
        this.fGdbInterfaceJtag.setLayoutData((Object)gd5);
        label2 = new Label(comp, 0);
        label2.setText(Messages.getString("DebuggerTab.gdbServerSpeed_Label"));
        label2.setToolTipText(Messages.getString("DebuggerTab.gdbServerSpeed_ToolTipText"));
        radio = new Composite(comp, 0);
        layout5 = new GridLayout();
        layout5.numColumns = 5;
        layout5.marginHeight = 0;
        radio.setLayout((Layout)layout5);
        gd5 = new GridData(768);
        gd5.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        radio.setLayoutData((Object)gd5);
        this.fGdbServerSpeedAuto = new Button(radio, 16);
        this.fGdbServerSpeedAuto.setText(Messages.getString("DebuggerTab.gdbServerSpeedAuto_Text"));
        gd5 = new GridData();
        gd5.widthHint = COLUMN_WIDTH;
        this.fGdbServerSpeedAuto.setLayoutData((Object)gd5);
        this.fGdbServerSpeedAdaptive = new Button(radio, 16);
        this.fGdbServerSpeedAdaptive.setText(Messages.getString("DebuggerTab.gdbServerSpeedAdaptive_Text"));
        gd5.widthHint = COLUMN_WIDTH;
        this.fGdbServerSpeedAdaptive.setLayoutData((Object)gd5);
        this.fGdbServerSpeedFixed = new Button(radio, 16);
        this.fGdbServerSpeedFixed.setText(Messages.getString("DebuggerTab.gdbServerSpeedFixed_Text"));
        gd5.widthHint = COLUMN_WIDTH;
        this.fGdbServerSpeedFixed.setLayoutData((Object)gd5);
        this.fGdbServerSpeedFixedValue = new Text(radio, 2048);
        gd5 = new GridData();
        gd5.widthHint = 40;
        this.fGdbServerSpeedFixedValue.setLayoutData((Object)gd5);
        label2 = new Label(radio, 0);
        label2.setText(Messages.getString("DebuggerTab.gdbServerSpeedFixedUnit_Text"));
        label2 = new Label(comp, 0);
        label2.setText(Messages.getString("DebuggerTab.gdbServerGdbPort_Label"));
        label2.setToolTipText(Messages.getString("DebuggerTab.gdbServerGdbPort_ToolTipText"));
        this.fGdbServerGdbPort = new Text(comp, 2052);
        gd3 = new GridData();
        gd3.widthHint = 60;
        gd3.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbServerGdbPort.setLayoutData((Object)gd3);
        label2 = new Label(comp, 0);
        label2.setText(Messages.getString("DebuggerTab.gdbServerSwoPort_Label"));
        label2.setToolTipText(Messages.getString("DebuggerTab.gdbServerSwoPort_ToolTipText"));
        this.fGdbServerSwoPort = new Text(comp, 2052);
        gd3 = new GridData();
        gd3.widthHint = 60;
        this.fGdbServerSwoPort.setLayoutData((Object)gd3);
        Composite empty2 = new Composite(comp, 0);
        GridLayout layout6 = new GridLayout();
        layout6.numColumns = 1;
        layout6.marginHeight = 0;
        layout6.marginWidth = 0;
        empty2.setLayout((Layout)layout6);
        gd3 = new GridData(768);
        empty2.setLayoutData((Object)gd3);
        this.fDoGdbServerVerifyDownload = new Button(comp, 32);
        this.fDoGdbServerVerifyDownload.setText(Messages.getString("DebuggerTab.gdbServerVerifyDownload_Label"));
        this.fDoGdbServerVerifyDownload.setToolTipText(Messages.getString("DebuggerTab.gdbServerVerifyDownload_ToolTipText"));
        gd3 = new GridData();
        gd3.horizontalIndent = 60;
        this.fDoGdbServerVerifyDownload.setLayoutData((Object)gd3);
        this.fDoGdbServerInitRegs = new Button(comp, 32);
        this.fDoGdbServerInitRegs.setText(Messages.getString("DebuggerTab.gdbServerInitRegs_Label"));
        this.fDoGdbServerInitRegs.setToolTipText(Messages.getString("DebuggerTab.gdbServerInitRegs_ToolTipText"));
        label2 = new Label(comp, 0);
        label2.setText(Messages.getString("DebuggerTab.gdbServerTelnetPort_Label"));
        label2.setToolTipText(Messages.getString("DebuggerTab.gdbServerTelnetPort_ToolTipText"));
        this.fGdbServerTelnetPort = new Text(comp, 2052);
        gd3 = new GridData();
        gd3.widthHint = 60;
        this.fGdbServerTelnetPort.setLayoutData((Object)gd3);
        empty2 = new Composite(comp, 0);
        layout6 = new GridLayout();
        layout6.numColumns = 1;
        layout6.marginHeight = 0;
        layout6.marginWidth = 0;
        empty2.setLayout((Layout)layout6);
        gd3 = new GridData(768);
        empty2.setLayoutData((Object)gd3);
        this.fDoGdbServerLocalOnly = new Button(comp, 32);
        this.fDoGdbServerLocalOnly.setText(Messages.getString("DebuggerTab.gdbServerLocalOnly_Label"));
        this.fDoGdbServerLocalOnly.setToolTipText(Messages.getString("DebuggerTab.gdbServerLocalOnly_ToolTipText"));
        gd3 = new GridData();
        gd3.horizontalIndent = 60;
        this.fDoGdbServerLocalOnly.setLayoutData((Object)gd3);
        this.fDoGdbServerSilent = new Button(comp, 32);
        this.fDoGdbServerSilent.setText(Messages.getString("DebuggerTab.gdbServerSilent_Label"));
        this.fDoGdbServerSilent.setToolTipText(Messages.getString("DebuggerTab.gdbServerSilent_ToolTipText"));
        label2 = new Label(comp, 0);
        label2.setText(Messages.getString("DebuggerTab.gdbServerLog_Label"));
        local3 = new Composite(comp, 0);
        layout5 = new GridLayout();
        layout5.numColumns = 2;
        layout5.marginHeight = 0;
        layout5.marginWidth = 0;
        local3.setLayout((Layout)layout5);
        gd5 = new GridData(768);
        gd5.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        local3.setLayoutData((Object)gd5);
        this.fGdbServerLog = new Text(local3, 2048);
        gd5 = new GridData(768);
        this.fGdbServerLog.setLayoutData((Object)gd5);
        this.fGdbServerLogBrowse = new Button(local3, 0);
        this.fGdbServerLogBrowse.setText(Messages.getString("DebuggerTab.gdbServerLogBrowse_Button"));
        label2 = new Label(comp, 0);
        label2.setText(Messages.getString("DebuggerTab.gdbServerOther_Label"));
        this.fGdbServerOtherOptions = new Text(comp, 2048);
        gd3 = new GridData(768);
        gd3.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbServerOtherOptions.setLayoutData((Object)gd3);
        local2 = new Composite(comp, 0);
        layout4 = new GridLayout();
        layout4.numColumns = 2;
        layout4.marginHeight = 0;
        layout4.marginWidth = 0;
        layout4.makeColumnsEqualWidth = true;
        local2.setLayout((Layout)layout4);
        gd4 = new GridData(768);
        gd4.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        local2.setLayoutData((Object)gd4);
        this.fDoGdbServerAllocateConsole = new Button(local2, 32);
        this.fDoGdbServerAllocateConsole.setText(Messages.getString("DebuggerTab.gdbServerAllocateConsole_Label"));
        this.fDoGdbServerAllocateConsole.setToolTipText(Messages.getString("DebuggerTab.gdbServerAllocateConsole_ToolTipText"));
        gd4 = new GridData(768);
        this.fDoGdbServerAllocateConsole.setLayoutData((Object)gd4);
        this.fDoGdbServerAllocateSemihostingConsole = new Button(local2, 32);
        this.fDoGdbServerAllocateSemihostingConsole.setText(Messages.getString("DebuggerTab.gdbServerAllocateSemihostingConsole_Label"));
        this.fDoGdbServerAllocateSemihostingConsole.setToolTipText(Messages.getString("DebuggerTab.gdbServerAllocateSemihostingConsole_ToolTipText"));
        gd4 = new GridData(768);
        this.fDoGdbServerAllocateSemihostingConsole.setLayoutData((Object)gd4);
        VerifyListener numericVerifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character);
            }
        };
        ModifyListener scheduleUpdateJobModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        };
        SelectionAdapter scheduleUpdateJobSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        };
        this.fDoStartGdbServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.doStartGdbServerChanged();
                if (TabDebugger.this.fDoStartGdbServer.getSelection()) {
                    TabDebugger.this.fTargetIpAddress.setText("localhost");
                }
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fDoConnectToRunning.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.propagateConnectToRunningChanged();
                TabDebugger.this.fTabStartup.doConnectToRunningChanged(TabDebugger.this.fDoConnectToRunning.getSelection());
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbServerExecutable.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
                TabDebugger.this.updateGdbServerActualPath();
            }
        });
        this.fGdbServerBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.browseButtonSelected(Messages.getString("DebuggerTab.gdbServerExecutableBrowse_Title"), TabDebugger.this.fGdbServerExecutable);
            }
        });
        this.fGdbServerVariablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.variablesButtonSelected(TabDebugger.this.fGdbServerExecutable);
            }
        });
        this.fLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = e.text;
                if (Activator.getInstance().isDebugging()) {
                    System.out.println(text);
                }
                int ret = -1;
                if ("global".equals(text)) {
                    ret = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"org.eclipse.embedcdt.internal.debug.gdbjtag.jlink.ui.globalPreferencePage", null, null).open();
                } else if ("workspace".equals(text)) {
                    ret = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"org.eclipse.embedcdt.internal.debug.gdbjtag.jlink.ui.workspacePreferencePage", null, null).open();
                } else if ("project".equals(text)) {
                    if (!$assertionsDisabled && TabDebugger.this.fConfiguration == null) {
                        throw new AssertionError();
                    }
                    IProject project = EclipseUtils.getProjectByLaunchConfiguration((ILaunchConfiguration)TabDebugger.this.fConfiguration);
                    ret = PreferencesUtil.createPropertyDialogOn((Shell)parent.getShell(), (IAdaptable)project, (String)"org.eclipse.embedcdt.internal.debug.gdbjtag.jlink.ui.projectPropertiesPage", null, null, (int)0).open();
                }
                if (ret == 0) {
                    TabDebugger.this.updateGdbServerActualPath();
                }
            }
        });
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.fGdbServerConnectionAddress.setText("");
                TabDebugger.this.scheduleUpdateJob();
            }
        };
        this.fGdbServerConnectionUsb.addSelectionListener((SelectionListener)selectionAdapter);
        this.fGdbServerConnectionIp.addSelectionListener((SelectionListener)selectionAdapter);
        this.fGdbServerConnectionAddress.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbServerConnectionAddress.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = TabDebugger.this.fGdbServerConnectionUsb.getSelection() ? Character.isDigit(e.character) || Character.isISOControl(e.character) : (TabDebugger.this.fGdbServerConnectionIp.getSelection() ? Character.isLetterOrDigit(e.character) || e.character == '.' || e.character == ':' || e.character == '-' || e.character == '_' || Character.isISOControl(e.character) : false);
            }
        });
        this.fGdbInterfaceSwd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.fTabStartup.doInterfaceSwdChanged(true);
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbInterfaceJtag.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.fTabStartup.doInterfaceSwdChanged(false);
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbServerSpeedAuto.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.fGdbServerSpeedFixedValue.setEnabled(false);
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbServerSpeedAdaptive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.fGdbServerSpeedFixedValue.setEnabled(false);
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbServerSpeedFixed.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.fGdbServerSpeedFixedValue.setEnabled(true);
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbServerSpeedFixedValue.addVerifyListener(numericVerifyListener);
        this.fGdbServerSpeedFixedValue.addModifyListener(scheduleUpdateJobModifyListener);
        this.fGdbFlashDeviceName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Program.launch((String)event.text);
            }
        });
        this.fGdbEndiannessLittle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbEndiannessBig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbServerGdbPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.fTargetPortNumber.setText(TabDebugger.this.fGdbServerGdbPort.getText());
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbServerGdbPort.addVerifyListener(numericVerifyListener);
        this.fGdbServerSwoPort.addModifyListener(scheduleUpdateJobModifyListener);
        this.fGdbServerSwoPort.addVerifyListener(numericVerifyListener);
        this.fGdbServerTelnetPort.addModifyListener(scheduleUpdateJobModifyListener);
        this.fGdbServerTelnetPort.addVerifyListener(numericVerifyListener);
        this.fDoGdbServerVerifyDownload.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
        this.fDoGdbServerInitRegs.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
        this.fDoGdbServerLocalOnly.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
        this.fDoGdbServerSilent.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
        this.fGdbServerLog.addModifyListener(scheduleUpdateJobModifyListener);
        this.fGdbServerLogBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.browseSaveButtonSelected(Messages.getString("DebuggerTab.gdbServerLogBrowse_Title"), TabDebugger.this.fGdbServerLog);
            }
        });
        this.fGdbServerOtherOptions.addModifyListener(scheduleUpdateJobModifyListener);
        this.fDoGdbServerAllocateConsole.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
        this.fDoGdbServerAllocateSemihostingConsole.addSelectionListener((SelectionListener)scheduleUpdateJobSelectionAdapter);
    }

    private void createGdbClientControls(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("DebuggerTab.gdbSetupGroup_Text"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 5;
        layout2.marginHeight = 0;
        comp.setLayout((Layout)layout2);
        GridData gd2 = new GridData(768);
        comp.setLayoutData((Object)gd2);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbCommand_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbCommand_ToolTipText"));
        Composite local = new Composite(comp, 0);
        GridLayout layout3 = new GridLayout();
        layout3.numColumns = 3;
        layout3.marginHeight = 0;
        layout3.marginWidth = 0;
        local.setLayout((Layout)layout3);
        GridData gd3 = new GridData(768);
        gd3.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        local.setLayoutData((Object)gd3);
        this.fGdbClientExecutable = new Text(local, 2052);
        gd3 = new GridData(768);
        this.fGdbClientExecutable.setLayoutData((Object)gd3);
        Button browseButton = new Button(local, 0);
        browseButton.setText(Messages.getString("DebuggerTab.gdbCommandBrowse"));
        Button variableButton = new Button(local, 0);
        variableButton.setText(Messages.getString("DebuggerTab.gdbCommandVariable"));
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbCommandActualPath_Label"));
        this.fGdbClientPathLabel = new Text(comp, 2052);
        GridData gd4 = new GridData(4, 0, true, false);
        gd4.horizontalSpan = 4;
        this.fGdbClientPathLabel.setLayoutData((Object)gd4);
        this.fGdbClientPathLabel.setEnabled(true);
        this.fGdbClientPathLabel.setEditable(false);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbOtherOptions_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbOtherOptions_ToolTipText"));
        gd4 = new GridData();
        label.setLayoutData((Object)gd4);
        this.fGdbClientOtherOptions = new Text(comp, 2052);
        gd4 = new GridData(768);
        gd4.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbClientOtherOptions.setLayoutData((Object)gd4);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.gdbOtherCommands_Label"));
        label.setToolTipText(Messages.getString("DebuggerTab.gdbOtherCommands_ToolTipText"));
        gd4 = new GridData();
        gd4.verticalAlignment = 128;
        label.setLayoutData((Object)gd4);
        this.fGdbClientOtherCommands = new Text(comp, 2626);
        gd4 = new GridData(4, 4, true, true);
        gd4.heightHint = 60;
        gd4.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbClientOtherCommands.setLayoutData((Object)gd4);
        this.fGdbClientExecutable.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
                TabDebugger.this.updateGdbClientActualPath();
            }
        });
        this.fGdbClientOtherCommands.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fGdbClientOtherOptions.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.browseButtonSelected(Messages.getString("DebuggerTab.gdbCommandBrowse_Title"), TabDebugger.this.fGdbClientExecutable);
            }
        });
        variableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.variablesButtonSelected(TabDebugger.this.fGdbClientExecutable);
            }
        });
    }

    private void createRemoteControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("DebuggerTab.remoteGroup_Text"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 2;
        layout2.marginHeight = 0;
        comp.setLayout((Layout)layout2);
        GridData gd2 = new GridData(768);
        comp.setLayoutData((Object)gd2);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.ipAddressLabel"));
        this.fTargetIpAddress = new Text(comp, 2048);
        gd2 = new GridData();
        gd2.widthHint = 125;
        this.fTargetIpAddress.setLayoutData((Object)gd2);
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.portNumberLabel"));
        this.fTargetPortNumber = new Text(comp, 2048);
        gd2 = new GridData();
        gd2.widthHint = 125;
        this.fTargetPortNumber.setLayoutData((Object)gd2);
        this.fTargetIpAddress.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.fTargetPortNumber.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character);
            }
        });
        this.fTargetPortNumber.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
    }

    private void updateGdbServerActualPath() {
        assert (this.fConfiguration != null);
        String fullCommand = Configuration.getGdbServerCommand((ILaunchConfiguration)this.fConfiguration, (String)this.fGdbServerExecutable.getText());
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.TabDebugger.updateActualpath() \"" + fullCommand + "\"");
        }
        this.fGdbServerPathLabel.setText(fullCommand);
    }

    private void updateGdbClientActualPath() {
        assert (this.fConfiguration != null);
        String fullCommand = Configuration.getGdbClientCommand((ILaunchConfiguration)this.fConfiguration, (String)this.fGdbClientExecutable.getText());
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.TabDebugger.updateGdbClientActualPath() \"" + fullCommand + "\"");
        }
        this.fGdbClientPathLabel.setText(fullCommand);
    }

    private void doStartGdbServerChanged() {
        boolean enabled = this.fDoStartGdbServer.getSelection();
        this.fGdbServerExecutable.setEnabled(enabled);
        this.fGdbServerBrowseButton.setEnabled(enabled);
        this.fGdbServerVariablesButton.setEnabled(enabled);
        this.fDoConnectToRunning.setEnabled(enabled);
        this.fGdbFlashDeviceName.setEnabled(enabled);
        this.fGdbServerConnectionAddress.setEnabled(enabled);
        this.fGdbServerGdbPort.setEnabled(enabled);
        this.fGdbServerSwoPort.setEnabled(enabled);
        this.fGdbServerTelnetPort.setEnabled(enabled);
        this.fDoGdbServerVerifyDownload.setEnabled(enabled);
        this.fDoGdbServerInitRegs.setEnabled(enabled);
        this.fDoGdbServerLocalOnly.setEnabled(enabled);
        this.fDoGdbServerSilent.setEnabled(enabled);
        this.fGdbServerOtherOptions.setEnabled(enabled);
        this.fGdbServerLog.setEnabled(enabled);
        this.fGdbServerLogBrowse.setEnabled(enabled);
        this.fDoGdbServerAllocateConsole.setEnabled(false);
        this.fDoGdbServerAllocateSemihostingConsole.setEnabled(enabled);
        this.fTargetIpAddress.setEnabled(!enabled);
        this.fTargetPortNumber.setEnabled(!enabled);
        this.fGdbServerPathLabel.setEnabled(enabled);
        this.fLink.setEnabled(enabled);
    }

    private void propagateConnectToRunningChanged() {
        if (this.fDoStartGdbServer.getSelection()) {
            boolean enabled = this.fDoConnectToRunning.getSelection();
            this.fDoGdbServerInitRegs.setEnabled(!enabled);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.TabDebugger.initializeFrom() " + configuration.getName());
        }
        this.fConfiguration = configuration;
        try {
            Boolean booleanDefault = this.fPersistentPreferences.getGdbServerDoStart();
            this.fDoStartGdbServer.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doStartGdbServer", booleanDefault.booleanValue()));
            this.fDoConnectToRunning.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doConnectToRunning", false));
            String stringDefault = this.fPersistentPreferences.getGdbServerExecutable();
            this.fGdbServerExecutable.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerExecutable", stringDefault));
            this.fSavedCmsisDeviceName = stringDefault = CProjectAttributes.getCmsisDeviceVariantName((ILaunchConfiguration)configuration);
            if (stringDefault == null || stringDefault.isEmpty()) {
                stringDefault = this.fPersistentPreferences.getFlashDeviceName();
            }
            String defaultDeviceName = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.flashDeviceName", stringDefault);
            String deviceName = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerDeviceName", defaultDeviceName);
            this.fGdbFlashDeviceName.setText(deviceName);
            stringDefault = this.fPersistentPreferences.getGdbServerEndianness();
            String defaultEndianness = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.endianness", stringDefault);
            String endianness = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerDeviceEndianness", defaultEndianness);
            if ("little".equals(endianness)) {
                this.fGdbEndiannessLittle.setSelection(true);
            } else if ("big".equals(endianness)) {
                this.fGdbEndiannessBig.setSelection(true);
            } else {
                String message = "unknown endianness " + endianness + ", using little";
                Activator.log((String)message);
                this.fGdbEndiannessLittle.setSelection(true);
            }
            stringDefault = this.fPersistentPreferences.getGdbServerConnection();
            String connection = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerConnection", stringDefault);
            if ("usb".equals(connection)) {
                this.fGdbServerConnectionUsb.setSelection(true);
                this.fGdbServerConnectionIp.setSelection(false);
            } else if ("ip".equals(connection)) {
                this.fGdbServerConnectionUsb.setSelection(false);
                this.fGdbServerConnectionIp.setSelection(true);
            }
            stringDefault = this.fPersistentPreferences.getGdbServerConnectionAddress();
            String connectionAddress = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerConnectionAddress", stringDefault);
            this.fGdbServerConnectionAddress.setText(connectionAddress);
            stringDefault = this.fPersistentPreferences.getGdbServerInterface();
            String defaultPhysicalInterface = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.interface", stringDefault);
            String physicalInterface = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerDebugInterface", defaultPhysicalInterface);
            if ("swd".equals(physicalInterface)) {
                this.fGdbInterfaceSwd.setSelection(true);
                this.fTabStartup.doInterfaceSwdChanged(true);
            } else if ("jtag".equals(physicalInterface)) {
                this.fGdbInterfaceJtag.setSelection(true);
                this.fTabStartup.doInterfaceSwdChanged(false);
            } else {
                String message = "unknown interface " + physicalInterface + ", using swd";
                Activator.log((String)message);
                this.fGdbInterfaceSwd.setSelection(true);
            }
            stringDefault = this.fPersistentPreferences.getGdbServerInitialSpeed();
            String defaultPhysicalInterfaceSpeed = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerSpeed", stringDefault);
            String physicalInterfaceSpeed = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerDeviceSpeed", defaultPhysicalInterfaceSpeed);
            if ("auto".equals(physicalInterfaceSpeed)) {
                this.fGdbServerSpeedAuto.setSelection(true);
                this.fGdbServerSpeedAdaptive.setSelection(false);
                this.fGdbServerSpeedFixed.setSelection(false);
                this.fGdbServerSpeedFixedValue.setEnabled(false);
            } else if ("adaptive".equals(physicalInterfaceSpeed)) {
                this.fGdbServerSpeedAuto.setSelection(false);
                this.fGdbServerSpeedAdaptive.setSelection(true);
                this.fGdbServerSpeedFixed.setSelection(false);
                this.fGdbServerSpeedFixedValue.setEnabled(false);
            } else {
                try {
                    Integer.parseInt(physicalInterfaceSpeed);
                    this.fGdbServerSpeedAuto.setSelection(false);
                    this.fGdbServerSpeedAdaptive.setSelection(false);
                    this.fGdbServerSpeedFixed.setSelection(true);
                    this.fGdbServerSpeedFixedValue.setEnabled(true);
                    this.fGdbServerSpeedFixedValue.setText(physicalInterfaceSpeed);
                }
                catch (NumberFormatException e) {
                    String message = "unknown interface speed " + physicalInterfaceSpeed + ", using auto";
                    Activator.log((String)message);
                    this.fGdbServerSpeedAuto.setSelection(true);
                    this.fGdbServerSpeedFixedValue.setEnabled(false);
                }
            }
            this.fGdbServerGdbPort.setText(Integer.toString(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerGdbPortNumber", 2331)));
            this.fGdbServerSwoPort.setText(Integer.toString(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerSwoPortNumber", 2332)));
            this.fGdbServerTelnetPort.setText(Integer.toString(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerTelnetPortNumber", 2333)));
            this.fDoGdbServerVerifyDownload.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerVerifyDownload", true));
            this.fDoGdbServerInitRegs.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerInitRegs", true));
            this.fDoGdbServerLocalOnly.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerLocalOnly", true));
            this.fDoGdbServerSilent.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerSilent", false));
            this.fGdbServerLog.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerLog", ""));
            stringDefault = this.fPersistentPreferences.getGdbServerOtherOptions();
            this.fGdbServerOtherOptions.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerOther", stringDefault));
            this.fDoGdbServerAllocateConsole.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerAllocateConsole", true));
            this.fDoGdbServerAllocateSemihostingConsole.setSelection(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerAllocateSemihostingConsole", true));
            stringDefault = this.fPersistentPreferences.getGdbClientExecutable();
            String gdbCommandAttr = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", stringDefault);
            this.fGdbClientExecutable.setText(gdbCommandAttr);
            stringDefault = this.fPersistentPreferences.getGdbClientOtherOptions();
            this.fGdbClientOtherOptions.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbClientOtherOptions", stringDefault));
            stringDefault = this.fPersistentPreferences.getGdbClientCommands();
            this.fGdbClientOtherCommands.setText(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbClientOtherCommands", stringDefault));
            this.fTargetIpAddress.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", "localhost"));
            int storedPort = 0;
            storedPort = configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", 0);
            if (storedPort <= 0 || 65535 < storedPort) {
                storedPort = 2331;
            }
            String portString = Integer.toString(storedPort);
            this.fTargetPortNumber.setText(portString);
            this.doStartGdbServerChanged();
            this.propagateConnectToRunningChanged();
            boolean updateThreadsOnSuspend = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
            this.fUpdateThreadlistOnSuspend.setSelection(updateThreadsOnSuspend);
        }
        catch (CoreException e) {
            Activator.log((IStatus)e.getStatus());
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.TabDebugger.initializeFrom() completed " + configuration.getName());
        }
    }

    public void initializeFromDefaults() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.TabDebugger.initializeFromDefaults()");
        }
        boolean booleanDefault = this.fDefaultPreferences.getGdbServerDoStart();
        this.fDoStartGdbServer.setSelection(booleanDefault);
        this.fDoConnectToRunning.setSelection(false);
        String stringDefault = this.fDefaultPreferences.getGdbServerExecutable();
        this.fGdbServerExecutable.setText(stringDefault);
        stringDefault = this.fSavedCmsisDeviceName != null ? this.fSavedCmsisDeviceName : "";
        this.fGdbFlashDeviceName.setText(stringDefault);
        String endianness = this.fDefaultPreferences.getGdbServerEndianness();
        if ("little".equals(endianness)) {
            this.fGdbEndiannessLittle.setSelection(true);
        } else if ("big".equals(endianness)) {
            this.fGdbEndiannessBig.setSelection(true);
        } else {
            String message = "unknown endianness " + endianness + ", using little";
            Activator.log((String)message);
            this.fGdbEndiannessLittle.setSelection(true);
        }
        String connection = this.fDefaultPreferences.getGdbServerConnection();
        if ("usb".equals(connection)) {
            this.fGdbServerConnectionUsb.setSelection(true);
            this.fGdbServerConnectionIp.setSelection(false);
        } else if ("ip".equals(connection)) {
            this.fGdbServerConnectionUsb.setSelection(false);
            this.fGdbServerConnectionIp.setSelection(true);
        }
        stringDefault = this.fDefaultPreferences.getGdbServerConnectionAddress();
        this.fGdbServerConnectionAddress.setText(stringDefault);
        String physicalInterface = this.fDefaultPreferences.getGdbServerInterface();
        if ("swd".equals(physicalInterface)) {
            this.fGdbInterfaceSwd.setSelection(true);
            this.fTabStartup.doInterfaceSwdChanged(true);
        } else if ("jtag".equals(physicalInterface)) {
            this.fGdbInterfaceJtag.setSelection(true);
            this.fTabStartup.doInterfaceSwdChanged(false);
        } else {
            String message = "unknown interface " + physicalInterface + ", using swd";
            Activator.log((String)message);
            this.fGdbInterfaceSwd.setSelection(true);
        }
        String physicalInterfaceSpeed = this.fDefaultPreferences.getGdbServerInitialSpeed();
        if ("auto".equals(physicalInterfaceSpeed)) {
            this.fGdbServerSpeedAuto.setSelection(true);
            this.fGdbServerSpeedAdaptive.setSelection(false);
            this.fGdbServerSpeedFixed.setSelection(false);
            this.fGdbServerSpeedFixedValue.setEnabled(false);
        } else if ("adaptive".equals(physicalInterfaceSpeed)) {
            this.fGdbServerSpeedAuto.setSelection(false);
            this.fGdbServerSpeedAdaptive.setSelection(true);
            this.fGdbServerSpeedFixed.setSelection(false);
            this.fGdbServerSpeedFixedValue.setEnabled(false);
        } else {
            try {
                Integer.parseInt(physicalInterfaceSpeed);
                this.fGdbServerSpeedAuto.setSelection(false);
                this.fGdbServerSpeedAdaptive.setSelection(false);
                this.fGdbServerSpeedFixed.setSelection(true);
                this.fGdbServerSpeedFixedValue.setEnabled(true);
                this.fGdbServerSpeedFixedValue.setText(physicalInterfaceSpeed);
            }
            catch (NumberFormatException e) {
                String message = "unknown interface speed " + physicalInterfaceSpeed + ", using auto";
                Activator.log((String)message);
                this.fGdbServerSpeedAuto.setSelection(true);
                this.fGdbServerSpeedFixedValue.setEnabled(false);
            }
        }
        this.fGdbServerGdbPort.setText(Integer.toString(2331));
        this.fGdbServerSwoPort.setText(Integer.toString(2332));
        this.fGdbServerTelnetPort.setText(Integer.toString(2333));
        this.fDoGdbServerVerifyDownload.setSelection(true);
        this.fDoGdbServerInitRegs.setSelection(true);
        this.fDoGdbServerLocalOnly.setSelection(true);
        this.fDoGdbServerSilent.setSelection(false);
        this.fGdbServerLog.setText("");
        stringDefault = this.fDefaultPreferences.getGdbServerOtherOptions();
        this.fGdbServerOtherOptions.setText(stringDefault);
        this.fDoGdbServerAllocateConsole.setSelection(true);
        this.fDoGdbServerAllocateSemihostingConsole.setSelection(true);
        stringDefault = this.fDefaultPreferences.getGdbClientExecutable();
        this.fGdbClientExecutable.setText(stringDefault);
        stringDefault = this.fDefaultPreferences.getGdbClientOtherOptions();
        this.fGdbClientOtherOptions.setText(stringDefault);
        stringDefault = this.fDefaultPreferences.getGdbClientCommands();
        this.fGdbClientOtherCommands.setText(stringDefault);
        this.fTargetIpAddress.setText("localhost");
        String portString = Integer.toString(2331);
        this.fTargetPortNumber.setText(portString);
        this.doStartGdbServerChanged();
        this.propagateConnectToRunningChanged();
        this.fUpdateThreadlistOnSuspend.setSelection(false);
    }

    public String getId() {
        return TAB_ID;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.TabDebugger.activated() " + workingCopy.getName());
        }
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.TabDebugger.deactivated() " + workingCopy.getName());
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.TabDebugger.isValid() " + launchConfig.getName());
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        boolean result = true;
        if (this.fDoStartGdbServer != null && this.fDoStartGdbServer.getSelection()) {
            if (this.fGdbServerExecutable != null && this.fGdbServerExecutable.getText().trim().isEmpty()) {
                this.setErrorMessage("GDB server executable path?");
                result = false;
            }
            if (this.fGdbFlashDeviceName != null && this.fGdbFlashDeviceName.getText().trim().isEmpty()) {
                this.setErrorMessage("Device name?");
                result = false;
            }
            if (this.fGdbServerGdbPort != null && this.fGdbServerGdbPort.getText().trim().isEmpty()) {
                this.setErrorMessage("GDB port?");
                result = false;
            }
            if (this.fGdbServerSwoPort != null && this.fGdbServerSwoPort.getText().trim().isEmpty()) {
                this.setErrorMessage("SWO port?");
                result = false;
            }
            if (this.fGdbServerTelnetPort != null && this.fGdbServerTelnetPort.getText().trim().isEmpty()) {
                this.setErrorMessage("Telenet port?");
                result = false;
            }
        }
        if (this.fGdbClientExecutable != null && this.fGdbClientExecutable.getText().trim().isEmpty()) {
            this.setErrorMessage("GDB client executable name?");
            result = false;
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.TabDebugger.isValid() " + launchConfig.getName() + " = " + result);
        }
        return result;
    }

    public boolean canSave() {
        if (this.fDoStartGdbServer != null && this.fDoStartGdbServer.getSelection()) {
            if (this.fGdbServerExecutable != null && this.fGdbServerExecutable.getText().trim().isEmpty()) {
                return false;
            }
            if (this.fGdbFlashDeviceName != null && this.fGdbFlashDeviceName.getText().trim().isEmpty()) {
                return false;
            }
            if (this.fGdbServerGdbPort != null && this.fGdbServerGdbPort.getText().trim().isEmpty()) {
                return false;
            }
            if (this.fGdbServerSwoPort != null && this.fGdbServerSwoPort.getText().trim().isEmpty()) {
                return false;
            }
            if (this.fGdbServerTelnetPort != null && this.fGdbServerTelnetPort.getText().trim().isEmpty()) {
                return false;
            }
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String message;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.TabDebugger.performApply() " + configuration.getName() + ", dirty=" + this.isDirty());
        }
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", "GNU MCU J-Link");
        boolean booleanValue = this.fDoStartGdbServer.getSelection();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doStartGdbServer", booleanValue);
        this.fPersistentPreferences.putGdbServerDoStart(booleanValue);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doConnectToRunning", this.fDoConnectToRunning.getSelection());
        String stringValue = this.fGdbServerExecutable.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerExecutable", stringValue);
        this.fPersistentPreferences.putGdbServerExecutable(stringValue);
        stringValue = this.fGdbFlashDeviceName.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerDeviceName", stringValue);
        this.fPersistentPreferences.putFlashDeviceName(stringValue);
        stringValue = this.fDefaultPreferences.getGdbServerEndianness();
        if (this.fGdbEndiannessLittle.getSelection()) {
            stringValue = "little";
        } else if (this.fGdbEndiannessBig.getSelection()) {
            stringValue = "big";
        } else {
            message = "endianness not selected, setting little";
            Activator.log((String)message);
        }
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerDeviceEndianness", stringValue);
        this.fPersistentPreferences.putGdbServerEndianness(stringValue);
        stringValue = this.fDefaultPreferences.getGdbServerConnection();
        if (this.fGdbServerConnectionUsb.getSelection()) {
            stringValue = "usb";
        } else if (this.fGdbServerConnectionIp.getSelection()) {
            stringValue = "ip";
        }
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerConnection", stringValue);
        this.fPersistentPreferences.putGdbServerConnection(stringValue);
        stringValue = this.fGdbServerConnectionAddress.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerConnectionAddress", stringValue);
        this.fPersistentPreferences.putGdbServerConnectionAddress(stringValue);
        stringValue = this.fDefaultPreferences.getGdbServerInterface();
        if (this.fGdbInterfaceSwd.getSelection()) {
            stringValue = "swd";
        } else if (this.fGdbInterfaceJtag.getSelection()) {
            stringValue = "jtag";
        } else {
            message = "interface not selected, setting swd";
            Activator.log((String)message);
            this.fGdbInterfaceSwd.setSelection(true);
        }
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerDebugInterface", stringValue);
        this.fPersistentPreferences.putGdbServerInterface(stringValue);
        stringValue = this.fDefaultPreferences.getGdbServerInitialSpeed();
        if (this.fGdbServerSpeedAuto.getSelection()) {
            stringValue = "auto";
        } else if (this.fGdbServerSpeedAdaptive.getSelection()) {
            stringValue = "adaptive";
        } else if (this.fGdbServerSpeedFixed.getSelection()) {
            if (!this.fGdbServerSpeedFixedValue.getText().trim().isEmpty()) {
                stringValue = this.fGdbServerSpeedFixedValue.getText().trim();
            } else {
                Activator.log((String)"empty fGdbServerSpeedFixedValue");
            }
        }
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerDeviceSpeed", stringValue);
        this.fPersistentPreferences.putGdbServerInitialSpeed(stringValue);
        if (!this.fGdbServerGdbPort.getText().trim().isEmpty()) {
            int port = Integer.parseInt(this.fGdbServerGdbPort.getText().trim());
            configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerGdbPortNumber", port);
        } else {
            Activator.log((String)"empty fGdbServerGdbPort");
        }
        if (!this.fGdbServerSwoPort.getText().trim().isEmpty()) {
            int port = Integer.parseInt(this.fGdbServerSwoPort.getText().trim());
            configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerSwoPortNumber", port);
        } else {
            Activator.log((String)"empty fGdbServerSwoPort");
        }
        if (!this.fGdbServerTelnetPort.getText().trim().isEmpty()) {
            int port = Integer.parseInt(this.fGdbServerTelnetPort.getText().trim());
            configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerTelnetPortNumber", port);
        } else {
            Activator.log((String)"empty fGdbServerTelnetPort");
        }
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerVerifyDownload", this.fDoGdbServerVerifyDownload.getSelection());
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerInitRegs", this.fDoGdbServerInitRegs.getSelection());
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerLocalOnly", this.fDoGdbServerLocalOnly.getSelection());
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerSilent", this.fDoGdbServerSilent.getSelection());
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerLog", this.fGdbServerLog.getText().trim());
        stringValue = this.fGdbServerOtherOptions.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerOther", stringValue);
        this.fPersistentPreferences.putGdbServerOtherOptions(stringValue);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerAllocateConsole", this.fDoGdbServerAllocateConsole.getSelection());
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerAllocateSemihostingConsole", this.fDoGdbServerAllocateSemihostingConsole.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
        stringValue = this.fGdbClientExecutable.getText().trim();
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", stringValue);
        this.fPersistentPreferences.putGdbClientExecutable(stringValue);
        stringValue = this.fGdbClientOtherOptions.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbClientOtherOptions", stringValue);
        this.fPersistentPreferences.putGdbClientOtherOptions(stringValue);
        stringValue = this.fGdbClientOtherCommands.getText().trim();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbClientOtherCommands", stringValue);
        this.fPersistentPreferences.putGdbClientCommands(stringValue);
        if (this.fDoStartGdbServer.getSelection()) {
            configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", "localhost");
            String str = this.fGdbServerGdbPort.getText().trim();
            if (!str.isEmpty()) {
                try {
                    int port = Integer.parseInt(str);
                    configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", port);
                }
                catch (NumberFormatException e) {
                    Activator.log((Throwable)e);
                }
            }
        } else {
            String ip = this.fTargetIpAddress.getText().trim();
            configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", ip);
            String str = this.fTargetPortNumber.getText().trim();
            if (!str.isEmpty()) {
                try {
                    int port = Integer.valueOf(str);
                    configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", port);
                }
                catch (NumberFormatException e) {
                    Activator.log((Throwable)e);
                }
            }
        }
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", this.fUpdateThreadlistOnSuspend.getSelection());
        this.fPersistentPreferences.flush();
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.TabDebugger.performApply() completed " + configuration.getName() + ", dirty=" + this.isDirty());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("jlink.TabDebugger.setDefaults() " + configuration.getName());
        }
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", "GNU MCU J-Link");
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
        boolean defaultBoolean = this.fPersistentPreferences.getGdbServerDoStart();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doStartGdbServer", defaultBoolean);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doConnectToRunning", false);
        String defaultString = this.fPersistentPreferences.getGdbServerExecutable();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerExecutable", defaultString);
        String sharedName = CProjectAttributes.getCmsisDeviceVariantName((ILaunchConfiguration)configuration);
        if (sharedName == null || sharedName.isEmpty()) {
            sharedName = this.fPersistentPreferences.getFlashDeviceName();
        }
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerDeviceName", sharedName);
        defaultString = this.fPersistentPreferences.getGdbServerEndianness();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerDeviceEndianness", defaultString);
        defaultString = this.fPersistentPreferences.getGdbServerConnection();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerConnection", defaultString);
        defaultString = this.fPersistentPreferences.getGdbServerConnectionAddress();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerConnectionAddress", defaultString);
        defaultString = this.fPersistentPreferences.getGdbServerInterface();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerDebugInterface", defaultString);
        defaultString = this.fPersistentPreferences.getGdbServerInitialSpeed();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerDeviceSpeed", defaultString);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerGdbPortNumber", 2331);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerSwoPortNumber", 2332);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerTelnetPortNumber", 2333);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerVerifyDownload", true);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerInitRegs", true);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerLocalOnly", true);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerSilent", false);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerLog", "");
        defaultString = this.fPersistentPreferences.getGdbServerOtherOptions();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerOther", defaultString);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerAllocateConsole", true);
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.doGdbServerAllocateSemihostingConsole", true);
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", this.fPersistentPreferences.getGdbClientExecutable());
        defaultString = this.fPersistentPreferences.getGdbClientOtherOptions();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbClientOtherOptions", this.fDefaultPreferences.getGdbClientOtherOptions());
        defaultString = this.fPersistentPreferences.getGdbClientCommands();
        configuration.setAttribute("ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbClientOtherCommands", defaultString);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.portNumber", 2331);
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
    }
}

