/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.ui.rendering;

import org.eclipse.elk.core.ui.rendering.GraphRenderer;
import org.eclipse.elk.core.ui.rendering.GraphRenderingConfigurator;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class GraphRenderingCanvas
extends Canvas
implements PaintListener {
    private ElkNode layoutGraph;
    private GraphRenderer graphRenderer;
    private Color backgroundColor;

    public GraphRenderingCanvas(Composite parent) {
        super(parent, 0);
        this.addPaintListener(this);
        this.graphRenderer = new GraphRenderer(new GraphRenderingConfigurator(parent.getDisplay()));
        this.backgroundColor = new Color((Device)parent.getDisplay(), 255, 255, 255);
        this.setBackground(this.backgroundColor);
    }

    public GraphRenderingCanvas(Composite parent, GraphRenderingConfigurator configurator) {
        super(parent, 0);
        if (!configurator.getDisplay().equals(parent.getDisplay())) {
            throw new IllegalArgumentException("configurator and parent composite must use the same display.");
        }
        this.addPaintListener(this);
        this.graphRenderer = new GraphRenderer(configurator);
        this.backgroundColor = new Color((Device)parent.getDisplay(), 255, 255, 255);
        this.setBackground(this.backgroundColor);
    }

    public void dispose() {
        this.graphRenderer.dispose();
        this.backgroundColor.dispose();
    }

    public void setLayoutGraph(ElkNode thelayoutGraph) {
        if (thelayoutGraph != null) {
            this.setSize(new Point((int)thelayoutGraph.getWidth() + 1, (int)thelayoutGraph.getHeight() + 1));
        }
        this.layoutGraph = thelayoutGraph;
        this.redraw();
    }

    public ElkNode getLayoutGraph() {
        return this.layoutGraph;
    }

    public GraphRenderer getRenderer() {
        return this.graphRenderer;
    }

    public void paintControl(PaintEvent event) {
        if (this.layoutGraph != null) {
            Rectangle area = new Rectangle(event.x, event.y, event.width, event.height);
            this.graphRenderer.markDirty(area);
            this.graphRenderer.render(this.layoutGraph, event.gc, area);
        }
    }
}

